/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.flow;

import jakarta.faces.FacesWrapper;
import jakarta.faces.application.ConfigurableNavigationHandler;
import jakarta.faces.application.NavigationCase;
import jakarta.faces.application.NavigationHandler;
import jakarta.faces.application.NavigationHandlerWrapper;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.SystemEvent;
import jakarta.faces.event.SystemEventListener;
import jakarta.faces.flow.Flow;
import jakarta.faces.flow.FlowCallNode;
import jakarta.faces.flow.FlowHandler;
import jakarta.faces.flow.FlowNode;
import jakarta.faces.flow.Parameter;
import jakarta.faces.flow.ReturnNode;
import jakarta.faces.lifecycle.ClientWindow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.myfaces.core.api.shared.lang.Assert;
import org.apache.myfaces.event.PostClientWindowAndViewInitializedEvent;
import org.apache.myfaces.flow.FlowReference;
import org.apache.myfaces.flow._FlowContextualInfo;
import org.apache.myfaces.spi.FacesFlowProvider;
import org.apache.myfaces.spi.FacesFlowProviderFactory;
import org.apache.myfaces.util.lang.StringUtils;

public class FlowHandlerImpl
extends FlowHandler
implements SystemEventListener {
    private static final String CURRENT_FLOW_STACK = "oam.flow.STACK.";
    private static final String ROOT_LAST_VIEW_ID = "oam.flow.ROOT_LAST_VIEW_ID.";
    private static final String RETURN_MODE = "oam.flow.RETURN_MODE";
    private static final String FLOW_RETURN_STACK = "oam.flow.RETURN_STACK.";
    private static final String CURRENT_FLOW_REQUEST_STACK = "oam.flow.REQUEST_STACK.";
    private Map<String, Map<String, Flow>> _flowMapByDocumentId = new ConcurrentHashMap<String, Map<String, Flow>>();
    private Map<String, Flow> _flowMapById = new ConcurrentHashMap<String, Flow>();
    private FacesFlowProvider _facesFlowProvider;

    public Flow getFlow(FacesContext context, String definingDocumentId, String id) {
        Flow flow;
        Assert.notNull((Object)context, (String)"context");
        Assert.notNull((Object)definingDocumentId, (String)"definingDocumentId");
        Assert.notNull((Object)id, (String)"id");
        Map<String, Flow> flowMap = this._flowMapByDocumentId.get(definingDocumentId);
        if (flowMap != null && (flow = flowMap.get(id)) != null) {
            return flow;
        }
        if (StringUtils.isEmpty(definingDocumentId)) {
            return this._flowMapById.get(id);
        }
        return null;
    }

    public void addFlow(FacesContext context, Flow toAdd) {
        Assert.notNull((Object)context, (String)"context");
        Assert.notNull((Object)toAdd, (String)"toAdd");
        String id = toAdd.getId();
        String definingDocumentId = toAdd.getDefiningDocumentId();
        if (id == null) {
            throw new IllegalArgumentException("Flow must have a non null id");
        }
        if (id.length() == 0) {
            throw new IllegalArgumentException("Flow must have a non empty id");
        }
        if (definingDocumentId == null) {
            throw new IllegalArgumentException("Flow must have a non null definingDocumentId");
        }
        Map flowMap = this._flowMapByDocumentId.computeIfAbsent(definingDocumentId, k -> new ConcurrentHashMap());
        flowMap.put(id, toAdd);
        Flow duplicateFlow = this._flowMapById.get(id);
        if (duplicateFlow != null) {
            if (toAdd.getDefiningDocumentId().equals(duplicateFlow.getDefiningDocumentId())) {
                throw new IllegalArgumentException("There cannot be multiple flows with both the same ID and the same definingDocumentId");
            }
            if ("".equals(toAdd.getDefiningDocumentId())) {
                this._flowMapById.put(id, toAdd);
            } else if (!"".equals(duplicateFlow.getDefiningDocumentId())) {
                this._flowMapById.put(id, toAdd);
            }
        } else {
            this._flowMapById.put(id, toAdd);
        }
        this.invokeInspectFlow(context, context.getApplication().getNavigationHandler(), toAdd);
    }

    public Flow getCurrentFlow(FacesContext context) {
        Object session = context.getExternalContext().getSession(false);
        if (session == null) {
            return null;
        }
        ClientWindow clientWindow = context.getExternalContext().getClientWindow();
        if (clientWindow == null) {
            return null;
        }
        _FlowContextualInfo info = this.getCurrentFlowReference(context, clientWindow);
        if (info == null) {
            return null;
        }
        FlowReference flowReference = info.getFlowReference();
        return this.getFlow(context, flowReference.getDocumentId(), flowReference.getId());
    }

    public void transition(FacesContext context, Flow sourceFlow, Flow targetFlow, FlowCallNode outboundCallNode, String toViewId) {
        FlowReference parentFlowReference;
        Assert.notNull((Object)context, (String)"context");
        Assert.notNull((Object)toViewId, (String)"toViewId");
        ClientWindow clientWindow = context.getExternalContext().getClientWindow();
        boolean outboundCallNodeProcessed = false;
        if (clientWindow == null) {
            return;
        }
        if (sourceFlow == null && targetFlow == null) {
            return;
        }
        FlowReference flowReference = parentFlowReference = outboundCallNode != null && sourceFlow != null ? new FlowReference(sourceFlow.getDefiningDocumentId(), sourceFlow.getId()) : null;
        if (sourceFlow == null) {
            Map<String, Object> outboundParameters = this.doBeforeEnterFlow(context, targetFlow, (FlowCallNode)(!outboundCallNodeProcessed ? outboundCallNode : null));
            outboundCallNodeProcessed = true;
            this.pushFlowReference(context, clientWindow, new FlowReference(targetFlow.getDefiningDocumentId(), targetFlow.getId()), toViewId, parentFlowReference);
            this.doAfterEnterFlow(context, targetFlow, outboundParameters);
        } else if (targetFlow == null) {
            List<_FlowContextualInfo> currentFlowStack = this.getCurrentFlowStack(context, clientWindow);
            if (currentFlowStack != null) {
                this.removeFlowFromStack(context, currentFlowStack, sourceFlow);
            }
        } else {
            List<_FlowContextualInfo> currentFlowStack = this.getCurrentFlowStack(context, clientWindow);
            if (currentFlowStack != null && outboundCallNode == null) {
                FlowReference targetFlowReference = new FlowReference(targetFlow.getDefiningDocumentId(), targetFlow.getId());
                int targetFlowIndex = -1;
                for (int j = currentFlowStack.size() - 1; j >= 0; --j) {
                    if (!targetFlowReference.equals(currentFlowStack.get(j).getFlowReference())) continue;
                    targetFlowIndex = j;
                    break;
                }
                if (targetFlowIndex >= 0) {
                    this.removeFlowFromStack(context, currentFlowStack, sourceFlow);
                } else {
                    Map<String, Object> outboundParameters = this.doBeforeEnterFlow(context, targetFlow, (FlowCallNode)(!outboundCallNodeProcessed ? outboundCallNode : null));
                    outboundCallNodeProcessed = true;
                    this.pushFlowReference(context, clientWindow, new FlowReference(targetFlow.getDefiningDocumentId(), targetFlow.getId()), toViewId, parentFlowReference);
                    this.doAfterEnterFlow(context, targetFlow, outboundParameters);
                }
            } else {
                Map<String, Object> outboundParameters = this.doBeforeEnterFlow(context, targetFlow, (FlowCallNode)(!outboundCallNodeProcessed ? outboundCallNode : null));
                outboundCallNodeProcessed = true;
                this.pushFlowReference(context, clientWindow, new FlowReference(targetFlow.getDefiningDocumentId(), targetFlow.getId()), toViewId, parentFlowReference);
                this.doAfterEnterFlow(context, targetFlow, outboundParameters);
            }
        }
    }

    private void removeFlowFromStack(FacesContext context, List<_FlowContextualInfo> currentFlowStack, Flow sourceFlow) {
        _FlowContextualInfo fci;
        int i;
        int sourceFlowIndex = -1;
        FlowReference sourceFlowReference = new FlowReference(sourceFlow.getDefiningDocumentId(), sourceFlow.getId());
        ArrayList<_FlowContextualInfo> flowsToRemove = new ArrayList<_FlowContextualInfo>();
        for (i = currentFlowStack.size() - 1; i >= 0; --i) {
            fci = currentFlowStack.get(i);
            if (!fci.getFlowReference().equals(sourceFlowReference)) continue;
            sourceFlowIndex = i;
            flowsToRemove.add(fci);
            break;
        }
        if (sourceFlowIndex != -1) {
            this.traverseDependantFlows(sourceFlowReference, sourceFlowIndex + 1, currentFlowStack, flowsToRemove);
            if (!flowsToRemove.isEmpty()) {
                block1: for (i = flowsToRemove.size() - 1; i >= 0; --i) {
                    fci = (_FlowContextualInfo)flowsToRemove.get(i);
                    FlowReference fr = fci.getFlowReference();
                    this.doBeforeExitFlow(context, this.getFlow(context, fr.getDocumentId(), fr.getId()));
                    for (int j = currentFlowStack.size() - 1; j >= 0; --j) {
                        if (currentFlowStack.get(j) != fci) continue;
                        currentFlowStack.remove(j);
                        continue block1;
                    }
                }
            }
            if (currentFlowStack.isEmpty()) {
                context.getAttributes().put(ROOT_LAST_VIEW_ID, context.getExternalContext().getSessionMap().remove(ROOT_LAST_VIEW_ID + context.getExternalContext().getClientWindow().getId()));
            }
        }
    }

    private void traverseDependantFlows(FlowReference sourceFlowReference, int index, List<_FlowContextualInfo> currentFlowStack, List<_FlowContextualInfo> flowsToRemove) {
        if (index < currentFlowStack.size()) {
            for (int i = index; i < currentFlowStack.size(); ++i) {
                _FlowContextualInfo info = currentFlowStack.get(i);
                if (!sourceFlowReference.equals(info.getSourceFlowReference()) || flowsToRemove.contains(info)) continue;
                flowsToRemove.add(info);
                this.traverseDependantFlows(info.getFlowReference(), i + 1, currentFlowStack, flowsToRemove);
            }
        }
    }

    private Map<String, Object> doBeforeEnterFlow(FacesContext context, Flow flow, FlowCallNode outboundCallNode) {
        HashMap<String, Object> outboundParameters = null;
        if (outboundCallNode != null && !outboundCallNode.getOutboundParameters().isEmpty()) {
            outboundParameters = new HashMap<String, Object>();
            for (Map.Entry entry : outboundCallNode.getOutboundParameters().entrySet()) {
                Parameter parameter = (Parameter)entry.getValue();
                if (parameter.getValue() == null) continue;
                outboundParameters.put((String)entry.getKey(), parameter.getValue().getValue(context.getELContext()));
            }
        }
        return outboundParameters;
    }

    private void doAfterEnterFlow(FacesContext context, Flow flow, Map<String, Object> outboundParameters) {
        this.getFacesFlowProvider(context).doAfterEnterFlow(context, flow);
        if (outboundParameters != null) {
            for (Map.Entry entry : flow.getInboundParameters().entrySet()) {
                Parameter parameter = (Parameter)entry.getValue();
                if (parameter.getValue() == null || !outboundParameters.containsKey(entry.getKey())) continue;
                parameter.getValue().setValue(context.getELContext(), outboundParameters.get(entry.getKey()));
            }
        }
        if (flow.getInitializer() != null) {
            flow.getInitializer().invoke(context.getELContext(), null);
        }
    }

    public FacesFlowProvider getFacesFlowProvider(FacesContext facesContext) {
        if (this._facesFlowProvider == null) {
            FacesFlowProviderFactory factory = FacesFlowProviderFactory.getFacesFlowProviderFactory(facesContext.getExternalContext());
            this._facesFlowProvider = factory.getFacesFlowProvider(facesContext.getExternalContext());
            facesContext.getApplication().unsubscribeFromEvent(PostClientWindowAndViewInitializedEvent.class, (SystemEventListener)this);
            facesContext.getApplication().subscribeToEvent(PostClientWindowAndViewInitializedEvent.class, (SystemEventListener)this);
        }
        return this._facesFlowProvider;
    }

    private void doBeforeExitFlow(FacesContext context, Flow flow) {
        if (flow.getFinalizer() != null) {
            flow.getFinalizer().invoke(context.getELContext(), null);
        }
        this.getFacesFlowProvider(context).doBeforeExitFlow(context, flow);
    }

    public boolean isActive(FacesContext context, String definingDocumentId, String id) {
        String currentFlowMapKey;
        Assert.notNull((Object)context, (String)"context");
        Assert.notNull((Object)definingDocumentId, (String)"definingDocumentId");
        Assert.notNull((Object)id, (String)"id");
        Object session = context.getExternalContext().getSession(false);
        if (session == null) {
            return false;
        }
        ClientWindow clientWindow = context.getExternalContext().getClientWindow();
        if (clientWindow == null) {
            return false;
        }
        Map sessionMap = context.getExternalContext().getSessionMap();
        List currentFlowStack = (List)sessionMap.get(currentFlowMapKey = CURRENT_FLOW_STACK + clientWindow.getId());
        if (currentFlowStack == null) {
            return false;
        }
        FlowReference reference = new FlowReference(definingDocumentId, id);
        for (_FlowContextualInfo info : currentFlowStack) {
            if (!reference.equals(info.getFlowReference())) continue;
            return true;
        }
        return false;
    }

    public Map<Object, Object> getCurrentFlowScope() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return this.getFacesFlowProvider(facesContext).getCurrentFlowScope(facesContext);
    }

    public void clientWindowTransition(FacesContext context) {
        block28: {
            String calledFlowDocumentId;
            ConfigurableNavigationHandler nh;
            FlowHandler flowHandler;
            String flowIdRequestParam;
            String flowDocumentIdRequestParam;
            block29: {
                int j;
                flowDocumentIdRequestParam = (String)context.getExternalContext().getRequestParameterMap().get("jftfdi");
                if (flowDocumentIdRequestParam == null) break block28;
                flowIdRequestParam = (String)context.getExternalContext().getRequestParameterMap().get("jffi");
                if (flowIdRequestParam == null) {
                    return;
                }
                flowHandler = context.getApplication().getFlowHandler();
                nh = (ConfigurableNavigationHandler)context.getApplication().getNavigationHandler();
                if (!"jakarta.faces.flow.NullFlow".equals(flowDocumentIdRequestParam)) break block29;
                String toFlowDocumentId = "jakarta.faces.flow.NullFlow";
                String fromOutcome = flowIdRequestParam;
                ArrayList<Flow> sourceFlows = null;
                ArrayList<Flow> targetFlows = null;
                boolean failed = false;
                int i = 0;
                while ("jakarta.faces.flow.NullFlow".equals(toFlowDocumentId) && !failed) {
                    Flow currentFlow = flowHandler.getCurrentFlow(context);
                    if (currentFlow == null) {
                        failed = true;
                        break;
                    }
                    String currentLastDisplayedViewId = flowHandler.getLastDisplayedViewId(context);
                    FlowNode node = currentFlow.getNode(fromOutcome);
                    if (node instanceof ReturnNode) {
                        if (targetFlows == null) {
                            sourceFlows = new ArrayList<Flow>(4);
                            targetFlows = new ArrayList<Flow>(4);
                        }
                        Flow sourceFlow = currentFlow;
                        flowHandler.pushReturnMode(context);
                        currentFlow = flowHandler.getCurrentFlow(context);
                        ++i;
                        NavigationCase navCase = nh.getNavigationCase(context, null, ((ReturnNode)node).getFromOutcome(context), "jakarta.faces.flow.NullFlow");
                        if (navCase == null) {
                            if (currentLastDisplayedViewId != null) {
                                sourceFlows.add(sourceFlow);
                                if (currentFlow != null) {
                                    toFlowDocumentId = currentFlow.getDefiningDocumentId();
                                    targetFlows.add(currentFlow);
                                    continue;
                                }
                                toFlowDocumentId = null;
                                targetFlows.add(null);
                                continue;
                            }
                            failed = true;
                            continue;
                        }
                        if ("jakarta.faces.flow.NullFlow".equals(navCase.getToFlowDocumentId())) {
                            fromOutcome = navCase.getFromOutcome();
                            continue;
                        }
                        sourceFlows.add(sourceFlow);
                        if (currentFlow != null) {
                            toFlowDocumentId = currentFlow.getDefiningDocumentId();
                            targetFlows.add(currentFlow);
                            continue;
                        }
                        toFlowDocumentId = null;
                        targetFlows.add(null);
                        continue;
                    }
                    flowHandler.pushReturnMode(context);
                    currentFlow = flowHandler.getCurrentFlow(context);
                    ++i;
                    if (currentFlow != null) continue;
                    failed = true;
                }
                for (j = 0; j < i; ++j) {
                    flowHandler.popReturnMode(context);
                }
                if (failed) break block28;
                for (j = 0; j < targetFlows.size(); ++j) {
                    Flow sourceFlow = (Flow)sourceFlows.get(j);
                    Flow targetFlow = (Flow)targetFlows.get(j);
                    flowHandler.transition(context, sourceFlow, targetFlow, null, context.getViewRoot().getViewId());
                }
                break block28;
            }
            Flow targetFlow = flowHandler.getFlow(context, flowDocumentIdRequestParam, flowIdRequestParam);
            Flow currentFlow = null;
            FlowCallNode outboundCallNode = null;
            FlowNode node = null;
            if (targetFlow == null) {
                List<Flow> activeFlows = FlowHandlerImpl.getActiveFlows(context, flowHandler);
                for (Flow activeFlow : activeFlows) {
                    node = activeFlow != null ? activeFlow.getNode(flowIdRequestParam) : null;
                    if (node == null || !(node instanceof FlowCallNode)) continue;
                    outboundCallNode = (FlowCallNode)node;
                    calledFlowDocumentId = outboundCallNode.getCalledFlowDocumentId(context);
                    if (calledFlowDocumentId == null) {
                        calledFlowDocumentId = activeFlow.getDefiningDocumentId();
                    }
                    if ((targetFlow = flowHandler.getFlow(context, calledFlowDocumentId, outboundCallNode.getCalledFlowId(context))) == null && !"".equals(calledFlowDocumentId)) {
                        targetFlow = flowHandler.getFlow(context, "", outboundCallNode.getCalledFlowId(context));
                    }
                    if (targetFlow == null) continue;
                    currentFlow = activeFlow;
                    break;
                }
            }
            if (targetFlow != null) {
                if (flowHandler.isActive(context, targetFlow.getDefiningDocumentId(), targetFlow.getId())) {
                    Flow baseReturnFlow = flowHandler.getCurrentFlow();
                    if (!baseReturnFlow.getDefiningDocumentId().equals(targetFlow.getDefiningDocumentId()) || !baseReturnFlow.getId().equals(targetFlow.getId())) {
                        flowHandler.transition(context, baseReturnFlow, targetFlow, outboundCallNode, context.getViewRoot().getViewId());
                    }
                    flowHandler.pushReturnMode(context);
                    Flow previousFlow = flowHandler.getCurrentFlow(context);
                    flowHandler.popReturnMode(context);
                    flowHandler.transition(context, targetFlow, previousFlow, outboundCallNode, context.getViewRoot().getViewId());
                }
                flowHandler.transition(context, currentFlow, targetFlow, outboundCallNode, context.getViewRoot().getViewId());
                boolean failed = false;
                String startNodeId = targetFlow.getStartNodeId();
                while (startNodeId != null && !failed) {
                    NavigationCase navCase = nh.getNavigationCase(context, null, startNodeId, targetFlow.getDefiningDocumentId());
                    if (navCase != null && navCase.getToFlowDocumentId() != null) {
                        currentFlow = flowHandler.getCurrentFlow(context);
                        node = currentFlow.getNode(navCase.getFromOutcome());
                        if (node != null && node instanceof FlowCallNode) {
                            outboundCallNode = (FlowCallNode)node;
                            calledFlowDocumentId = outboundCallNode.getCalledFlowDocumentId(context);
                            if (calledFlowDocumentId == null) {
                                calledFlowDocumentId = currentFlow.getDefiningDocumentId();
                            }
                            if ((targetFlow = flowHandler.getFlow(context, calledFlowDocumentId, outboundCallNode.getCalledFlowId(context))) == null && !"".equals(calledFlowDocumentId)) {
                                targetFlow = flowHandler.getFlow(context, "", outboundCallNode.getCalledFlowId(context));
                            }
                        } else {
                            calledFlowDocumentId = navCase.getToFlowDocumentId();
                            if (calledFlowDocumentId == null) {
                                calledFlowDocumentId = currentFlow.getDefiningDocumentId();
                            }
                            if ((targetFlow = flowHandler.getFlow(context, calledFlowDocumentId, navCase.getFromOutcome())) == null && !"".equals(calledFlowDocumentId)) {
                                targetFlow = flowHandler.getFlow(context, "", navCase.getFromOutcome());
                            }
                        }
                        if (targetFlow != null) {
                            flowHandler.transition(context, currentFlow, targetFlow, outboundCallNode, context.getViewRoot().getViewId());
                            startNodeId = targetFlow.getStartNodeId();
                            continue;
                        }
                        startNodeId = null;
                        continue;
                    }
                    startNodeId = null;
                }
            }
        }
    }

    private void invokeInspectFlow(FacesContext context, NavigationHandler navHandler, Flow toAdd) {
        if (navHandler instanceof ConfigurableNavigationHandler) {
            ((ConfigurableNavigationHandler)navHandler).inspectFlow(context, toAdd);
        } else if (navHandler instanceof NavigationHandlerWrapper) {
            this.invokeInspectFlow(context, ((NavigationHandlerWrapper)navHandler).getWrapped(), toAdd);
        }
    }

    private _FlowContextualInfo getCurrentFlowReference(FacesContext context, ClientWindow clientWindow) {
        String currentFlowMapKey;
        if (Boolean.TRUE.equals(context.getAttributes().get(RETURN_MODE))) {
            List<_FlowContextualInfo> returnFlowList = this.getCurrentReturnModeFlowStack(context, clientWindow, CURRENT_FLOW_REQUEST_STACK);
            if (returnFlowList != null && !returnFlowList.isEmpty()) {
                _FlowContextualInfo info = returnFlowList.get(returnFlowList.size() - 1);
                return info;
            }
            return null;
        }
        Map sessionMap = context.getExternalContext().getSessionMap();
        List currentFlowStack = (List)sessionMap.get(currentFlowMapKey = CURRENT_FLOW_STACK + clientWindow.getId());
        if (currentFlowStack == null) {
            return null;
        }
        return currentFlowStack.isEmpty() ? null : (_FlowContextualInfo)currentFlowStack.get(currentFlowStack.size() - 1);
    }

    private void pushFlowReference(FacesContext context, ClientWindow clientWindow, FlowReference flowReference, String toViewId, FlowReference sourceFlowReference) {
        String currentFlowMapKey;
        Map sessionMap = context.getExternalContext().getSessionMap();
        List currentFlowStack = (List)sessionMap.computeIfAbsent(currentFlowMapKey = CURRENT_FLOW_STACK + clientWindow.getId(), k -> new ArrayList(4));
        if (!currentFlowStack.isEmpty()) {
            ((_FlowContextualInfo)currentFlowStack.get(currentFlowStack.size() - 1)).setLastDisplayedViewId(context.getViewRoot().getViewId());
        } else {
            context.getExternalContext().getSessionMap().put(ROOT_LAST_VIEW_ID + clientWindow.getId(), context.getViewRoot().getViewId());
        }
        currentFlowStack.add(new _FlowContextualInfo(flowReference, toViewId, sourceFlowReference));
    }

    private List<_FlowContextualInfo> getCurrentFlowStack(FacesContext context, ClientWindow clientWindow) {
        Map sessionMap = context.getExternalContext().getSessionMap();
        String currentFlowMapKey = CURRENT_FLOW_STACK + clientWindow.getId();
        List currentFlowStack = (List)sessionMap.get(currentFlowMapKey);
        return currentFlowStack;
    }

    public String getLastDisplayedViewId(FacesContext context) {
        Object session = context.getExternalContext().getSession(false);
        if (session == null) {
            return null;
        }
        ClientWindow clientWindow = context.getExternalContext().getClientWindow();
        if (clientWindow == null) {
            return null;
        }
        _FlowContextualInfo info = this.getCurrentFlowReference(context, clientWindow);
        if (info == null) {
            String lastDisplayedViewId = (String)context.getAttributes().get(ROOT_LAST_VIEW_ID);
            if (lastDisplayedViewId == null) {
                lastDisplayedViewId = (String)context.getExternalContext().getSessionMap().get(ROOT_LAST_VIEW_ID + clientWindow.getId());
            }
            return lastDisplayedViewId;
        }
        return info.getLastDisplayedViewId();
    }

    public void pushReturnMode(FacesContext context) {
        ClientWindow clientWindow = context.getExternalContext().getClientWindow();
        if (clientWindow == null) {
            return;
        }
        if (!Boolean.TRUE.equals(context.getAttributes().get(RETURN_MODE))) {
            List<_FlowContextualInfo> currentFlowStack = this.getCurrentFlowStack(context, clientWindow);
            Map attributesMap = context.getAttributes();
            String returnFlowMapKey = CURRENT_FLOW_REQUEST_STACK + clientWindow.getId();
            ArrayList<_FlowContextualInfo> returnFlowStack = new ArrayList<_FlowContextualInfo>(currentFlowStack);
            attributesMap.put(returnFlowMapKey, returnFlowStack);
            context.getAttributes().put(RETURN_MODE, Boolean.TRUE);
        }
        _FlowContextualInfo flowReference = this.popFlowReferenceReturnMode(context, clientWindow, CURRENT_FLOW_REQUEST_STACK);
        this.pushFlowReferenceReturnMode(context, clientWindow, FLOW_RETURN_STACK, flowReference);
    }

    public void popReturnMode(FacesContext context) {
        ClientWindow clientWindow = context.getExternalContext().getClientWindow();
        if (clientWindow == null) {
            return;
        }
        _FlowContextualInfo flowReference = this.popFlowReferenceReturnMode(context, clientWindow, FLOW_RETURN_STACK);
        this.pushFlowReferenceReturnMode(context, clientWindow, CURRENT_FLOW_REQUEST_STACK, flowReference);
        Map attributesMap = context.getAttributes();
        String returnFlowMapKey = FLOW_RETURN_STACK + clientWindow.getId();
        List returnFlowStack = (List)attributesMap.get(returnFlowMapKey);
        if (returnFlowStack != null && returnFlowStack.isEmpty()) {
            context.getAttributes().put(RETURN_MODE, Boolean.FALSE);
        }
    }

    public List<Flow> getActiveFlows(FacesContext context) {
        String currentFlowMapKey;
        Object session = context.getExternalContext().getSession(false);
        if (session == null) {
            return Collections.emptyList();
        }
        ClientWindow clientWindow = context.getExternalContext().getClientWindow();
        if (clientWindow == null) {
            return Collections.emptyList();
        }
        if (Boolean.TRUE.equals(context.getAttributes().get(RETURN_MODE))) {
            FlowHandler fh = context.getApplication().getFlowHandler();
            Flow curFlow = fh.getCurrentFlow(context);
            if (curFlow != null) {
                ArrayList<Flow> activeFlows = new ArrayList<Flow>();
                while (curFlow != null) {
                    activeFlows.add(curFlow);
                    fh.pushReturnMode(context);
                    curFlow = fh.getCurrentFlow(context);
                }
                for (int i = 0; i < activeFlows.size(); ++i) {
                    fh.popReturnMode(context);
                }
                return activeFlows;
            }
            return Collections.emptyList();
        }
        Map sessionMap = context.getExternalContext().getSessionMap();
        List currentFlowStack = (List)sessionMap.get(currentFlowMapKey = CURRENT_FLOW_STACK + clientWindow.getId());
        if (currentFlowStack == null) {
            return Collections.emptyList();
        }
        if (!currentFlowStack.isEmpty()) {
            ArrayList<Flow> activeFlows = new ArrayList<Flow>();
            for (_FlowContextualInfo info : currentFlowStack) {
                activeFlows.add(0, this.getFlow(context, info.getFlowReference().getDocumentId(), info.getFlowReference().getId()));
            }
            return activeFlows;
        }
        return Collections.emptyList();
    }

    private void pushFlowReferenceReturnMode(FacesContext context, ClientWindow clientWindow, String stackKey, _FlowContextualInfo flowReference) {
        Map attributesMap = context.getAttributes();
        String currentFlowMapKey = stackKey + clientWindow.getId();
        List currentFlowStack = (List)attributesMap.computeIfAbsent(currentFlowMapKey, k -> new ArrayList(4));
        currentFlowStack.add(flowReference);
    }

    private _FlowContextualInfo popFlowReferenceReturnMode(FacesContext context, ClientWindow clientWindow, String stackKey) {
        String currentFlowMapKey;
        Map attributesMap = context.getAttributes();
        List currentFlowStack = (List)attributesMap.get(currentFlowMapKey = stackKey + clientWindow.getId());
        if (currentFlowStack == null) {
            return null;
        }
        return currentFlowStack.isEmpty() ? null : (_FlowContextualInfo)currentFlowStack.remove(currentFlowStack.size() - 1);
    }

    private List<_FlowContextualInfo> getCurrentReturnModeFlowStack(FacesContext context, ClientWindow clientWindow, String stackKey) {
        Map attributesMap = context.getAttributes();
        String currentFlowMapKey = stackKey + clientWindow.getId();
        List currentFlowStack = (List)attributesMap.get(currentFlowMapKey);
        return currentFlowStack;
    }

    public static List<Flow> getActiveFlows(FacesContext facesContext, FlowHandler fh) {
        FlowHandler flowHandler = fh;
        while (flowHandler != null && !(flowHandler instanceof FlowHandlerImpl)) {
            if (flowHandler instanceof FacesWrapper) {
                flowHandler = (FlowHandler)((FacesWrapper)flowHandler).getWrapped();
                continue;
            }
            flowHandler = null;
        }
        if (flowHandler == null) {
            Flow curFlow = fh.getCurrentFlow(facesContext);
            if (curFlow != null) {
                ArrayList<Flow> activeFlows = new ArrayList<Flow>();
                while (curFlow != null) {
                    activeFlows.add(curFlow);
                    fh.pushReturnMode(facesContext);
                    curFlow = fh.getCurrentFlow(facesContext);
                }
                for (int i = 0; i < activeFlows.size(); ++i) {
                    fh.popReturnMode(facesContext);
                }
                return activeFlows;
            }
            return Collections.emptyList();
        }
        FlowHandlerImpl flowHandlerImpl = (FlowHandlerImpl)flowHandler;
        return flowHandlerImpl.getActiveFlows(facesContext);
    }

    public boolean isListenerForSource(Object source) {
        return source instanceof ClientWindow;
    }

    public void processEvent(SystemEvent event) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        FacesFlowProvider provider = this.getFacesFlowProvider(facesContext);
        provider.refreshClientWindow(facesContext);
    }
}

