/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.renderkit;

import java.util.logging.Logger;
import javax.faces.render.RenderKit;
import org.apache.myfaces.extensions.validator.core.factory.ClassMappingFactory;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.JsfUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.API})
public abstract class AbstractRenderKitWrapperFactory
implements ClassMappingFactory<RenderKit, RenderKit> {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    protected AbstractRenderKitWrapperFactory wrapped;
    private boolean deactivated = false;

    protected AbstractRenderKitWrapperFactory() {
        this.logger.fine(this.getClass().getName() + " instantiated");
    }

    public void addRenderKitWrapperFactory(AbstractRenderKitWrapperFactory renderKitWrapperFactory) {
        this.logger.finest(renderKitWrapperFactory.getClass().getName() + " added");
        if (this.wrapped != null) {
            this.wrapped.addRenderKitWrapperFactory(renderKitWrapperFactory);
            return;
        }
        this.wrapped = renderKitWrapperFactory;
    }

    public void deactivate() {
        this.logger.finest(this.getClass().getName() + " deactivated");
        this.deactivated = true;
    }

    public boolean isDeactivated() {
        return this.deactivated;
    }

    @Override
    public final RenderKit create(RenderKit renderKit) {
        if (this.isDeactivated()) {
            return null;
        }
        RenderKit result = null;
        if (this.wrapped != null) {
            result = this.wrapped.create(renderKit);
        }
        if (result == null) {
            return this.createWrapper(renderKit);
        }
        return result;
    }

    protected abstract RenderKit createWrapper(RenderKit var1);

    protected boolean isApplicationInitialized() {
        return JsfUtils.isApplicationInitialized();
    }
}

