/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.mock.lifecycle;

import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.test.mock.lifecycle.DefaultRestoreViewSupport;
import org.apache.myfaces.test.mock.lifecycle.PhaseExecutor;
import org.apache.myfaces.test.mock.lifecycle.RestoreViewSupport;
import org.apache.myfaces.test.util.Jsf11Utils;
import org.apache.myfaces.test.util.Jsf12Utils;
import org.apache.myfaces.test.util.JsfVersion;

class RestoreViewExecutor
implements PhaseExecutor {
    private static final Log log = LogFactory.getLog(RestoreViewExecutor.class);
    private RestoreViewSupport _restoreViewSupport;

    RestoreViewExecutor() {
    }

    public boolean execute(FacesContext facesContext) {
        if (facesContext == null) {
            throw new FacesException("FacesContext is null");
        }
        Application application = facesContext.getApplication();
        ViewHandler viewHandler = application.getViewHandler();
        if (JsfVersion.supports12()) {
            Jsf12Utils.initView(facesContext, viewHandler);
        }
        UIViewRoot viewRoot = facesContext.getViewRoot();
        RestoreViewSupport restoreViewSupport = this.getRestoreViewSupport();
        if (viewRoot != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"View already exists in the FacesContext");
            }
            viewRoot.setLocale(facesContext.getExternalContext().getRequestLocale());
            restoreViewSupport.processComponentBinding(facesContext, (UIComponent)viewRoot);
            return false;
        }
        String viewId = restoreViewSupport.calculateViewId(facesContext);
        if (restoreViewSupport.isPostback(facesContext)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Request is a postback");
            }
            if ((viewRoot = viewHandler.restoreView(facesContext, viewId)) == null) {
                if (JsfVersion.supports12()) {
                    Jsf12Utils.throwViewExpiredException(viewId);
                } else {
                    Jsf11Utils.throwViewExpiredException(viewId);
                }
            }
            restoreViewSupport.processComponentBinding(facesContext, (UIComponent)viewRoot);
        } else {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Request is not a postback. New UIViewRoot will be created");
            }
            viewRoot = viewHandler.createView(facesContext, viewId);
            facesContext.renderResponse();
        }
        facesContext.setViewRoot(viewRoot);
        return false;
    }

    protected RestoreViewSupport getRestoreViewSupport() {
        if (this._restoreViewSupport == null) {
            this._restoreViewSupport = new DefaultRestoreViewSupport();
        }
        return this._restoreViewSupport;
    }

    public void setRestoreViewSupport(RestoreViewSupport restoreViewSupport) {
        this._restoreViewSupport = restoreViewSupport;
    }

    public PhaseId getPhase() {
        return PhaseId.RESTORE_VIEW;
    }

    private static String deriveViewId(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        String viewId = externalContext.getRequestPathInfo();
        if (viewId == null) {
            viewId = externalContext.getRequestServletPath();
            if (viewId == null) {
                return null;
            }
            String defaultSuffix = externalContext.getInitParameter("javax.faces.DEFAULT_SUFFIX");
            String suffix = defaultSuffix != null ? defaultSuffix : ".jsp";
            int dot = viewId.lastIndexOf(46);
            if (dot == -1) {
                log.error((Object)("Assumed extension mapping, but there is no extension in " + viewId));
                viewId = null;
            } else {
                viewId = viewId.substring(0, dot) + suffix;
            }
        }
        return viewId;
    }
}

