/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.myfaces.tobago.component.UISelectOneChoice;
import org.apache.myfaces.tobago.internal.component.AbstractUISuggest;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.renderkit.HtmlUtils;
import org.apache.myfaces.tobago.renderkit.SelectOneRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.Select2Options;
import org.apache.myfaces.tobago.renderkit.html.standard.standard.tag.SelectManyBoxRenderer;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.util.SelectItemUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectOneChoiceRenderer
extends SelectOneRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(SelectOneChoiceRenderer.class);

    public boolean getRendersChildren() {
        return true;
    }

    public void prepareRender(FacesContext facesContext, UIComponent component) throws IOException {
        super.prepareRender(facesContext, component);
        if (Select2Options.of((UISelectOneChoice)component).hasAnyOption()) {
            SelectManyBoxRenderer.addSelect2LanguageJs(facesContext);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        String onchange;
        if (!(component instanceof UISelectOneChoice)) {
            LOG.error("Wrong type: Need " + UISelectOneChoice.class.getName() + ", but was " + component.getClass().getName());
            return;
        }
        UISelectOneChoice select = (UISelectOneChoice)component;
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        AbstractUISuggest suggest = select.getSuggest();
        String id = select.getClientId(facesContext);
        Iterable<SelectItem> items = SelectItemUtils.getItemIterator(facesContext, (UIComponent)select);
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)select);
        boolean disabled = suggest == null && !select.isAllowCustom() && !items.iterator().hasNext() || select.isDisabled() || select.isReadonly();
        Style style = new Style(facesContext, (LayoutBase)select);
        Select2Options select2Options = Select2Options.of(select);
        boolean renderAsSelect2 = select2Options.hasAnyOption();
        if (suggest != null) {
            select2Options.setMinimumInputLength(suggest.getMinimumCharacters());
        }
        if (renderAsSelect2) {
            String json = select2Options.toJson();
            LOG.trace("Select2 json = \"{}\"", (Object)json);
            ComponentUtils.putDataAttribute((UIComponent)select, (Object)"tobago-select2", (Object)json);
            writer.startElement("span", (UIComponent)select);
            writer.writeStyleAttribute(style);
            style.setTop(Measure.ZERO);
            style.setLeft(Measure.ZERO);
        }
        writer.startElement("select", (UIComponent)select);
        writer.writeNameAttribute(id);
        writer.writeIdAttribute(id);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)select);
        writer.writeAttribute("disabled", disabled);
        Integer tabIndex = select.getTabIndex();
        if (tabIndex != null) {
            writer.writeAttribute("tabindex", tabIndex.intValue());
        }
        writer.writeStyleAttribute(style);
        writer.writeClassAttribute(Classes.create((UIComponent)select));
        if (title != null) {
            writer.writeAttribute("title", title, true);
        }
        if ((onchange = HtmlUtils.generateOnchange((UIInput)select, (FacesContext)facesContext)) != null) {
            writer.writeAttribute("onchange", onchange, true);
        }
        if (suggest != null) {
            writer.writeAttribute("data-tobago-suggest-id", suggest.getClientId(facesContext), false);
        }
        HtmlRendererUtils.renderCommandFacet((UIComponent)select, facesContext, writer);
        HtmlRendererUtils.renderFocus(id, select.isFocus(), ComponentUtils.isError((UIInput)select), facesContext, writer);
        if (renderAsSelect2 && select.getPlaceholder() != null && select.getPlaceholder().length() > 0) {
            writer.startElement("option", null);
            writer.endElement("option");
        }
        HtmlRendererUtils.renderSelectItems((UIInput)select, items, select.getValue(), (String)select.getSubmittedValue(), writer, facesContext);
        writer.endElement("select");
        if (renderAsSelect2) {
            writer.endElement("span");
        }
        super.encodeEnd(facesContext, (UIComponent)select);
    }
}

