/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.event;

import java.lang.invoke.MethodHandles;
import javax.el.ValueExpression;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.event.SheetStateChangeEvent;
import org.apache.myfaces.tobago.event.SheetStateChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueExpressionSheetStateChangeListener
implements SheetStateChangeListener,
StateHolder {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String type;
    private ValueExpression valueExpression;

    public ValueExpressionSheetStateChangeListener() {
    }

    public ValueExpressionSheetStateChangeListener(String type, ValueExpression valueExpression) {
        this.type = type;
        this.valueExpression = valueExpression;
    }

    @Override
    public void processSheetStateChange(SheetStateChangeEvent sheetStateChangeEvent) {
        SheetStateChangeListener handler = this.getSheetStateChangeListener();
        if (handler != null) {
            handler.processSheetStateChange(sheetStateChangeEvent);
        } else {
            LOG.error("Ignoring SheetStateChangeEvent. No SheetStateChangeListener found.");
        }
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{UIComponentBase.saveAttachedState((FacesContext)context, (Object)this.valueExpression), this.type};
        return state;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.valueExpression = (ValueExpression)UIComponentBase.restoreAttachedState((FacesContext)context, (Object)values[0]);
        this.type = (String)values[1];
    }

    public boolean isTransient() {
        return false;
    }

    public void setTransient(boolean newTransientValue) {
    }

    private SheetStateChangeListener getSheetStateChangeListener() {
        Object obj;
        SheetStateChangeListener handler = null;
        if (this.valueExpression != null && (obj = this.valueExpression.getValue(FacesContext.getCurrentInstance().getELContext())) != null && obj instanceof SheetStateChangeListener) {
            handler = (SheetStateChangeListener)obj;
        }
        if (handler == null && this.type != null && (handler = this.createSheetStateChangeListener(this.type)) != null && this.valueExpression != null) {
            this.valueExpression.setValue(FacesContext.getCurrentInstance().getELContext(), (Object)handler);
        }
        return handler;
    }

    private SheetStateChangeListener createSheetStateChangeListener(String className) {
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(className);
            return (SheetStateChangeListener)clazz.newInstance();
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
            return null;
        }
    }
}

