/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.component;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import javax.el.MethodExpression;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.FacesEvent;
import javax.faces.event.ListenerFor;
import javax.faces.event.PhaseId;
import javax.faces.event.PostAddToViewEvent;
import org.apache.myfaces.tobago.component.SupportsDisabled;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.event.CollapsibleActionListener;
import org.apache.myfaces.tobago.internal.component.AbstractUICommand;
import org.apache.myfaces.tobago.internal.component.AbstractUIOperation;
import org.apache.myfaces.tobago.internal.config.SecurityAnnotation;
import org.apache.myfaces.tobago.internal.util.AuthorizationHelper;
import org.apache.myfaces.tobago.util.ComponentUtils;

@ListenerFor(systemEventClass=PostAddToViewEvent.class)
public abstract class AbstractUICommandBase
extends UICommand
implements ComponentSystemEventListener {
    public void processEvent(ComponentSystemEvent event) {
        super.processEvent(event);
        if (event instanceof PostAddToViewEvent) {
            List<AbstractUIOperation> list = ComponentUtils.findDescendantList((UIComponent)this, AbstractUIOperation.class);
            for (AbstractUIOperation operation : list) {
                this.addActionListener(new CollapsibleActionListener(operation.getFor()));
            }
        }
    }

    public void processDecodes(FacesContext context) {
        if (!this.isRendered()) {
            return;
        }
        try {
            this.decode(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        Iterator kids = this.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            kid.processDecodes(context);
        }
    }

    public void queueEvent(FacesEvent facesEvent) {
        super.queueEvent(facesEvent);
        if (this == facesEvent.getSource()) {
            if (this.isImmediate()) {
                facesEvent.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                facesEvent.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
        }
    }

    public boolean isRendered() {
        FacesContext facesContext = this.getFacesContext();
        TobagoConfig tobagoConfig = TobagoConfig.getInstance(facesContext);
        return super.isRendered() && (tobagoConfig.getSecurityAnnotation() != SecurityAnnotation.hide || this.isAllowed());
    }

    public boolean isDisabled() {
        SupportsDisabled parent;
        FacesContext facesContext = this.getFacesContext();
        TobagoConfig tobagoConfig = TobagoConfig.getInstance(facesContext);
        Boolean disabled = (Boolean)this.getStateHelper().eval((Serializable)((Object)AbstractUICommand.PropertyKeys.disabled));
        if (disabled == null && (parent = ComponentUtils.findAncestor(AbstractUICommandBase.getCurrentComponent((FacesContext)facesContext), SupportsDisabled.class)) != null && parent.isDisabled()) {
            return true;
        }
        return disabled != null && disabled != false || tobagoConfig.getSecurityAnnotation() == SecurityAnnotation.disable && !this.isAllowed();
    }

    private boolean isAllowed() {
        FacesContext facesContext = this.getFacesContext();
        AuthorizationHelper authorizationHelper = AuthorizationHelper.getInstance(facesContext);
        MethodExpression actionExpression = this.getActionExpression();
        if (actionExpression != null) {
            return authorizationHelper.isAuthorized(facesContext, (UIComponent)this, actionExpression.getExpressionString());
        }
        return true;
    }

    public void setDisabled(boolean disabled) {
        this.getStateHelper().put((Serializable)((Object)AbstractUICommand.PropertyKeys.disabled), (Object)disabled);
    }

    public abstract String getTarget();

    public abstract boolean isTransition();

    public abstract boolean isOmit();

    public abstract void setOmit(boolean var1);

    public abstract String getConfirmation();

    public abstract String getLink();

    public abstract String getOutcome();

    public abstract String getFragment();
}

