/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_tomahawk.trace;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.shared_tomahawk.trace.Closure;
import org.apache.myfaces.shared_tomahawk.trace.TracingSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TracingIterator<E>
implements Iterator<E> {
    private final Iterator<E> _iterator;
    private final TracingSupport _tracer;

    public TracingIterator(Iterator<E> iterator) {
        this._iterator = iterator;
        this._tracer = new TracingSupport(iterator.getClass());
    }

    public static <E> TracingIterator<E> create(Iterator<E> iterator) {
        return new TracingIterator<E>(iterator);
    }

    public Iterator<E> getIterator() {
        return this._iterator;
    }

    @Override
    public boolean hasNext() {
        return this._tracer.trace("hasNext", new Closure<Boolean>(){

            @Override
            public Boolean call() {
                return TracingIterator.this._iterator.hasNext();
            }
        });
    }

    @Override
    public E next() {
        return (E)this._tracer.trace("next", new Closure<E>(){

            @Override
            public E call() {
                return TracingIterator.this._iterator.next();
            }
        });
    }

    @Override
    public void remove() {
        this._tracer.trace("remove", new Closure<Object>(){

            @Override
            public Object call() {
                TracingIterator.this._iterator.remove();
                return Void.class;
            }
        });
    }

    public Level getLevel() {
        return this._tracer.getLevel();
    }

    public Logger getLogger() {
        return this._tracer.getLogger();
    }

    public String getSourceClass() {
        return this._tracer.getSourceClass();
    }

    public void setLevel(Level level) {
        this._tracer.setLevel(level);
    }

    public void setLogger(Logger logger) {
        this._tracer.setLogger(logger);
    }

    public void setSourceClass(String className) {
        this._tracer.setSourceClass(className);
    }
}

