/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.layout.CorePanelList;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.util.IntegerUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.CoreRenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;

public class PanelListRenderer
extends XhtmlRenderer {
    private static final int SPLIT_DEFAULT = Integer.MAX_VALUE;
    private static final int COLUMNS_DEFAULT = 3;
    private PropertyKey _maxColumnsKey;
    private PropertyKey _rowsKey;
    private PropertyKey _listStyleKey;

    public PanelListRenderer() {
        super(CorePanelList.TYPE);
    }

    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._maxColumnsKey = type.findKey("maxColumns");
        this._rowsKey = type.findKey("rows");
        this._listStyleKey = type.findKey("listStyle");
    }

    protected void renderStyleAttributes(FacesContext context, RenderingContext arc, FacesBean bean) throws IOException {
        this.renderStyleAttributes(context, arc, bean, "af|panelList");
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeAll(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        int split = this._getSplit(bean);
        int maxCols = this._getMaxColumns(arc, bean);
        int childCount = component.getChildCount();
        if (childCount <= 0 || split < 1 || maxCols < 1) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", component);
        this.renderId(context, component);
        this.renderAllAttributes(context, arc, bean);
        ((CoreRenderingContext)arc).setDefaultLinkStyleDisabled(true);
        if (split >= childCount) {
            this._renderNoColumns(context, arc, component, bean, 0, childCount);
        } else {
            this._renderColumns(context, arc, component, bean, split, childCount);
        }
        ((CoreRenderingContext)arc).setDefaultLinkStyleDisabled(false);
        writer.endElement("div");
    }

    protected Number getRows(FacesBean bean) {
        return (Number)bean.getProperty(this._rowsKey);
    }

    protected Number getMaxColumns(FacesBean bean) {
        return (Number)bean.getProperty(this._maxColumnsKey);
    }

    protected String getListStyle(FacesBean bean) {
        return (String)bean.getProperty(this._listStyleKey);
    }

    private void _renderListStyle(FacesContext context, FacesBean bean) throws IOException {
        String listStyle = this.getListStyle(bean);
        if (listStyle != null) {
            context.getResponseWriter().writeAttribute("style", (Object)listStyle, "listStyle");
        }
    }

    private int _renderNoColumns(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean, int start, int numToRender) throws IOException {
        int childIndex;
        ResponseWriter writer = context.getResponseWriter();
        int maxChildIndex = component.getChildCount();
        int numRendered = 0;
        List children = component.getChildren();
        writer.startElement("ul", null);
        this._renderListStyle(context, bean);
        for (childIndex = start; numRendered < numToRender && childIndex < maxChildIndex; ++childIndex) {
            UIComponent child = (UIComponent)children.get(childIndex);
            if (child == null || !child.isRendered()) continue;
            writer.startElement("li", null);
            this.encodeChild(context, child);
            writer.endElement("li");
            ++numRendered;
        }
        writer.endElement("ul");
        return childIndex;
    }

    private void _renderColumns(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean, int split, int childCount) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("table", null);
        OutputUtils.renderLayoutTableAttributes(context, arc, "0", "100%");
        writer.startElement("tr", null);
        int start = 0;
        int numToRender = 0;
        int maxCols = this._getMaxColumns(arc, bean);
        int numCols = (int)Math.ceil((double)childCount / (double)split);
        if (numCols > maxCols) {
            numCols = maxCols;
        }
        numToRender = numCols > 1 ? (int)Math.ceil((double)childCount / (double)numCols) : childCount;
        String width = IntegerUtils.getString((int)(100 / numCols));
        width = width + "%";
        for (int i = 0; i < numCols; ++i) {
            writer.startElement("td", null);
            writer.writeAttribute("width", (Object)width, null);
            writer.writeAttribute("valign", (Object)"top", null);
            start = this._renderNoColumns(context, arc, component, bean, start, numToRender);
            writer.endElement("td");
            if (start >= childCount) break;
        }
        writer.endElement("tr");
        writer.endElement("table");
    }

    private int _getMaxColumns(RenderingContext arc, FacesBean bean) {
        Number maxColumnsNumber = this.getMaxColumns(bean);
        return maxColumnsNumber != null ? maxColumnsNumber.intValue() : this._getDefaultColumns(arc);
    }

    private int _getSplit(FacesBean bean) {
        Number splitNumber = this.getRows(bean);
        return splitNumber != null ? splitNumber.intValue() : Integer.MAX_VALUE;
    }

    private int _getDefaultColumns(RenderingContext arc) {
        Integer defaultColumns = (Integer)arc.getSkin().getProperty((Object)"af|panelList-tr-default-columns");
        return defaultColumns != null ? defaultColumns : 3;
    }
}

