/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin;

import java.io.IOException;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Stack;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.apache.myfaces.trinidad.context.LocaleContext;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidad.skin.Skin;
import org.apache.myfaces.trinidadinternal.skin.SkinImpl;
import org.apache.myfaces.trinidadinternal.skin.icon.ReferenceIcon;
import org.apache.myfaces.trinidadinternal.style.StyleContext;
import org.apache.myfaces.trinidadinternal.style.xml.StyleSheetDocumentUtils;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleSheetDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkinExtension
extends SkinImpl {
    private String _id;
    private String _family;
    private String _renderKitId;
    private SkinImpl _baseSkin;
    private String _styleSheetName;
    private String _bundleName;
    private ValueBinding _translationSourceVB;
    private StyleSheetDocument _baseStyleSheetDocument;
    private StyleSheetDocument _extensionStyleSheetDocument;
    private StyleSheetDocument _fullStyleSheetDocument;
    private static final Icon _NULL_ICON = new NullIcon();
    private static final String _DEFAULT_RENDERKIT = "org.apache.myfaces.trinidad.desktop";
    private static final String _CIRCULAR_INCLUDE_ERROR = "Circular dependency detected in skin reference icon ";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(SkinExtension.class);

    public SkinExtension(Skin baseSkin, String id, String family, String renderKitId, String styleSheetName, String resourceBundleName) {
        if (baseSkin == null) {
            throw new NullPointerException("Null baseSkin");
        }
        if (id == null) {
            throw new NullPointerException(_LOG.getMessage("NULL_SKIN_ID"));
        }
        if (family == null) {
            throw new NullPointerException("Null family");
        }
        if (renderKitId == null) {
            renderKitId = _DEFAULT_RENDERKIT;
        }
        this._baseSkin = (SkinImpl)baseSkin;
        this._id = id;
        this._family = family;
        this._renderKitId = renderKitId;
        this._styleSheetName = styleSheetName;
        this._bundleName = resourceBundleName;
        this._translationSourceVB = null;
    }

    public SkinExtension(Skin baseSkin, String id, String family, String renderKitId, String styleSheetName, ValueBinding translationSourceValueBinding) {
        if (baseSkin == null) {
            throw new NullPointerException("Null baseSkin");
        }
        if (id == null) {
            throw new NullPointerException(_LOG.getMessage("NULL_SKIN_ID"));
        }
        if (family == null) {
            throw new NullPointerException("Null family");
        }
        if (renderKitId == null) {
            renderKitId = _DEFAULT_RENDERKIT;
        }
        this._baseSkin = (SkinImpl)baseSkin;
        this._id = id;
        this._family = family;
        this._renderKitId = renderKitId;
        this._styleSheetName = styleSheetName;
        this._bundleName = null;
        this._translationSourceVB = translationSourceValueBinding;
    }

    public SkinExtension(Skin baseSkin, String id, String family, String renderKitId, String styleSheetName) {
        if (baseSkin == null) {
            throw new NullPointerException("Null baseSkin");
        }
        if (id == null) {
            throw new NullPointerException(_LOG.getMessage("NULL_SKIN_ID"));
        }
        if (family == null) {
            throw new NullPointerException("Null family");
        }
        if (renderKitId == null) {
            renderKitId = _DEFAULT_RENDERKIT;
        }
        this._baseSkin = (SkinImpl)baseSkin;
        this._id = id;
        this._family = family;
        this._renderKitId = renderKitId;
        this._styleSheetName = styleSheetName;
        this._bundleName = null;
        this._translationSourceVB = null;
    }

    public SkinExtension(Skin baseSkin, String id, String family, String renderKitId) {
        this(baseSkin, id, family, renderKitId, null);
    }

    public Skin getBaseSkin() {
        return this._baseSkin;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public String getFamily() {
        return this._family;
    }

    @Override
    public String getStyleSheetName() {
        return this._styleSheetName;
    }

    @Override
    public String getRenderKitId() {
        return this._renderKitId;
    }

    @Override
    public String getBundleName() {
        return this._bundleName;
    }

    public void setBundleName(String bundleName) {
        this._bundleName = bundleName;
    }

    @Override
    public ValueBinding getTranslationSourceValueBinding() {
        return this._translationSourceVB;
    }

    @Override
    public void registerIcon(String iconName, Icon icon) {
        if (icon == null) {
            icon = _NULL_ICON;
        }
        super.registerIcon(iconName, icon);
    }

    @Override
    public Map<String, String> getStyleClassMap(RenderingContext arc) {
        return this._baseSkin.getStyleClassMap(arc);
    }

    @Override
    public Object getTranslatedValue(LocaleContext lContext, String key) throws MissingResourceException {
        Object translatedValue = this.getCachedTranslatedValue(lContext, key);
        if (translatedValue == null && (translatedValue = this.getBaseSkin().getTranslatedValue(lContext, key)) != null) {
            this.putTranslatedValueInLocaleCache(lContext, key, translatedValue);
        }
        return translatedValue;
    }

    @Override
    public Object getProperty(Object key) {
        Object value = super.getProperty(key);
        if (value == null) {
            Skin baseSkin = this.getBaseSkin();
            value = baseSkin.getProperty(key);
        }
        return value;
    }

    @Override
    public Icon getIcon(String iconName, boolean resolve) {
        Icon icon = super.getIcon(iconName, false);
        if (icon != null) {
            if (icon == _NULL_ICON) {
                return null;
            }
            if (resolve && icon instanceof ReferenceIcon) {
                Icon resolvedIcon = this._resolveReferenceIcon((ReferenceIcon)icon, null);
                this.registerIcon(iconName, resolvedIcon);
                return resolvedIcon;
            }
            return icon;
        }
        Skin baseSkin = this.getBaseSkin();
        icon = baseSkin.getIcon(iconName, false);
        if (resolve && icon instanceof ReferenceIcon) {
            Icon resolvedIcon = this._resolveReferenceIcon((ReferenceIcon)icon, null);
            this.registerIcon(iconName, resolvedIcon);
            return resolvedIcon;
        }
        this.registerIcon(iconName, icon);
        return icon;
    }

    public void setStyleSheetName(String styleSheetName) {
        this._styleSheetName = styleSheetName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StyleSheetDocument getStyleSheetDocument(StyleContext context) {
        SkinImpl baseSkin = (SkinImpl)this.getBaseSkin();
        StyleSheetDocument baseDocument = baseSkin.getStyleSheetDocument(context);
        StyleSheetDocument extensionDocument = super.getStyleSheetDocument(context);
        SkinExtension skinExtension = this;
        synchronized (skinExtension) {
            if (baseDocument != this._baseStyleSheetDocument || extensionDocument != this._extensionStyleSheetDocument) {
                this._baseStyleSheetDocument = baseDocument;
                this._extensionStyleSheetDocument = extensionDocument;
                this._fullStyleSheetDocument = StyleSheetDocumentUtils.mergeStyleSheetDocuments(baseDocument, extensionDocument);
            }
            return this._fullStyleSheetDocument;
        }
    }

    private Icon _resolveReferenceIcon(ReferenceIcon refIcon, Stack<String> referencedIconStack) {
        String refName = refIcon.getName();
        if (SkinExtension._stackContains(referencedIconStack, refName)) {
            if (_LOG.isWarning()) {
                _LOG.warning(_CIRCULAR_INCLUDE_ERROR + refName);
            }
            return null;
        }
        if (referencedIconStack == null) {
            referencedIconStack = new Stack();
        }
        referencedIconStack.push(refName);
        Icon icon = super.getIcon(refName, false);
        if (icon != null) {
            if (icon instanceof ReferenceIcon) {
                Icon resolvedIcon = this._resolveReferenceIcon((ReferenceIcon)icon, referencedIconStack);
                return resolvedIcon;
            }
            return icon;
        }
        Skin baseSkin = this.getBaseSkin();
        icon = baseSkin.getIcon(refName, false);
        if (icon instanceof ReferenceIcon) {
            Icon resolvedIcon = this._resolveReferenceIcon((ReferenceIcon)icon, referencedIconStack);
            return resolvedIcon;
        }
        return icon;
    }

    private static boolean _stackContains(Stack<String> stack, Object value) {
        if (stack == null) {
            return false;
        }
        return stack.contains(value);
    }

    private SkinExtension() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullIcon
    extends Icon {
        private NullIcon() {
        }

        public void renderIcon(FacesContext context, RenderingContext arc, Map<String, ? extends Object> attrs) throws IOException {
        }
    }
}

