/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ClassLoaderUtils;
import org.apache.myfaces.trinidadinternal.share.io.DefaultNameResolver;
import org.apache.myfaces.trinidadinternal.share.io.FileInputStreamProvider;
import org.apache.myfaces.trinidadinternal.share.io.InputStreamProvider;
import org.apache.myfaces.trinidadinternal.share.io.NameResolver;
import org.apache.myfaces.trinidadinternal.share.io.URLInputStreamProvider;
import org.apache.myfaces.trinidadinternal.style.StyleContext;

class StyleSheetNameResolver
implements NameResolver {
    private File _localStylesDir;
    private static final String _STYLES_DIR_ERROR = "Could not locate the Trinidad styles directory.Please be sure that the Trinidad installable resources are installed.";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(StyleSheetNameResolver.class);

    public static NameResolver createResolver(StyleContext context) {
        File localStylesDir = StyleSheetNameResolver._getStylesDir(context);
        if (localStylesDir == null) {
            _LOG.warning(_STYLES_DIR_ERROR);
            return null;
        }
        return new StyleSheetNameResolver(localStylesDir);
    }

    private StyleSheetNameResolver(File localStylesDirectory) {
        assert (localStylesDirectory != null);
        this._localStylesDir = localStylesDirectory;
    }

    public InputStreamProvider getProvider(String name) throws IOException {
        File file = this._resolveLocalFile(name);
        if (file != null) {
            return new FileInputStreamProvider(file);
        }
        URL url = this._resolveNonStaticURL(name);
        if (url != null) {
            return new URLInputStreamProvider(url);
        }
        url = this._resolveClassLoaderURL(name);
        if (url != null) {
            return new StaticURLInputStreamProvider(url);
        }
        throw new FileNotFoundException(this._getFileNotFoundMessage(name));
    }

    public NameResolver getResolver(String name) {
        URL url = null;
        File file = this._resolveLocalFile(name);
        if (file == null && (url = this._resolveNonStaticURL(name)) == null) {
            url = this._resolveClassLoaderURL(name);
        }
        return new DefaultNameResolver(file, url);
    }

    private File _resolveLocalFile(String name) {
        File file = new File(this._localStylesDir, name);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    private URL _resolveClassLoaderURL(String name) {
        if (name == null) {
            return null;
        }
        return ClassLoaderUtils.getResource((String)name);
    }

    private URL _resolveNonStaticURL(String name) {
        if (name == null) {
            return null;
        }
        FacesContext fContext = FacesContext.getCurrentInstance();
        if (fContext != null) {
            try {
                if (name.startsWith("http:") || name.startsWith("https:") || name.startsWith("file:") || name.startsWith("ftp:") || name.startsWith("jar:")) {
                    URL url = new URL(name);
                    if (url != null) {
                        return url;
                    }
                } else {
                    String rootName = StyleSheetNameResolver._getRootName(name);
                    URL url = fContext.getExternalContext().getResource(rootName);
                    if (url != null) {
                        return url;
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    private String _getFileNotFoundMessage(String name) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Unable to locate style sheet \"");
        buffer.append(name);
        buffer.append("\" in ");
        if (this._localStylesDir != null) {
            buffer.append("local styles directory (");
            buffer.append(this._localStylesDir.getPath());
            buffer.append("), ");
        }
        buffer.append("or on the class path.\n");
        buffer.append("Please be sure that this style sheet is installed.");
        return buffer.toString();
    }

    private static File _getStylesDir(StyleContext context) {
        String contextPath = context.getGeneratedFilesPath();
        if (contextPath == null) {
            return null;
        }
        String stylesPath = contextPath + "/adf/styles";
        File stylesDir = new File(stylesPath);
        if (stylesDir.exists()) {
            return stylesDir;
        }
        return null;
    }

    private static String _getRootName(String name) {
        return name.startsWith("/") ? name : "/" + name;
    }

    private static class StaticURLInputStreamProvider
    extends URLInputStreamProvider {
        public StaticURLInputStreamProvider(URL url) {
            super(url);
        }

        public boolean hasSourceChanged() {
            return false;
        }
    }
}

