/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.style.util;

import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.util.Hashtable;
import java.util.Map;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ArrayMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphicsUtils {
    private static boolean _sIsGraphical = false;
    private static Map<String, Boolean> _sFontNames = null;
    private static boolean _sGraphicsLoaded = false;
    private static boolean _sFontsLoaded = false;
    private static Thread _sGraphicsLoaderThread = null;
    private static Thread _sFontLoaderThread = null;
    private static final String _GRAPHICS_LOADER_NAME = "Ocelot-Graphics-Loader";
    private static final String _FONT_LOADER_NAME = "Ocelot-Graphics-Loader";
    private static final String _GRAPHICS_INIT_MESSAGE = "Initializing graphics environment...";
    private static final String _GRAPHICS_WAIT_MESSAGE = "Waiting for graphics environment initialization...";
    private static final String _GRAPHICS_DELAY_MESSAGE = "Could not yet initialize the graphics environment.  Will continue attempting to initialize graphics environment...";
    private static final String _GRAPHICS_SUCCESS_MESSAGE = "Finished initializing graphics environment.";
    private static final String _GRAPHICS_FAILURE_MESSAGE = "Could not initialize the graphical environment.  Please make sure that the DISPLAY environment variable is set correctly.  Proceeding with image generation disabled...";
    private static final String _FONT_INIT_MESSAGE = "Initializing fonts...";
    private static final String _FONT_WAIT_MESSAGE = "Waiting for font initialization...";
    private static final String _FONT_SUCCESS_MESSAGE = "Finished initializing fonts.";
    private static final String _FONT_FAILURE_MESSAGE = "Could not initialize fonts.  Using default font names";
    private static final String[] _DEFAULT_FONT_NAMES = new String[]{"dialog", "dialoginput", "monospaced", "serif", "sansserif", "symbol"};
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(GraphicsUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isGraphicalEnvironment() {
        if (_sGraphicsLoaded) {
            return _sIsGraphical;
        }
        Class<GraphicsUtils> clazz = GraphicsUtils.class;
        synchronized (GraphicsUtils.class) {
            if (!_sGraphicsLoaded) {
                if (_sGraphicsLoaderThread == null) {
                    _LOG.fine(_GRAPHICS_INIT_MESSAGE);
                    _sGraphicsLoaderThread = new Thread((Runnable)new GraphicsLoader(), "Ocelot-Graphics-Loader");
                    if (!GraphicsUtils._isHeadless()) {
                        int priority = Thread.currentThread().getPriority();
                        _sGraphicsLoaderThread.setPriority(priority - 1);
                    }
                    _sGraphicsLoaderThread.start();
                }
                GraphicsUtils._waitTillDone(_GRAPHICS_WAIT_MESSAGE, true);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _sIsGraphical;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFontName(String name) {
        if (!GraphicsUtils.isGraphicalEnvironment()) {
            return true;
        }
        if (_sFontsLoaded) {
            return GraphicsUtils._isFontName(name);
        }
        Class<GraphicsUtils> clazz = GraphicsUtils.class;
        synchronized (GraphicsUtils.class) {
            if (!_sFontsLoaded) {
                if (_sFontLoaderThread == null) {
                    _LOG.fine(_FONT_INIT_MESSAGE);
                    _sFontLoaderThread = new Thread((Runnable)new FontLoader(), "Ocelot-Graphics-Loader");
                    if (!GraphicsUtils._isHeadless()) {
                        int priority = Thread.currentThread().getPriority();
                        _sFontLoaderThread.setPriority(priority - 1);
                    }
                    _sFontLoaderThread.start();
                }
                GraphicsUtils._waitTillDone(_FONT_WAIT_MESSAGE, false);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return GraphicsUtils._isFontName(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void __setGraphicsLoaded(boolean isGraphical) {
        Class<GraphicsUtils> clazz = GraphicsUtils.class;
        synchronized (GraphicsUtils.class) {
            _sIsGraphical = isGraphical;
            _sGraphicsLoaded = true;
            _sGraphicsLoaderThread = null;
            if (_sIsGraphical) {
                _LOG.fine(_GRAPHICS_SUCCESS_MESSAGE);
            } else {
                _LOG.warning(_GRAPHICS_FAILURE_MESSAGE);
            }
            GraphicsUtils.class.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void __setFontsLoaded(Map<String, Boolean> names) {
        Class<GraphicsUtils> clazz = GraphicsUtils.class;
        synchronized (GraphicsUtils.class) {
            _sFontNames = names;
            _sFontsLoaded = true;
            _sFontLoaderThread = null;
            if (_sFontNames == null) {
                _LOG.warning(_FONT_FAILURE_MESSAGE);
                ArrayMap defaultFonts = new ArrayMap(_DEFAULT_FONT_NAMES.length);
                for (int i = 0; i < _DEFAULT_FONT_NAMES.length; ++i) {
                    defaultFonts.put((Object)_DEFAULT_FONT_NAMES[i].toLowerCase(), (Object)Boolean.TRUE);
                }
                _sFontNames = defaultFonts;
            } else {
                _LOG.fine(_FONT_SUCCESS_MESSAGE);
            }
            GraphicsUtils.class.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static boolean _isFontName(String name) {
        if (name == null) {
            return false;
        }
        return _sFontNames.get(name.toLowerCase()) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _waitTillDone(String waitMessage, boolean loadingGraphics) {
        Class<GraphicsUtils> clazz = GraphicsUtils.class;
        synchronized (GraphicsUtils.class) {
            long start = System.currentTimeMillis();
            long last = 0L;
            boolean warned = false;
            long infoTimeout = 2000L;
            long warningTimeout = 10000L;
            long abortTimeout = 20000L;
            boolean headless = GraphicsUtils._isHeadless();
            if (headless) {
                abortTimeout = Long.MAX_VALUE;
            }
            while (loadingGraphics && !_sGraphicsLoaded || !loadingGraphics && !_sFontsLoaded) {
                long current = System.currentTimeMillis();
                if (current - last > infoTimeout) {
                    _LOG.fine(waitMessage);
                    last = current;
                }
                if (loadingGraphics) {
                    if (!warned && current - start > warningTimeout) {
                        _LOG.warning(_GRAPHICS_DELAY_MESSAGE);
                        warned = true;
                    } else if (current - start > abortTimeout) {
                        if (_sGraphicsLoaderThread != null) {
                            _sGraphicsLoaderThread.interrupt();
                        }
                        GraphicsUtils.__setGraphicsLoaded(false);
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
                try {
                    GraphicsUtils.class.wait(250L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private static boolean _isHeadless() {
        String headless = System.getProperty("java.awt.headless");
        return "true".equalsIgnoreCase(headless);
    }

    private static final class FontLoader
    implements Runnable {
        private static final String _EXCEPTION_MESSAGE = "The following exception was thrown while initialiazing fonts: ";

        public void run() {
            GraphicsEnvironment ge = null;
            Hashtable<String, Boolean> fontNames = null;
            try {
                String[] families;
                ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                if (ge != null && (families = ge.getAvailableFontFamilyNames()) != null && families.length > 0) {
                    fontNames = new Hashtable<String, Boolean>(families.length);
                    for (int i = 0; i < families.length; ++i) {
                        String name = families[i].toLowerCase();
                        fontNames.put(name, Boolean.TRUE);
                    }
                }
            }
            catch (Throwable t) {
                _LOG.warning(_EXCEPTION_MESSAGE, t);
            }
            GraphicsUtils.__setFontsLoaded(fontNames);
        }
    }

    private static final class GraphicsLoader
    implements Runnable {
        private static final String _EXCEPTION_MESSAGE = "The following exception was thrown while initialiazing the graphics environment: ";

        public void run() {
            GraphicsEnvironment ge = null;
            Toolkit toolkit = null;
            try {
                ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                if (ge != null) {
                    toolkit = Toolkit.getDefaultToolkit();
                }
            }
            catch (Throwable t) {
                _LOG.warning(_EXCEPTION_MESSAGE, t);
            }
            GraphicsUtils.__setGraphicsLoaded(ge != null && toolkit != null);
        }
    }
}

