/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.uinode;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.component.FacesBeanWrapper;
import org.apache.myfaces.trinidad.component.UIXComponent;
import org.apache.myfaces.trinidad.component.UIXComponentBase;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ArrayMap;
import org.apache.myfaces.trinidadinternal.ui.AttributeKey;
import org.apache.myfaces.trinidadinternal.ui.NodeRole;
import org.apache.myfaces.trinidadinternal.ui.UIConstants;
import org.apache.myfaces.trinidadinternal.ui.UINode;
import org.apache.myfaces.trinidadinternal.ui.UIXRenderingContext;
import org.apache.myfaces.trinidadinternal.uinode.UINodeFacesBean;
import org.apache.myfaces.trinidadinternal.uinode.UINodeRendererBase;

@Deprecated
public class UIComponentUINode
implements UINode {
    private String _namespace;
    private UIComponent _component;
    private static final String _FACES_NAMESPACE = null;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(UIComponentUINode.class);
    private static Map<String, Map<String, String>> _UIX2_LOCALNAMES = new HashMap<String, Map<String, String>>(137);

    protected UIComponentUINode(UIComponent component, String namespace) {
        if (component == null) {
            throw new NullPointerException();
        }
        this._component = component;
        this._namespace = namespace;
    }

    @Override
    public UIComponent getUIComponent() {
        return this._component;
    }

    public String getID() {
        return this._component.getId();
    }

    @Override
    public String getNamespaceURI() {
        return this._namespace;
    }

    @Override
    public String getLocalName() {
        String family = this._component.getFamily();
        String rendererType = this._component.getRendererType();
        return this._get(family, rendererType);
    }

    @Override
    public int getIndexedChildCount(UIXRenderingContext context) {
        return this._component.getChildCount();
    }

    @Override
    public UINode getIndexedChild(UIXRenderingContext context, int childIndex) {
        UIComponent child = (UIComponent)this._component.getChildren().get(childIndex);
        return UIComponentUINode.__getUINode(child);
    }

    @Override
    public UINode getNamedChild(UIXRenderingContext context, String childName) {
        UIComponent child = this._component.getFacet(childName);
        if (child == null) {
            return null;
        }
        return UIComponentUINode.__getUINode(child);
    }

    @Override
    public Iterator<String> getChildNames(UIXRenderingContext context) {
        if (this._component instanceof UIXComponentBase) {
            return ((UIXComponentBase)this._component).getFacetNames();
        }
        return this._component.getFacets().keySet().iterator();
    }

    @Override
    public Iterator<AttributeKey> getAttributeNames(UIXRenderingContext context) {
        throw new UnsupportedOperationException();
    }

    public void setAttributeValue(AttributeKey attrKey, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getAttributeValue(UIXRenderingContext context, AttributeKey attrKey) {
        return this.getRawAttributeValue(context, attrKey);
    }

    @Override
    public Object getRawAttributeValue(UIXRenderingContext context, AttributeKey attrKey) {
        if (attrKey == UIConstants.RENDERED_ATTR) {
            return this._component.isRendered() ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    @Override
    public NodeRole getNodeRole(UIXRenderingContext context) {
        return UIConstants.UNKNOWN_ROLE;
    }

    @Override
    public void render(UIXRenderingContext context) throws IOException {
        this.render(context, this);
    }

    @Override
    public void render(UIXRenderingContext context, UINode dataNode) throws IOException {
        assert (dataNode == this);
        context.getResponseWriter().flush();
        FacesContext fContext = context.getFacesContext();
        UIXRenderingContext oldContext = UINodeRendererBase.__setRenderingContext(fContext, context);
        this._renderComponent(fContext, this._component);
        UINodeRendererBase.__restoreRenderingContext(fContext, oldContext);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(40);
        String className = this.getClass().getName();
        int periodIndex = className.lastIndexOf(46);
        if (periodIndex >= 0) {
            className = className.substring(periodIndex + 1);
        }
        buffer.append(className);
        buffer.append(", localName='");
        buffer.append(this.getLocalName());
        buffer.append("'");
        UIComponent component = this.getUIComponent();
        if (component != null) {
            buffer.append('[');
            buffer.append(component.toString());
            buffer.append(",rendererType=");
            buffer.append(component.getRendererType());
            buffer.append(']');
        }
        return buffer.toString();
    }

    private void _renderComponent(FacesContext context, UIComponent component) throws IOException {
        component.encodeBegin(context);
        if (component.getRendersChildren()) {
            component.encodeChildren(context);
        } else {
            int count = component.getChildCount();
            if (count > 0) {
                List children = component.getChildren();
                for (int i = 0; i < count; ++i) {
                    UIComponent child = (UIComponent)children.get(i);
                    if (!child.isRendered()) continue;
                    this._renderComponent(context, child);
                }
            }
        }
        component.encodeEnd(context);
    }

    static UINode __getUINode(UIComponent component) {
        if (component instanceof UIXComponent) {
            FacesBean bean = ((UIXComponent)component).getFacesBean();
            while (bean instanceof FacesBeanWrapper) {
                bean = ((FacesBeanWrapper)bean).getWrappedBean();
            }
            if (bean instanceof UINodeFacesBean) {
                return ((UINodeFacesBean)bean).getUINode();
            }
        }
        return new UIComponentUINode(component, _FACES_NAMESPACE);
    }

    public int getIndexedChildCount() {
        throw new UnsupportedOperationException();
    }

    public UINode getIndexedChild(int i) {
        throw new UnsupportedOperationException();
    }

    public Iterator<String> getChildNames() {
        throw new UnsupportedOperationException();
    }

    public UINode getNamedChild(String name) {
        throw new UnsupportedOperationException();
    }

    public Object getAttributeValue(UIXRenderingContext context, String name) {
        throw new UnsupportedOperationException();
    }

    static void _loadRenderertypeToLocalnameMap() {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> resources = loader.getResources("META-INF/renderertype-localname.properties");
            while (resources.hasMoreElements()) {
                InputStream propertyStream = resources.nextElement().openStream();
                Properties properties = new Properties();
                properties.load(propertyStream);
                propertyStream.close();
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    String key = (String)entry.getKey();
                    String localName = (String)entry.getValue();
                    int indexOfBar = key.indexOf(124);
                    if (indexOfBar < 0) {
                        _LOG.severe("MALFORMED_PROPERTY_ENTRY", new Object[]{key, localName});
                        continue;
                    }
                    String family = key.substring(0, indexOfBar);
                    String rendererType = key.substring(indexOfBar + 1);
                    UIComponentUINode._put(family, rendererType, localName);
                }
            }
        }
        catch (Exception e) {
            _LOG.severe("CANNOT_LOAD_RENDERER_TYPE_TO_LOCAL_NAME_MAPPING", (Throwable)e);
        }
    }

    private static synchronized void _put(String family, String rendererType, String localName) {
        ArrayMap subMap = _UIX2_LOCALNAMES.get(family);
        if (subMap == null) {
            subMap = new ArrayMap(7);
            _UIX2_LOCALNAMES.put(family, (Map<String, String>)subMap);
        }
        subMap.put((String)rendererType, (String)localName);
    }

    private String _get(String family, String rendererType) {
        Map<String, String> subMap = _UIX2_LOCALNAMES.get(family);
        if (subMap == null) {
            return null;
        }
        return subMap.get(rendererType);
    }

    static {
        UIComponentUINode._loadRenderertypeToLocalnameMap();
    }
}

