/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.text.BreakIterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.input.CoreInputText;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.util.IntegerUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.AutoSubmitUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.FormInputRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.LabelAndMessageRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;

public class SimpleInputTextRenderer
extends FormInputRenderer {
    private PropertyKey _columnsKey;
    private PropertyKey _rowsKey;
    private PropertyKey _wrapKey;
    private PropertyKey _secretKey;
    private PropertyKey _maximumLengthKey;
    private PropertyKey _autoCompleteKey;
    private PropertyKey _onselectKey;
    private static final Integer _DEFAULT_PDA_COLUMNS = 11;
    private static final Integer _DEFAULT_COLUMNS = 30;
    private static final String _SECRET_KEYDOWN_SCRIPT = "return _clearPassword(this, event);";
    private static final int _MAX_COLUMNS = 500;
    private static final int _MAX_ROWS = 500;

    public SimpleInputTextRenderer() {
        this(CoreInputText.TYPE);
    }

    public SimpleInputTextRenderer(FacesBean.Type type) {
        super(type);
    }

    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._columnsKey = type.findKey("columns");
        this._rowsKey = type.findKey("rows");
        this._wrapKey = type.findKey("wrap");
        this._secretKey = type.findKey("secret");
        this._maximumLengthKey = type.findKey("maximumLength");
        this._autoCompleteKey = type.findKey("autoComplete");
        this._onselectKey = type.findKey("onselect");
    }

    protected Object getSubmittedValue(FacesContext context, UIComponent component, String clientId) {
        Object submitted = super.getSubmittedValue(context, component, clientId);
        if (submitted == null || "".equals(submitted)) {
            return submitted;
        }
        FacesBean bean = this.getFacesBean(component);
        if (this.getSecret(bean)) {
            if ("******".equals(submitted)) {
                return this.getSubmittedValue(bean);
            }
        } else if (this.isTextArea(bean)) {
            submitted = SimpleInputTextRenderer._normalizeWhitespace((String)submitted);
        }
        return submitted;
    }

    protected void encodeAllAsElement(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        if (this.isAutoSubmit(bean)) {
            AutoSubmitUtils.writeDependencies(context, arc);
        }
        ResponseWriter rw = context.getResponseWriter();
        this.addOnSubmitConverterValidators(context, arc, component, bean);
        if (this.isSimpleInputText(bean)) {
            rw.startElement("span", component);
            this.renderRootDomElementStyles(context, arc, component, bean);
        }
        if (this.isTextArea(bean)) {
            rw.startElement("textarea", component);
            this.renderId(context, component);
            this.renderAllAttributes(context, arc, bean, false);
            this.renderContent(context, arc, component, bean, true, true);
            rw.endElement("textarea");
        } else {
            rw.startElement("input", component);
            this.renderId(context, component);
            this.renderAllAttributes(context, arc, bean, false);
            String value = this.getConvertedString(context, component, bean);
            boolean secret = this.getSecret(bean);
            if (secret) {
                rw.writeAttribute("type", (Object)"password", "secret");
                if (value != null && !"".equals(value)) {
                    value = "******";
                }
            } else {
                rw.writeAttribute("type", (Object)this.getDefaultInputType(), null);
            }
            rw.writeAttribute("value", (Object)value, "value");
            rw.endElement("input");
        }
        if (this.isHiddenLabelRequired(arc)) {
            this.renderShortDescAsHiddenLabel(context, arc, component, bean);
        }
        if (this.isSimpleInputText(bean)) {
            rw.endElement("span");
        }
    }

    protected void renderAllAttributes(FacesContext context, RenderingContext rc, FacesBean bean, boolean renderStyleAttrs) throws IOException {
        int intCol;
        super.renderAllAttributes(context, rc, bean, false);
        ResponseWriter rw = context.getResponseWriter();
        boolean isTextArea = this.isTextArea(bean);
        Number columns = this.getColumns(bean);
        if (columns == null) {
            columns = this.getDefaultColumns(rc, bean);
        } else if (columns instanceof Number && (intCol = columns.intValue()) > 500) {
            intCol = 500;
            columns = intCol;
        }
        rw.writeAttribute(isTextArea ? "cols" : "size", (Object)columns, "columns");
        if (isTextArea) {
            int intRow;
            Number rows = this.getRows(bean);
            if (rows == null) {
                rows = this.getDefaultRows();
            } else if (rows instanceof Number && (intRow = rows.intValue()) > 500) {
                rows = 500;
            }
            rw.writeAttribute("rows", (Object)rows, "rows");
            rw.writeAttribute("wrap", this.getWrap(bean), "wrap");
            if ((this.getReadOnly(context, bean) || !SimpleInputTextRenderer.supportsEditing(rc)) && SimpleInputTextRenderer.supportsReadonlyFormElements(rc)) {
                rw.writeAttribute("readonly", (Object)Boolean.TRUE, "readOnly");
            }
        } else {
            Number maximumLength;
            String autocomplete;
            if (SimpleInputTextRenderer.supportsAutoCompleteFormElements(rc) && (autocomplete = this.getAutoComplete(bean)).equalsIgnoreCase("off")) {
                rw.writeAttribute("autocomplete", (Object)"off", "autoComplete");
            }
            if ((maximumLength = this.getMaximumLength(bean)) != null && maximumLength.intValue() > 0) {
                rw.writeAttribute("maxlength", (Object)maximumLength, "maximumLength");
            }
        }
    }

    protected String getRootStyleClass(FacesBean bean) {
        return "af|inputText";
    }

    protected int getDefaultRows() {
        return 5;
    }

    protected Integer getDefaultColumns(RenderingContext arc, FacesBean bean) {
        if (SimpleInputTextRenderer.isPDA((RenderingContext)arc)) {
            return _DEFAULT_PDA_COLUMNS;
        }
        return _DEFAULT_COLUMNS;
    }

    protected String getDefaultInputType() {
        return "text";
    }

    protected void renderEventHandlers(FacesContext context, FacesBean bean) throws IOException {
        super.renderEventHandlers(context, bean);
        ResponseWriter rw = context.getResponseWriter();
        rw.writeAttribute("onselect", (Object)this.getOnselect(bean), "onselect");
        rw.writeAttribute("onpaste", (Object)this.getOnpaste(bean), "onpaste");
    }

    protected void encodeAllAsNonElement(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        if (this.isTextArea(bean)) {
            this.renderContent(context, arc, component, bean, false, true);
        } else {
            ResponseWriter rw = context.getResponseWriter();
            boolean isSimple = this.isSimpleInputText(bean);
            if (isSimple) {
                rw.startElement("span", component);
                this.renderRootDomElementStyles(context, arc, component, bean);
                this.renderId(context, component);
            }
            rw.startElement("div", component);
            if (!isSimple) {
                this.renderId(context, component);
            }
            SimpleInputTextRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)this.getContentStyleClass(bean));
            SimpleInputTextRenderer.renderInlineStyleAttribute(context, arc, this.getContentStyle(bean));
            rw.writeAttribute("title", (Object)this.getShortDesc(bean), "shortDesc");
            this.renderContent(context, arc, component, bean, false, false);
            rw.endElement("div");
            if (this.isSimpleInputText(bean)) {
                rw.endElement("span");
            }
        }
    }

    protected void renderNonElementContent(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        throw new IllegalStateException("UNUSED");
    }

    protected void renderContent(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean, boolean renderAsElement, boolean isTextArea) throws IOException {
        String textValue = this.getConvertedString(context, component, bean);
        if (textValue == null || "".equals(textValue)) {
            return;
        }
        ResponseWriter rw = context.getResponseWriter();
        if (isTextArea) {
            if (!renderAsElement) {
                String textString;
                int textLength;
                rw.startElement("pre", null);
                this.renderId(context, component);
                rw.writeAttribute("title", (Object)this.getShortDesc(bean), "shortDesc");
                this.renderStyleAttributes(context, arc, bean, this.getContentStyleClass(bean));
                if (textValue != null && (textLength = (textString = textValue).length()) > 0) {
                    Object wrap = this.getWrap(bean);
                    if ("soft".equals(wrap) || "hard".equals(wrap)) {
                        int columns;
                        Number columnsObj = this.getColumns(bean);
                        if (columnsObj == null) {
                            columnsObj = this.getDefaultColumns(arc, bean);
                        }
                        int n = columns = columnsObj == null ? 0 : columnsObj.intValue();
                        if (columns <= 1 || columns > textLength) {
                            rw.writeText((Object)textString, "value");
                        } else {
                            BreakIterator breaks = BreakIterator.getLineInstance(context.getViewRoot().getLocale());
                            breaks.setText(textString);
                            this._writeTextWithBreaks(context, breaks, textString, columns);
                        }
                    } else {
                        rw.writeText((Object)textString, "value");
                    }
                }
                rw.endElement("pre");
            } else if (textValue != null) {
                rw.writeText((Object)textValue, "value");
            }
        } else if (!this.getSecret(bean) && textValue != null) {
            rw.writeText((Object)textValue, "value");
        }
    }

    private void _writeTextWithBreaks(FacesContext context, BreakIterator breaks, String textString, int columns) throws IOException {
        int start = 0;
        while (true) {
            int nextLineBreak;
            String substring = (nextLineBreak = textString.indexOf(10, start)) >= 0 ? textString.substring(start, nextLineBreak) : textString.substring(start);
            this._writeTextLineWithBreaks(context, breaks, substring, columns);
            if (nextLineBreak < 0) break;
            start = nextLineBreak + 1;
            char[] chars = new char[10];
            context.getResponseWriter().write(chars, 0, 1);
        }
    }

    private void _writeTextLineWithBreaks(FacesContext context, BreakIterator breaks, String textString, int columns) throws IOException {
        if (textString.length() < columns) {
            context.getResponseWriter().writeText((Object)textString, "value");
            return;
        }
        breaks.setText(textString);
        int lastStart = 0;
        int previous = 0;
        while (true) {
            int next;
            if ((next = breaks.next()) == -1) break;
            if (next - lastStart > columns) {
                if (previous == lastStart) {
                    previous = next;
                }
                String sub = textString.substring(lastStart, previous);
                char[] chars = new char[10];
                context.getResponseWriter().writeText((Object)sub, null);
                context.getResponseWriter().write(chars, 0, 1);
                lastStart = previous;
            }
            previous = next;
        }
        context.getResponseWriter().writeText((Object)textString.substring(lastStart), null);
    }

    protected String getOnkeyup(FacesBean bean) {
        Number maximumLength;
        String onKeyUp = super.getOnkeyup(bean);
        if (this.isTextArea(bean) && (maximumLength = this.getMaximumLength(bean)) != null && maximumLength.intValue() > 0) {
            onKeyUp = SimpleInputTextRenderer._getMaxLengthFunction(onKeyUp, maximumLength.intValue());
        }
        return onKeyUp;
    }

    protected String getOnkeydown(FacesBean bean) {
        String onKeydown = super.getOnkeydown(bean);
        if (this.getSecret(bean)) {
            onKeydown = XhtmlUtils.getChainedJS(_SECRET_KEYDOWN_SCRIPT, onKeydown, false);
        }
        return onKeydown;
    }

    protected String getOnfocus(FacesBean bean) {
        RenderingContext arc;
        String onfocus = super.getOnfocus(bean);
        if (this.isTextArea(bean) && this.getReadOnly(FacesContext.getCurrentInstance(), bean) && !SimpleInputTextRenderer.supportsReadonlyFormElements(arc = RenderingContext.getCurrentInstance())) {
            onfocus = XhtmlUtils.getChainedJS("this.blur()", onfocus, true);
        }
        return onfocus;
    }

    protected String getOnchange(FacesBean bean) {
        Number maxLength;
        String onchange = super.getOnchange(bean);
        if (this.isAutoSubmit(bean)) {
            RenderingContext arc = RenderingContext.getCurrentInstance();
            String source = LabelAndMessageRenderer.__getCachedClientId(arc);
            boolean immediate = this.isImmediate(bean);
            String auto = AutoSubmitUtils.getSubmitScript(arc, source, "autosub", immediate);
            if (onchange == null) {
                onchange = auto;
            } else if (auto != null) {
                onchange = XhtmlUtils.getChainedJS(onchange, auto, true);
            }
        }
        if (this.isTextArea(bean) && (maxLength = this.getMaximumLength(bean)) != null && maxLength.intValue() > 0) {
            onchange = SimpleInputTextRenderer._getMaxLengthFunction(onchange, maxLength.intValue());
        }
        return onchange;
    }

    protected String getOnpaste(FacesBean bean) {
        Number maximumLength;
        String onpaste = null;
        if (this.isTextArea(bean) && (maximumLength = this.getMaximumLength(bean)) != null && maximumLength.intValue() > 0) {
            onpaste = SimpleInputTextRenderer._getMaxLengthFunction(null, maximumLength.intValue());
        }
        return onpaste;
    }

    protected String getOnselect(FacesBean bean) {
        if (this._onselectKey == null) {
            return null;
        }
        return SimpleInputTextRenderer.toString((Object)bean.getProperty(this._onselectKey));
    }

    protected Number getColumns(FacesBean bean) {
        return (Number)bean.getProperty(this._columnsKey);
    }

    protected Number getRows(FacesBean bean) {
        return (Number)bean.getProperty(this._rowsKey);
    }

    protected Number getMaximumLength(FacesBean bean) {
        return (Number)bean.getProperty(this._maximumLengthKey);
    }

    protected Object getWrap(FacesBean bean) {
        return bean.getProperty(this._wrapKey);
    }

    protected boolean getSecret(FacesBean bean) {
        Object o = bean.getProperty(this._secretKey);
        if (o == null) {
            o = this._secretKey.getDefault();
        }
        assert (o != null);
        return !Boolean.FALSE.equals(o);
    }

    private boolean _isNumericField() {
        return false;
    }

    public boolean isTextArea(FacesBean bean) {
        Number rows = this.getRows(bean);
        return rows != null && rows.intValue() > 1;
    }

    protected boolean renderReadOnlyAsElement(RenderingContext arc, FacesBean bean) {
        if (!this.isTextArea(bean)) {
            return false;
        }
        return SimpleInputTextRenderer.supportsReadonlyFormElements(arc);
    }

    protected String getAutoComplete(FacesBean bean) {
        Object o = bean.getProperty(this._autoCompleteKey);
        if (o == null) {
            o = this._autoCompleteKey.getDefault();
        }
        return o.toString();
    }

    protected boolean isSimpleInputText(FacesBean bean) {
        return this.getSimple(bean);
    }

    private static String _getMaxLengthFunction(String userFunc, int length) {
        String functionCall = "return _checkLength(this," + IntegerUtils.getString((int)length) + ",event)";
        if (userFunc == null) {
            return functionCall;
        }
        return XhtmlUtils.getChainedJS(functionCall, userFunc, true);
    }

    private static final String _normalizeWhitespace(String str) {
        int rIndex;
        int from = 0;
        int length = str.length();
        StringBuffer buffer = null;
        do {
            if ((rIndex = str.indexOf(13, from)) < 0) {
                if (from == 0) {
                    return str;
                }
                assert (buffer != null);
                buffer.append(str.substring(from));
                return buffer.toString();
            }
            if (buffer == null) {
                buffer = new StringBuffer(length);
            }
            buffer.append(str.substring(from, rIndex));
            if (rIndex > 0 && str.charAt(rIndex - 1) == '\n' || rIndex + 1 < length && str.charAt(rIndex + 1) == '\n') continue;
            buffer.append('\n');
        } while ((from = rIndex + 1) < length);
        assert (buffer != null);
        return buffer.toString();
    }
}

