/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.html.HtmlCellFormat;
import org.apache.myfaces.trinidad.component.html.HtmlRowLayout;
import org.apache.myfaces.trinidad.component.html.HtmlTableLayout;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;

public class RowLayoutRenderer
extends XhtmlRenderer {
    private PropertyKey _widthKey;
    private PropertyKey _halignKey;
    private PropertyKey _valignKey;

    public RowLayoutRenderer() {
        super(HtmlRowLayout.TYPE);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._widthKey = type.findKey("width");
        this._halignKey = type.findKey("halign");
        this._valignKey = type.findKey("valign");
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeAll(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        boolean needsTable = RowLayoutRenderer._shouldRenderTable(component);
        rw.startElement(needsTable ? "table" : "tr", component);
        this.renderId(context, component);
        this.renderAllAttributes(context, rc, component, bean);
        RowLayoutRenderer.renderHAlign(context, rc, this.getHalign(component, bean));
        rw.writeAttribute("valign", this.getValign(component, bean), "valign");
        if (needsTable) {
            OutputUtils.renderLayoutTableAttributes(context, rc, 0, this.getWidth(component, bean));
            rw.startElement("tr", null);
        }
        this.encodeAllChildren(context, component);
        rw.endElement("tr");
        if (needsTable) {
            rw.endElement("table");
        }
    }

    private static boolean _shouldRenderTable(UIComponent component) {
        UIComponent parent = XhtmlUtils.getStructuralParent(component);
        return !(parent instanceof HtmlTableLayout);
    }

    protected void encodeChild(FacesContext context, UIComponent child) throws IOException {
        if (child instanceof HtmlCellFormat) {
            super.encodeChild(context, child);
        } else {
            ResponseWriter rw = context.getResponseWriter();
            rw.startElement("td", null);
            super.encodeChild(context, child);
            rw.endElement("td");
        }
    }

    protected Object getWidth(UIComponent component, FacesBean bean) {
        return bean.getProperty(this._widthKey);
    }

    protected Object getHalign(UIComponent component, FacesBean bean) {
        return bean.getProperty(this._halignKey);
    }

    protected Object getValign(UIComponent component, FacesBean bean) {
        return bean.getProperty(this._valignKey);
    }
}

