/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.ui;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import jpt.sun.source.tree.ClassTree;
import jpt.sun.source.tree.NewClassTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.util.TreePath;
import jpt.sun.source.util.TreePathScanner;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.ExecutableElement;
import jpt30.lang.model.element.NestingKind;
import jpt30.lang.model.element.PackageElement;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.element.TypeParameterElement;
import jpt30.lang.model.element.VariableElement;
import jpt30.lang.model.type.ArrayType;
import jpt30.lang.model.type.TypeKind;
import jpt30.lang.model.type.TypeMirror;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.TypeUtilities;
import org.netbeans.api.java.source.ui.ElementHeaders;
import org.netbeans.api.lsp.StructureElement;
import org.netbeans.modules.java.source.ui.Bundle;
import org.netbeans.modules.java.source.ui.ElementOpenAccessor;
import org.netbeans.spi.lsp.StructureProvider;
import org.openide.filesystems.FileObject;

public class LspElementUtils {
    public static StructureElement element2StructureElement(CompilationInfo info, Element el, TreePath elPath, ElementUtilities.ElementAcceptor childAcceptor, boolean allowResources, boolean bypassOpen, FileObject parentFile) {
        TreePath path;
        TreePath treePath = path = elPath != null ? elPath : info.getTrees().getPath(el);
        if (!allowResources) {
            if (path == null) {
                return null;
            }
            TreeUtilities tu = info.getTreeUtilities();
            if (tu.isSynthetic(path)) {
                return null;
            }
        }
        StructureProvider.Builder builder = StructureProvider.newBuilder(LspElementUtils.createName(info, el), ElementHeaders.javaKind2Structure(el));
        builder.detail(LspElementUtils.createDetail(info, el));
        FileObject f = null;
        FileObject owner = null;
        if (!bypassOpen) {
            FileObject file;
            owner = f = (file = LspElementUtils.setOffsets(info, el, path, builder));
        } else {
            f = null;
            owner = parentFile;
        }
        if (owner == null && !bypassOpen && allowResources) {
            owner = LspElementUtils.findOwnerResource(info, el);
        }
        if (f == null && owner != null) {
            builder.file(owner);
        }
        if (info.getElements().isDeprecated(el)) {
            builder.addTag(StructureElement.Tag.Deprecated);
        }
        if (childAcceptor != null) {
            for (Element element : el.getEnclosedElements()) {
                StructureElement jse;
                TypeMirror m;
                TreePath p = LspElementUtils.getChildPath(info, element, path);
                if (!allowResources && p == null || !childAcceptor.accept(element, m = element.asType()) || (jse = LspElementUtils.element2StructureElement(info, element, p, childAcceptor, allowResources, f == null, owner)) == null) continue;
                builder.children(jse);
            }
            if (path != null && (path.getLeaf().getKind() == Tree.Kind.METHOD || path.getLeaf().getKind() == Tree.Kind.VARIABLE)) {
                LspElementUtils.getAnonymousInnerClasses(info, path, builder, childAcceptor);
            }
            builder.children(new StructureElement[0]);
        }
        return builder.build();
    }

    private static TreePath getChildPath(CompilationInfo ci, Element child, TreePath parentPath) {
        if (parentPath != null && child != null && TreeUtilities.CLASS_TREE_KINDS.contains((Object)parentPath.getLeaf().getKind())) {
            ClassTree ct = (ClassTree)parentPath.getLeaf();
            for (Tree tree : ct.getMembers()) {
                TreePath memberPath = new TreePath(parentPath, tree);
                if (!child.equals(ci.getTrees().getElement(memberPath))) continue;
                return memberPath;
            }
        }
        return ci.getTrees().getPath(child);
    }

    public static StructureElement element2StructureElement(CompilationInfo info, Element el, ElementUtilities.ElementAcceptor childAcceptor) {
        return LspElementUtils.element2StructureElement(info, el, null, childAcceptor, false, false, null);
    }

    static FileObject findOwnerResource(CompilationInfo info, Element el) {
        ClassPath[] cps;
        int lastSlash;
        String s;
        ElementKind ek = el.getKind();
        if (ek == ElementKind.MODULE) {
            return null;
        }
        Element parent = el;
        if (!(ek.isClass() || ek.isInterface() || (parent = el.getEnclosingElement()).getKind().isClass() || parent.getKind().isInterface())) {
            return null;
        }
        ElementHandle<Element> h = ElementHandle.create(parent);
        int dollar = (s = h.getBinaryName()).substring((lastSlash = s.lastIndexOf(46)) + 1).indexOf(36);
        String resourceName = s.substring(0, dollar >= 0 ? lastSlash + 1 + dollar : s.length()).replace(".", "/");
        ClasspathInfo cpInfo = info.getClasspathInfo();
        for (ClassPath cp : cps = new ClassPath[]{cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE), cpInfo.getClassPath(ClasspathInfo.PathKind.OUTPUT), cpInfo.getClassPath(ClasspathInfo.PathKind.BOOT), cpInfo.getClassPath(ClasspathInfo.PathKind.COMPILE)}) {
            FileObject f = cp.findResource(resourceName);
            if (f == null) continue;
            return f;
        }
        return null;
    }

    public static StructureElement describeElement(CompilationInfo info, Element el, ElementUtilities.ElementAcceptor childAcceptor, boolean allowBinary) {
        return LspElementUtils.element2StructureElement(info, el, null, childAcceptor, allowBinary, false, null);
    }

    public static CompletableFuture<StructureElement> createStructureElement(CompilationInfo info, Element el, boolean resolveSources) {
        TreePath path = info.getTrees().getPath(el);
        AtomicBoolean cancel = new AtomicBoolean();
        CompletableFuture<StructureProvider.Builder> f1 = LspElementUtils.createStructureElement0(path, info, el, cancel, resolveSources);
        CompletionStage ret = f1.thenApply(b -> b == null ? null : b.build());
        ((CompletableFuture)ret).exceptionally(t -> {
            if (t instanceof CompletionException) {
                t = t.getCause();
            }
            if (t instanceof CancellationException) {
                cancel.set(true);
                f1.cancel(true);
            }
            return null;
        });
        return ret;
    }

    private static CompletableFuture<StructureProvider.Builder> createStructureElement0(TreePath path, CompilationInfo info, Element el, AtomicBoolean cancel, boolean acquire) {
        StructureProvider.Builder builder = StructureProvider.newBuilder(LspElementUtils.createName(info, el), ElementHeaders.javaKind2Structure(el));
        builder.detail(LspElementUtils.createDetail(info, el));
        if (info.getElements().isDeprecated(el)) {
            builder.addTag(StructureElement.Tag.Deprecated);
        }
        return LspElementUtils.setFutureOffsets(info, el, builder, cancel, acquire);
    }

    private static String createName(CompilationInfo ci, Element original) {
        switch (original.getKind()) {
            case PACKAGE: {
                PackageElement pe = (PackageElement)original;
                return pe.getSimpleName().toString();
            }
            case CLASS: 
            case INTERFACE: 
            case ENUM: 
            case ANNOTATION_TYPE: 
            case RECORD: {
                TypeElement te = (TypeElement)original;
                StringBuilder sb = new StringBuilder();
                if (te.getNestingKind() == NestingKind.ANONYMOUS) {
                    String name = te.getInterfaces().isEmpty() ? te.getSuperclass().toString() : te.getInterfaces().get(0).toString();
                    sb.append(Bundle.LBL_AnonymousClass(name));
                } else {
                    sb.append(te.getSimpleName());
                }
                List<? extends TypeParameterElement> typeParams = te.getTypeParameters();
                if (typeParams != null && !typeParams.isEmpty()) {
                    sb.append("<");
                    Iterator<? extends TypeParameterElement> it = typeParams.iterator();
                    while (it.hasNext()) {
                        TypeParameterElement tp = it.next();
                        sb.append(tp.getSimpleName());
                        List<? extends TypeMirror> bounds = tp.getBounds();
                        if (!(bounds.isEmpty() || bounds.size() <= 1 && "java.lang.Object".equals(bounds.get(0).toString()))) {
                            sb.append(" extends ");
                            Iterator<? extends TypeMirror> bIt = bounds.iterator();
                            while (bIt.hasNext()) {
                                sb.append(LspElementUtils.getTypeName(ci, bIt.next(), false));
                                if (!bIt.hasNext()) continue;
                                sb.append(" & ");
                            }
                        }
                        if (!it.hasNext()) continue;
                        sb.append(", ");
                    }
                    sb.append(">");
                }
                return sb.toString();
            }
            case FIELD: 
            case ENUM_CONSTANT: 
            case RECORD_COMPONENT: {
                return original.getSimpleName().toString();
            }
            case CONSTRUCTOR: 
            case METHOD: {
                ExecutableElement ee = (ExecutableElement)original;
                StringBuilder sb = new StringBuilder();
                if (ee.getKind() == ElementKind.CONSTRUCTOR) {
                    sb.append(ee.getEnclosingElement().getSimpleName());
                } else {
                    sb.append(ee.getSimpleName());
                }
                sb.append("(");
                Iterator<? extends VariableElement> it = ee.getParameters().iterator();
                while (it.hasNext()) {
                    VariableElement param = it.next();
                    if (!it.hasNext() && ee.isVarArgs() && param.asType().getKind() == TypeKind.ARRAY) {
                        sb.append(LspElementUtils.getTypeName(ci, ((ArrayType)param.asType()).getComponentType(), false, false));
                        sb.append("...");
                    } else {
                        sb.append(LspElementUtils.getTypeName(ci, param.asType(), false, false));
                    }
                    sb.append(" ");
                    sb.append(param.getSimpleName());
                    if (!it.hasNext()) continue;
                    sb.append(", ");
                }
                sb.append(")");
                return sb.toString();
            }
        }
        return null;
    }

    private static String createDetail(CompilationInfo ci, Element original) {
        ElementKind kind = original.getKind();
        String detail = null;
        if (kind == ElementKind.FIELD || kind == ElementKind.METHOD) {
            StringBuilder sb = new StringBuilder();
            if (kind == ElementKind.FIELD) {
                sb.append(": ");
                sb.append(LspElementUtils.getTypeName(ci, original.asType(), false));
                detail = sb.toString();
            } else {
                TypeMirror rt = ((ExecutableElement)original).getReturnType();
                if (rt.getKind() == TypeKind.VOID) {
                    sb.append(": void");
                } else {
                    sb.append(": ");
                    sb.append(LspElementUtils.getTypeName(ci, rt, false));
                }
            }
            detail = sb.toString();
        }
        return detail;
    }

    private static StructureProvider.Builder processOffsetInfo(Object[] info, StructureProvider.Builder builder) {
        if (info == null) {
            return builder;
        }
        TreePathHandle pathHandle = (TreePathHandle)info[6];
        FileObject f = (FileObject)info[0];
        boolean[] synthetic = new boolean[]{false};
        if (f != null) {
            builder.file(f);
            if (pathHandle != null) {
                try {
                    JavaSource js = JavaSource.forFileObject(f);
                    if (js == null) {
                        return null;
                    }
                    js.runUserActionTask(cc -> {
                        TreePath path = pathHandle.resolve((CompilationInfo)cc);
                        synthetic[0] = cc.getTreeUtilities().isSynthetic(path);
                    }, true);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (synthetic[0]) {
            return null;
        }
        LspElementUtils.fillInPositions(info, builder);
        return builder;
    }

    private static void fillInPositions(Object[] info, StructureProvider.Builder builder) {
        int selEnd;
        int selStart = (Integer)info[3];
        if (selStart < 0) {
            selStart = (Integer)info[1];
        }
        if ((selEnd = ((Integer)info[4]).intValue()) < 0) {
            selEnd = (Integer)info[2];
        }
        builder.expandedStartOffset((Integer)info[1]).expandedEndOffset((Integer)info[2]);
        builder.selectionStartOffset(selStart).selectionEndOffset(selEnd);
    }

    private static CompletableFuture<StructureProvider.Builder> setFutureOffsets(CompilationInfo ci, Element original, StructureProvider.Builder builder, AtomicBoolean cancel, boolean acquire) {
        TypeElement e;
        ElementHandle<Element> h = ElementHandle.create(original);
        Object name = original.getKind().isClass() || original.getKind().isInterface() ? h.getBinaryName().replace(".", "/") + ".class" : ((e = ci.getElementUtilities().enclosingTypeElement(original)) != null ? e.getQualifiedName().toString() : h.getBinaryName());
        return ElementOpenAccessor.getInstance().getOpenInfoFuture(ci.getClasspathInfo(), h, (String)name, cancel, acquire).thenApply(info -> LspElementUtils.processOffsetInfo(info, builder));
    }

    private static FileObject setOffsets(CompilationInfo ci, Element original, TreePath originalPath, StructureProvider.Builder builder) {
        if (originalPath != null && originalPath.getCompilationUnit() == ci.getCompilationUnit()) {
            Object[] positions = new Object[]{null, -1, -1, -1, -1};
            builder.file(ci.getFileObject());
            if (ci.getTreeUtilities().isSynthetic(originalPath)) {
                return null;
            }
            ElementOpenAccessor.getInstance().fillInTreePositions(ci, originalPath.getLeaf(), positions);
            LspElementUtils.fillInPositions(positions, builder);
            return ci.getFileObject();
        }
        ElementHandle<Element> h = ElementHandle.create(original);
        Object[] openInfo = ElementOpenAccessor.getInstance().getOpenInfo(ci.getClasspathInfo(), h, new AtomicBoolean());
        LspElementUtils.processOffsetInfo(openInfo, builder);
        return (FileObject)openInfo[0];
    }

    private static void getAnonymousInnerClasses(final CompilationInfo info, TreePath path, final StructureProvider.Builder builder, final ElementUtilities.ElementAcceptor childAcceptor) {
        new TreePathScanner<Void, Void>(){

            @Override
            public Void visitNewClass(NewClassTree node, Void p) {
                if (node.getClassBody() != null) {
                    StructureElement jse;
                    TreePath bodyPath = new TreePath(this.getCurrentPath(), node.getClassBody());
                    Element e = info.getTrees().getElement(bodyPath);
                    if (e != null && childAcceptor.accept(e, e.asType()) && (jse = LspElementUtils.element2StructureElement(info, e, bodyPath, childAcceptor, false, false, null)) != null) {
                        builder.children(jse);
                    }
                }
                return null;
            }

            @Override
            public Void visitClass(ClassTree node, Void p) {
                StructureElement jse;
                TypeMirror m;
                Element e = info.getTrees().getElement(this.getCurrentPath());
                if (e != null & childAcceptor.accept(e, m = info.getTrees().getTypeMirror(this.getCurrentPath())) && (jse = LspElementUtils.element2StructureElement(info, e, this.getCurrentPath(), childAcceptor, false, false, null)) != null) {
                    builder.children(jse);
                }
                return (Void)super.visitClass(node, p);
            }
        }.scan(path, (Void)null);
    }

    public static CharSequence getTypeName(CompilationInfo info, TypeMirror type, boolean fqn) {
        return LspElementUtils.getTypeName(info, type, fqn, false);
    }

    public static CharSequence getTypeName(CompilationInfo info, TypeMirror type, boolean fqn, boolean varArg) {
        EnumSet<TypeUtilities.TypeNameOptions> options = EnumSet.noneOf(TypeUtilities.TypeNameOptions.class);
        if (fqn) {
            options.add(TypeUtilities.TypeNameOptions.PRINT_FQN);
        }
        if (varArg) {
            options.add(TypeUtilities.TypeNameOptions.PRINT_AS_VARARG);
        }
        return info.getTypeUtilities().getTypeName(type, options.toArray(new TypeUtilities.TypeNameOptions[0]));
    }
}

