/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.nifi;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.toolkit.cli.impl.result.writer.DynamicTableWriter;
import org.apache.nifi.toolkit.cli.impl.result.writer.Table;
import org.apache.nifi.web.api.dto.ControllerServiceDTO;
import org.apache.nifi.web.api.dto.ReportingTaskDTO;
import org.apache.nifi.web.api.entity.ControllerServiceEntity;
import org.apache.nifi.web.api.entity.ReportingTaskEntity;
import org.apache.nifi.web.api.entity.VersionedReportingTaskImportResponseEntity;

public class ImportReportingTasksResult
extends AbstractWritableResult<VersionedReportingTaskImportResponseEntity> {
    private static final String REPORTING_TASK_TYPE = "REPORTING_TASK";
    private static final String CONTROLLER_SERVICE_TYPE = "CONTROLLER_SERVICE";
    private final VersionedReportingTaskImportResponseEntity responseEntity;

    public ImportReportingTasksResult(ResultType resultType, VersionedReportingTaskImportResponseEntity responseEntity) {
        super(resultType);
        this.responseEntity = responseEntity;
    }

    @Override
    public VersionedReportingTaskImportResponseEntity getResult() {
        return this.responseEntity;
    }

    @Override
    protected void writeSimpleResult(PrintStream output) throws IOException {
        Set tasksEntities = this.responseEntity.getReportingTasks();
        Set serviceEntities = this.responseEntity.getControllerServices();
        if (tasksEntities == null || serviceEntities == null) {
            return;
        }
        List taskDTOS = tasksEntities.stream().map(ReportingTaskEntity::getComponent).sorted(Comparator.comparing(ReportingTaskDTO::getName)).collect(Collectors.toList());
        List serviceDTOS = serviceEntities.stream().map(ControllerServiceEntity::getComponent).sorted(Comparator.comparing(ControllerServiceDTO::getName)).collect(Collectors.toList());
        Table table = new Table.Builder().column("#", 3, 3, false).column("Name", 5, 40, true).column("ID", 36, 36, false).column("Type", 15, 20, true).build();
        int componentCount = 0;
        for (ReportingTaskDTO taskDTO : taskDTOS) {
            table.addRow(String.valueOf(++componentCount), taskDTO.getName(), taskDTO.getId(), REPORTING_TASK_TYPE);
        }
        for (ControllerServiceDTO serviceDTO : serviceDTOS) {
            table.addRow(String.valueOf(++componentCount), serviceDTO.getName(), serviceDTO.getId(), CONTROLLER_SERVICE_TYPE);
        }
        DynamicTableWriter tableWriter = new DynamicTableWriter();
        tableWriter.write(table, output);
    }
}

