/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation.beanvalidation;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.util.Assert;

public class SpringConstraintValidatorFactory
implements ConstraintValidatorFactory {
    private final AutowireCapableBeanFactory beanFactory;
    private final @Nullable ConstraintValidatorFactory defaultConstraintValidatorFactory;

    public SpringConstraintValidatorFactory(AutowireCapableBeanFactory beanFactory) {
        Assert.notNull((Object)beanFactory, (String)"BeanFactory must not be null");
        this.beanFactory = beanFactory;
        this.defaultConstraintValidatorFactory = null;
    }

    public SpringConstraintValidatorFactory(AutowireCapableBeanFactory beanFactory, ConstraintValidatorFactory defaultConstraintValidatorFactory) {
        Assert.notNull((Object)beanFactory, (String)"BeanFactory must not be null");
        this.beanFactory = beanFactory;
        this.defaultConstraintValidatorFactory = defaultConstraintValidatorFactory;
    }

    public <T extends ConstraintValidator<?, ?>> T getInstance(Class<T> key) {
        String providerModuleName;
        if (this.defaultConstraintValidatorFactory != null && (providerModuleName = this.defaultConstraintValidatorFactory.getClass().getModule().getName()) != null && providerModuleName.equals(key.getModule().getName())) {
            return (T)this.defaultConstraintValidatorFactory.getInstance(key);
        }
        return (T)((ConstraintValidator)this.beanFactory.createBean(key));
    }

    public void releaseInstance(ConstraintValidator<?, ?> instance) {
        this.beanFactory.destroyBean(instance);
    }
}

