/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.security.authorization.resource;

import java.util.Map;
import org.apache.nifi.registry.security.authorization.AuthorizationResult;
import org.apache.nifi.registry.security.authorization.Authorizer;
import org.apache.nifi.registry.security.authorization.RequestAction;
import org.apache.nifi.registry.security.authorization.exception.AccessDeniedException;
import org.apache.nifi.registry.security.authorization.resource.Authorizable;
import org.apache.nifi.registry.security.authorization.user.NiFiUser;

public interface InheritingAuthorizable
extends Authorizable {
    @Override
    default public AuthorizationResult checkAuthorization(Authorizer authorizer, RequestAction action, NiFiUser user, Map<String, String> resourceContext) {
        if (user == null) {
            throw new AccessDeniedException("Unknown user.");
        }
        AuthorizationResult resourceResult = Authorizable.super.checkAuthorization(authorizer, action, user, resourceContext);
        if (AuthorizationResult.Result.Denied.equals((Object)resourceResult.getResult()) && this.getParentAuthorizable() != null) {
            return this.getParentAuthorizable().checkAuthorization(authorizer, action, user, resourceContext);
        }
        return resourceResult;
    }

    @Override
    default public void authorize(Authorizer authorizer, RequestAction action, NiFiUser user, Map<String, String> resourceContext) throws AccessDeniedException {
        if (user == null) {
            throw new AccessDeniedException("Unknown user.");
        }
        try {
            Authorizable.super.authorize(authorizer, action, user, resourceContext);
        }
        catch (AccessDeniedException resourceDenied) {
            try {
                if (this.getParentAuthorizable() == null) {
                    throw resourceDenied;
                }
                this.getParentAuthorizable().authorize(authorizer, action, user, resourceContext);
            }
            catch (AccessDeniedException policiesDenied) {
                throw resourceDenied;
            }
        }
    }
}

