/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.client.impl;

import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.toolkit.client.ReportingTasksClient;
import org.apache.nifi.toolkit.client.RequestConfig;
import org.apache.nifi.toolkit.client.impl.AbstractJerseyClient;
import org.apache.nifi.web.api.dto.RevisionDTO;
import org.apache.nifi.web.api.entity.PropertyDescriptorEntity;
import org.apache.nifi.web.api.entity.ReportingTaskEntity;
import org.apache.nifi.web.api.entity.ReportingTaskRunStatusEntity;
import org.apache.nifi.web.api.entity.VerifyConfigRequestEntity;

public class JerseyReportingTasksClient
extends AbstractJerseyClient
implements ReportingTasksClient {
    private final WebTarget reportingTasksTarget;

    public JerseyReportingTasksClient(WebTarget baseTarget) {
        this(baseTarget, null);
    }

    public JerseyReportingTasksClient(WebTarget baseTarget, RequestConfig requestConfig) {
        super(requestConfig);
        this.reportingTasksTarget = baseTarget.path("/reporting-tasks");
    }

    @Override
    public ReportingTaskEntity getReportingTask(String id) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("Reporting task id cannot be null");
        }
        return this.executeAction("Error retrieving status of reporting task", () -> {
            WebTarget target = this.reportingTasksTarget.path(id);
            return (ReportingTaskEntity)this.getRequestBuilder(target).get(ReportingTaskEntity.class);
        });
    }

    @Override
    public ReportingTaskEntity updateReportingTask(ReportingTaskEntity reportingTaskEntity) throws NiFiClientException, IOException {
        if (reportingTaskEntity == null) {
            throw new IllegalArgumentException("Reporting Task cannot be null");
        }
        if (reportingTaskEntity.getComponent() == null) {
            throw new IllegalArgumentException("Component cannot be null");
        }
        return this.executeAction("Error updating Reporting Task", () -> {
            WebTarget target = this.reportingTasksTarget.path(reportingTaskEntity.getId());
            return (ReportingTaskEntity)this.getRequestBuilder(target).put(Entity.entity((Object)reportingTaskEntity, (MediaType)MediaType.APPLICATION_JSON_TYPE), ReportingTaskEntity.class);
        });
    }

    @Override
    public ReportingTaskEntity activateReportingTask(String id, ReportingTaskRunStatusEntity runStatusEntity) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("Reporting task id cannot be null");
        }
        if (runStatusEntity == null) {
            throw new IllegalArgumentException("Entity cannnot be null");
        }
        return this.executeAction("Error starting or stopping report task", () -> {
            WebTarget target = this.reportingTasksTarget.path("{id}/run-status").resolveTemplate("id", (Object)id);
            return (ReportingTaskEntity)this.getRequestBuilder(target).put(Entity.entity((Object)runStatusEntity, (MediaType)MediaType.APPLICATION_JSON_TYPE), ReportingTaskEntity.class);
        });
    }

    @Override
    public VerifyConfigRequestEntity submitConfigVerificationRequest(VerifyConfigRequestEntity configRequestEntity) throws NiFiClientException, IOException {
        if (configRequestEntity == null) {
            throw new IllegalArgumentException("Config Request Entity cannot be null");
        }
        if (configRequestEntity.getRequest() == null) {
            throw new IllegalArgumentException("Config Request DTO cannot be null");
        }
        if (configRequestEntity.getRequest().getComponentId() == null) {
            throw new IllegalArgumentException("Reporting Task ID cannot be null");
        }
        if (configRequestEntity.getRequest().getProperties() == null) {
            throw new IllegalArgumentException("Reporting Task properties cannot be null");
        }
        return this.executeAction("Error submitting Config Verification Request", () -> {
            WebTarget target = this.reportingTasksTarget.path("{id}/config/verification-requests").resolveTemplate("id", (Object)configRequestEntity.getRequest().getComponentId());
            return (VerifyConfigRequestEntity)this.getRequestBuilder(target).post(Entity.entity((Object)configRequestEntity, (MediaType)MediaType.APPLICATION_JSON_TYPE), VerifyConfigRequestEntity.class);
        });
    }

    @Override
    public VerifyConfigRequestEntity getConfigVerificationRequest(String taskId, String verificationRequestId) throws NiFiClientException, IOException {
        if (verificationRequestId == null) {
            throw new IllegalArgumentException("Verification Request ID cannot be null");
        }
        return this.executeAction("Error retrieving Config Verification Request", () -> {
            WebTarget target = this.reportingTasksTarget.path("{id}/config/verification-requests/{requestId}").resolveTemplate("id", (Object)taskId).resolveTemplate("requestId", (Object)verificationRequestId);
            return (VerifyConfigRequestEntity)this.getRequestBuilder(target).get(VerifyConfigRequestEntity.class);
        });
    }

    @Override
    public VerifyConfigRequestEntity deleteConfigVerificationRequest(String taskId, String verificationRequestId) throws NiFiClientException, IOException {
        if (verificationRequestId == null) {
            throw new IllegalArgumentException("Verification Request ID cannot be null");
        }
        return this.executeAction("Error deleting Config Verification Request", () -> {
            WebTarget target = this.reportingTasksTarget.path("{id}/config/verification-requests/{requestId}").resolveTemplate("id", (Object)taskId).resolveTemplate("requestId", (Object)verificationRequestId);
            return (VerifyConfigRequestEntity)this.getRequestBuilder(target).delete(VerifyConfigRequestEntity.class);
        });
    }

    @Override
    public ReportingTaskEntity deleteReportingTask(ReportingTaskEntity reportingTask) throws NiFiClientException, IOException {
        if (reportingTask == null) {
            throw new IllegalArgumentException("Reporting Task Entity cannot be null");
        }
        if (reportingTask.getId() == null) {
            throw new IllegalArgumentException("Reporting Task ID cannot be null");
        }
        RevisionDTO revision = reportingTask.getRevision();
        if (revision == null) {
            throw new IllegalArgumentException("Revision cannot be null");
        }
        return this.executeAction("Error deleting Reporting Task", () -> {
            WebTarget target = this.reportingTasksTarget.path("{id}").resolveTemplate("id", (Object)reportingTask.getId()).queryParam("version", new Object[]{revision.getVersion()}).queryParam("clientId", new Object[]{revision.getClientId()});
            if (reportingTask.isDisconnectedNodeAcknowledged() == Boolean.TRUE) {
                target = target.queryParam("disconnectedNodeAcknowledged", new Object[]{"true"});
            }
            return (ReportingTaskEntity)this.getRequestBuilder(target).delete(ReportingTaskEntity.class);
        });
    }

    @Override
    public PropertyDescriptorEntity getPropertyDescriptor(String componentId, String propertyName, Boolean sensitive) throws NiFiClientException, IOException {
        Objects.requireNonNull(componentId, "Component ID required");
        Objects.requireNonNull(propertyName, "Property Name required");
        return this.executeAction("Error retrieving Property Descriptor", () -> {
            WebTarget target = this.reportingTasksTarget.path("{id}/descriptors").resolveTemplate("id", (Object)componentId).queryParam("propertyName", new Object[]{propertyName}).queryParam("sensitive", new Object[]{sensitive});
            return (PropertyDescriptorEntity)this.getRequestBuilder(target).get(PropertyDescriptorEntity.class);
        });
    }
}

