/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.netpreserve.jwarc.MediaType;
import org.netpreserve.jwarc.MessageBody;
import org.netpreserve.jwarc.MessageHeaders;
import org.netpreserve.jwarc.MessageVersion;
import org.netpreserve.jwarc.WarcRecord;

public class Warcinfo
extends WarcRecord {
    private MessageHeaders fields;

    Warcinfo(MessageVersion version, MessageHeaders headers, MessageBody body) {
        super(version, headers, body);
    }

    public Optional<String> filename() {
        return this.headers().sole("WARC-Filename");
    }

    public MessageHeaders fields() throws IOException {
        if (this.fields == null) {
            this.fields = MessageHeaders.parse(this.body());
        }
        return this.fields;
    }

    public static class Builder
    extends WarcRecord.AbstractBuilder<Warcinfo, Builder> {
        public Builder() {
            super("warcinfo");
        }

        public Builder filename(String filename) {
            return (Builder)this.setHeader("WARC-Filename", filename);
        }

        @Override
        public Warcinfo build() {
            return this.build(Warcinfo::new);
        }

        public Builder fields(Map<String, List<String>> map) {
            return (Builder)this.body(MediaType.WARC_FIELDS, MessageHeaders.format(map).getBytes(StandardCharsets.UTF_8));
        }
    }
}

