/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.service.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.nutch.scoring.webgraph.LinkDatum;
import org.apache.nutch.service.NutchReader;

public class LinkReader
implements NutchReader {
    public List<HashMap<String, String>> read(String path) throws FileNotFoundException {
        ArrayList<HashMap<String, String>> rows = new ArrayList<HashMap<String, String>>();
        Path file = new Path(path);
        try {
            SequenceFile.Reader reader = new SequenceFile.Reader(conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)file)});
            Writable key = (Writable)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)conf);
            LinkDatum value = new LinkDatum();
            while (reader.next(key, (Writable)value)) {
                try {
                    HashMap<String, String> t_row = this.getLinksRow(key, value);
                    rows.add(t_row);
                }
                catch (Exception exception) {}
            }
            reader.close();
        }
        catch (FileNotFoundException fne) {
            throw new FileNotFoundException();
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.error("Error occurred while reading file {} : {}", (Object)file, (Object)StringUtils.stringifyException((Throwable)e));
            throw new WebApplicationException();
        }
        return rows;
    }

    public List<HashMap<String, String>> head(String path, int nrows) throws FileNotFoundException {
        ArrayList<HashMap<String, String>> rows = new ArrayList<HashMap<String, String>>();
        Path file = new Path(path);
        try {
            SequenceFile.Reader reader = new SequenceFile.Reader(conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)file)});
            Writable key = (Writable)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)conf);
            LinkDatum value = new LinkDatum();
            for (int i = 0; reader.next(key, (Writable)value) && i < nrows; ++i) {
                HashMap<String, String> t_row = this.getLinksRow(key, value);
                rows.add(t_row);
            }
            reader.close();
        }
        catch (FileNotFoundException fne) {
            throw new FileNotFoundException();
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.error("Error occurred while reading file {} : {}", (Object)file, (Object)StringUtils.stringifyException((Throwable)e));
            throw new WebApplicationException();
        }
        return rows;
    }

    public List<HashMap<String, String>> slice(String path, int start, int end) throws FileNotFoundException {
        ArrayList<HashMap<String, String>> rows = new ArrayList<HashMap<String, String>>();
        Path file = new Path(path);
        try {
            int i;
            SequenceFile.Reader reader = new SequenceFile.Reader(conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)file)});
            Writable key = (Writable)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)conf);
            LinkDatum value = new LinkDatum();
            for (i = 0; i < start && reader.next(key, (Writable)value); ++i) {
            }
            while (reader.next(key, (Writable)value) && i < end) {
                HashMap<String, String> t_row = this.getLinksRow(key, value);
                rows.add(t_row);
                ++i;
            }
            reader.close();
        }
        catch (FileNotFoundException fne) {
            throw new FileNotFoundException();
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.error("Error occurred while reading file {} : {}", (Object)file, (Object)StringUtils.stringifyException((Throwable)e));
            throw new WebApplicationException();
        }
        return rows;
    }

    @Override
    public int count(String path) throws FileNotFoundException {
        Path file = new Path(path);
        int i = 0;
        try {
            SequenceFile.Reader reader = new SequenceFile.Reader(conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)file)});
            Writable key = (Writable)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)conf);
            Writable value = (Writable)ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)conf);
            while (reader.next(key, value)) {
                ++i;
            }
            reader.close();
        }
        catch (FileNotFoundException fne) {
            throw new FileNotFoundException();
        }
        catch (IOException e) {
            LOG.error("Error occurred while reading file {} : {}", (Object)file, (Object)StringUtils.stringifyException((Throwable)e));
            throw new WebApplicationException();
        }
        return i;
    }

    private HashMap<String, String> getLinksRow(Writable key, LinkDatum value) {
        HashMap<String, String> tRow = new HashMap<String, String>();
        tRow.put("key_url", key.toString());
        tRow.put("url", value.getUrl());
        tRow.put("anchor", value.getAnchor());
        tRow.put("score", String.valueOf(value.getScore()));
        tRow.put("timestamp", String.valueOf(value.getTimestamp()));
        tRow.put("linktype", String.valueOf(value.getLinkType()));
        return tRow;
    }
}

