/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opensearch.action.ActionListener;
import org.opensearch.action.admin.cluster.state.ClusterStateRequest;
import org.opensearch.action.admin.cluster.state.ClusterStateResponse;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.client.Requests;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.common.Strings;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsFilter;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.RestStatus;
import org.opensearch.rest.action.RestBuilderListener;

public class RestClusterStateAction
extends BaseRestHandler {
    private final SettingsFilter settingsFilter;
    private static final Set<String> RESPONSE_PARAMS;

    public RestClusterStateAction(SettingsFilter settingsFilter) {
        this.settingsFilter = settingsFilter;
    }

    @Override
    public String getName() {
        return "cluster_state_action";
    }

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_cluster/state"), new RestHandler.Route(RestRequest.Method.GET, "/_cluster/state/{metric}"), new RestHandler.Route(RestRequest.Method.GET, "/_cluster/state/{metric}/{indices}")));
    }

    @Override
    public boolean allowSystemIndexAccessByDefault() {
        return true;
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        boolean isAllIndicesOnly;
        final ClusterStateRequest clusterStateRequest = Requests.clusterStateRequest();
        clusterStateRequest.indicesOptions(IndicesOptions.fromRequest(request, clusterStateRequest.indicesOptions()));
        clusterStateRequest.local(request.paramAsBoolean("local", clusterStateRequest.local()));
        clusterStateRequest.masterNodeTimeout(request.paramAsTime("master_timeout", clusterStateRequest.masterNodeTimeout()));
        if (request.hasParam("wait_for_metadata_version")) {
            clusterStateRequest.waitForMetadataVersion(request.paramAsLong("wait_for_metadata_version", 0L));
        }
        clusterStateRequest.waitForTimeout(request.paramAsTime("wait_for_timeout", ClusterStateRequest.DEFAULT_WAIT_FOR_NODE_TIMEOUT));
        String[] indices = Strings.splitStringByCommaToArray(request.param("indices", "_all"));
        boolean bl = isAllIndicesOnly = indices.length == 1 && "_all".equals(indices[0]);
        if (!isAllIndicesOnly) {
            clusterStateRequest.indices(indices);
        }
        if (request.hasParam("metric")) {
            EnumSet<ClusterState.Metric> metrics = ClusterState.Metric.parseString(request.param("metric"), true);
            clusterStateRequest.nodes(metrics.contains((Object)ClusterState.Metric.NODES) || metrics.contains((Object)ClusterState.Metric.MASTER_NODE));
            clusterStateRequest.routingTable(metrics.contains((Object)ClusterState.Metric.ROUTING_TABLE) || metrics.contains((Object)ClusterState.Metric.ROUTING_NODES));
            clusterStateRequest.metadata(metrics.contains((Object)ClusterState.Metric.METADATA));
            clusterStateRequest.blocks(metrics.contains((Object)ClusterState.Metric.BLOCKS));
            clusterStateRequest.customs(metrics.contains((Object)ClusterState.Metric.CUSTOMS));
        }
        this.settingsFilter.addFilterSettingParams(request);
        return channel -> client.admin().cluster().state(clusterStateRequest, (ActionListener<ClusterStateResponse>)new RestBuilderListener<ClusterStateResponse>(channel){

            @Override
            public RestResponse buildResponse(ClusterStateResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                if (clusterStateRequest.waitForMetadataVersion() != null) {
                    builder.field("wait_for_timed_out", response.isWaitForTimedOut());
                }
                builder.field("cluster_name", response.getClusterName().value());
                ToXContent.DelegatingMapParams params = new ToXContent.DelegatingMapParams(Collections.singletonMap("context_mode", Metadata.CONTEXT_MODE_API), (ToXContent.Params)request);
                response.getState().toXContent(builder, (ToXContent.Params)params);
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }

    @Override
    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }

    @Override
    public boolean canTripCircuitBreaker() {
        return false;
    }

    static {
        HashSet<String> responseParams = new HashSet<String>();
        responseParams.add("metric");
        responseParams.addAll(Settings.FORMAT_PARAMS);
        RESPONSE_PARAMS = Collections.unmodifiableSet(responseParams);
    }

    static final class Fields {
        static final String WAIT_FOR_TIMED_OUT = "wait_for_timed_out";
        static final String CLUSTER_NAME = "cluster_name";

        Fields() {
        }
    }
}

