/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;
import org.archive.util.ProgressStatisticsReporter;
import org.archive.util.Reporter;
import org.archive.util.TextUtils;

public class DevUtils {
    public static Logger logger = Logger.getLogger(DevUtils.class.getName());

    public static void warnHandle(Throwable ex, String note) {
        logger.warning(TextUtils.exceptionToString(note, ex));
    }

    public static String extraInfo() {
        Object tt;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Thread current = Thread.currentThread();
        if (current instanceof Reporter) {
            tt = (Reporter)((Object)current);
            try {
                tt.reportTo(pw);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (current instanceof ProgressStatisticsReporter) {
            tt = (ProgressStatisticsReporter)((Object)current);
            try {
                tt.progressStatisticsLegend(pw);
                tt.progressStatisticsLine(pw);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        pw.flush();
        return sw.toString();
    }

    public static void sigquitSelf() {
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"perl", "-e", "print getppid(). \"\n\";"});
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream(), StandardCharsets.UTF_8));
            String ppid = br.readLine();
            Runtime.getRuntime().exec(new String[]{"sh", "-c", "kill -3 " + ppid}).waitFor();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

