/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.room;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.List;
import org.apache.openmeetings.db.dao.IGroupAdminDataProviderDao;
import org.apache.openmeetings.db.entity.room.ExtraMenu;
import org.apache.openmeetings.db.util.DaoHelper;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class ExtraMenuDao
implements IGroupAdminDataProviderDao<ExtraMenu> {
    private static final List<String> searchFields = List.of("name", "link", "description");
    @PersistenceContext
    private EntityManager em;

    @Override
    public ExtraMenu get(Long id) {
        return (ExtraMenu)DaoHelper.single(this.em.createNamedQuery("getExtraMenuById", ExtraMenu.class).getResultList());
    }

    @Override
    public ExtraMenu get(long id) {
        return this.get((Long)id);
    }

    @Override
    public List<ExtraMenu> get(long start, long count) {
        return DaoHelper.setLimits(this.em.createNamedQuery("getExtraMenus", ExtraMenu.class), start, count).getResultList();
    }

    @Override
    public List<ExtraMenu> get(String search, long start, long count, SortParam<String> sort) {
        return DaoHelper.get(this.em, ExtraMenu.class, false, search, searchFields, false, null, sort, start, count);
    }

    public List<ExtraMenu> getByGroups(List<Long> groups) {
        return this.em.createNamedQuery("getExtraMenuByGroups", ExtraMenu.class).setParameter("ids", groups).getResultList();
    }

    @Override
    public long count() {
        return (Long)this.em.createNamedQuery("countExtraMenus", Long.class).getSingleResult();
    }

    @Override
    public long count(String search) {
        return DaoHelper.count(this.em, ExtraMenu.class, search, searchFields, false, null);
    }

    @Override
    public ExtraMenu update(ExtraMenu entity, Long userId) {
        if (entity.getId() == null) {
            this.em.persist((Object)entity);
        } else {
            entity = (ExtraMenu)this.em.merge((Object)entity);
        }
        return entity;
    }

    @Override
    public void delete(ExtraMenu entity, Long userId) {
        this.em.remove((Object)entity);
    }

    @Override
    public List<ExtraMenu> adminGet(String search, Long adminId, long start, long count, SortParam<String> sort) {
        return DaoHelper.get(this.em, ExtraMenu.class, true, search, searchFields, false, (builder, query) -> this.getGroupFilter(adminId, (CriteriaBuilder)builder, (CriteriaQuery<?>)query), sort, start, count);
    }

    @Override
    public long adminCount(String search, Long adminId) {
        return DaoHelper.count(this.em, ExtraMenu.class, search, searchFields, false, (builder, query) -> this.getGroupFilter(adminId, (CriteriaBuilder)builder, (CriteriaQuery<?>)query));
    }

    private Predicate getGroupFilter(Long adminId, CriteriaBuilder builder, CriteriaQuery<?> query) {
        Root<ExtraMenu> root = DaoHelper.getRoot(query, ExtraMenu.class);
        return builder.in((Expression)root.get("groups")).value(DaoHelper.groupAdminQuery(adminId, builder, query));
    }
}

