/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance.impl;

import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.instance.impl.HazelcastInstanceImpl;
import com.hazelcast.internal.serialization.SerializationServiceAware;
import com.hazelcast.internal.services.NodeAware;

public final class HazelcastManagedContext
implements ManagedContext {
    private final HazelcastInstanceImpl instance;
    private final ManagedContext externalContext;
    private final boolean hasExternalContext;

    public HazelcastManagedContext(HazelcastInstanceImpl instance, ManagedContext externalContext) {
        this.instance = instance;
        this.externalContext = externalContext;
        this.hasExternalContext = externalContext != null;
    }

    @Override
    public Object initialize(Object obj) {
        Object aware;
        if (obj instanceof HazelcastInstanceAware) {
            aware = (HazelcastInstanceAware)obj;
            aware.setHazelcastInstance(this.instance);
        }
        if (obj instanceof NodeAware) {
            aware = (NodeAware)obj;
            aware.setNode(this.instance.node);
        }
        if (obj instanceof SerializationServiceAware) {
            aware = (SerializationServiceAware)obj;
            aware.setSerializationService(this.instance.node.getSerializationService());
        }
        if (this.hasExternalContext) {
            return this.externalContext.initialize(obj);
        }
        return obj;
    }
}

