/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.measurement;

import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.interactive.measurement.PDMeasureDictionary;

public class PDViewportDictionary
implements COSObjectable {
    public static final String TYPE = "Viewport";
    private final COSDictionary viewportDictionary;

    public PDViewportDictionary() {
        this.viewportDictionary = new COSDictionary();
    }

    public PDViewportDictionary(COSDictionary dictionary) {
        this.viewportDictionary = dictionary;
    }

    @Override
    public COSDictionary getCOSObject() {
        return this.viewportDictionary;
    }

    public String getType() {
        return TYPE;
    }

    public PDRectangle getBBox() {
        COSArray bbox = this.getCOSObject().getCOSArray(COSName.BBOX);
        return bbox != null ? new PDRectangle(bbox) : null;
    }

    public void setBBox(PDRectangle rectangle) {
        this.getCOSObject().setItem(COSName.BBOX, (COSObjectable)rectangle);
    }

    public String getName() {
        return this.getCOSObject().getNameAsString(COSName.NAME);
    }

    public void setName(String name) {
        this.getCOSObject().setName(COSName.NAME, name);
    }

    public PDMeasureDictionary getMeasure() {
        COSDictionary base = this.getCOSObject().getCOSDictionary(COSName.MEASURE);
        return base != null ? new PDMeasureDictionary(base) : null;
    }

    public void setMeasure(PDMeasureDictionary measure) {
        this.getCOSObject().setItem(COSName.MEASURE, (COSObjectable)measure);
    }
}

