/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// S7PayloadAlarmSC is the corresponding interface of S7PayloadAlarmSC
type S7PayloadAlarmSC interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	S7PayloadUserDataItem
	// GetAlarmMessage returns AlarmMessage (property field)
	GetAlarmMessage() AlarmMessagePushType
	// IsS7PayloadAlarmSC is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsS7PayloadAlarmSC()
	// CreateBuilder creates a S7PayloadAlarmSCBuilder
	CreateS7PayloadAlarmSCBuilder() S7PayloadAlarmSCBuilder
}

// _S7PayloadAlarmSC is the data-structure of this message
type _S7PayloadAlarmSC struct {
	S7PayloadUserDataItemContract
	AlarmMessage AlarmMessagePushType
}

var _ S7PayloadAlarmSC = (*_S7PayloadAlarmSC)(nil)
var _ S7PayloadUserDataItemRequirements = (*_S7PayloadAlarmSC)(nil)

// NewS7PayloadAlarmSC factory function for _S7PayloadAlarmSC
func NewS7PayloadAlarmSC(returnCode DataTransportErrorCode, transportSize DataTransportSize, dataLength uint16, alarmMessage AlarmMessagePushType) *_S7PayloadAlarmSC {
	if alarmMessage == nil {
		panic("alarmMessage of type AlarmMessagePushType for S7PayloadAlarmSC must not be nil")
	}
	_result := &_S7PayloadAlarmSC{
		S7PayloadUserDataItemContract: NewS7PayloadUserDataItem(returnCode, transportSize, dataLength),
		AlarmMessage:                  alarmMessage,
	}
	_result.S7PayloadUserDataItemContract.(*_S7PayloadUserDataItem)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// S7PayloadAlarmSCBuilder is a builder for S7PayloadAlarmSC
type S7PayloadAlarmSCBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(alarmMessage AlarmMessagePushType) S7PayloadAlarmSCBuilder
	// WithAlarmMessage adds AlarmMessage (property field)
	WithAlarmMessage(AlarmMessagePushType) S7PayloadAlarmSCBuilder
	// WithAlarmMessageBuilder adds AlarmMessage (property field) which is build by the builder
	WithAlarmMessageBuilder(func(AlarmMessagePushTypeBuilder) AlarmMessagePushTypeBuilder) S7PayloadAlarmSCBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() S7PayloadUserDataItemBuilder
	// Build builds the S7PayloadAlarmSC or returns an error if something is wrong
	Build() (S7PayloadAlarmSC, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() S7PayloadAlarmSC
}

// NewS7PayloadAlarmSCBuilder() creates a S7PayloadAlarmSCBuilder
func NewS7PayloadAlarmSCBuilder() S7PayloadAlarmSCBuilder {
	return &_S7PayloadAlarmSCBuilder{_S7PayloadAlarmSC: new(_S7PayloadAlarmSC)}
}

type _S7PayloadAlarmSCBuilder struct {
	*_S7PayloadAlarmSC

	parentBuilder *_S7PayloadUserDataItemBuilder

	collectedErr []error
}

var _ (S7PayloadAlarmSCBuilder) = (*_S7PayloadAlarmSCBuilder)(nil)

func (b *_S7PayloadAlarmSCBuilder) setParent(contract S7PayloadUserDataItemContract) {
	b.S7PayloadUserDataItemContract = contract
	contract.(*_S7PayloadUserDataItem)._SubType = b._S7PayloadAlarmSC
}

func (b *_S7PayloadAlarmSCBuilder) WithMandatoryFields(alarmMessage AlarmMessagePushType) S7PayloadAlarmSCBuilder {
	return b.WithAlarmMessage(alarmMessage)
}

func (b *_S7PayloadAlarmSCBuilder) WithAlarmMessage(alarmMessage AlarmMessagePushType) S7PayloadAlarmSCBuilder {
	b.AlarmMessage = alarmMessage
	return b
}

func (b *_S7PayloadAlarmSCBuilder) WithAlarmMessageBuilder(builderSupplier func(AlarmMessagePushTypeBuilder) AlarmMessagePushTypeBuilder) S7PayloadAlarmSCBuilder {
	builder := builderSupplier(b.AlarmMessage.CreateAlarmMessagePushTypeBuilder())
	var err error
	b.AlarmMessage, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "AlarmMessagePushTypeBuilder failed"))
	}
	return b
}

func (b *_S7PayloadAlarmSCBuilder) Build() (S7PayloadAlarmSC, error) {
	if b.AlarmMessage == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'alarmMessage' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._S7PayloadAlarmSC.deepCopy(), nil
}

func (b *_S7PayloadAlarmSCBuilder) MustBuild() S7PayloadAlarmSC {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_S7PayloadAlarmSCBuilder) Done() S7PayloadUserDataItemBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewS7PayloadUserDataItemBuilder().(*_S7PayloadUserDataItemBuilder)
	}
	return b.parentBuilder
}

func (b *_S7PayloadAlarmSCBuilder) buildForS7PayloadUserDataItem() (S7PayloadUserDataItem, error) {
	return b.Build()
}

func (b *_S7PayloadAlarmSCBuilder) DeepCopy() any {
	_copy := b.CreateS7PayloadAlarmSCBuilder().(*_S7PayloadAlarmSCBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateS7PayloadAlarmSCBuilder creates a S7PayloadAlarmSCBuilder
func (b *_S7PayloadAlarmSC) CreateS7PayloadAlarmSCBuilder() S7PayloadAlarmSCBuilder {
	if b == nil {
		return NewS7PayloadAlarmSCBuilder()
	}
	return &_S7PayloadAlarmSCBuilder{_S7PayloadAlarmSC: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_S7PayloadAlarmSC) GetCpuFunctionGroup() uint8 {
	return 0x04
}

func (m *_S7PayloadAlarmSC) GetCpuFunctionType() uint8 {
	return 0x00
}

func (m *_S7PayloadAlarmSC) GetCpuSubfunction() uint8 {
	return 0x13
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_S7PayloadAlarmSC) GetParent() S7PayloadUserDataItemContract {
	return m.S7PayloadUserDataItemContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_S7PayloadAlarmSC) GetAlarmMessage() AlarmMessagePushType {
	return m.AlarmMessage
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastS7PayloadAlarmSC(structType any) S7PayloadAlarmSC {
	if casted, ok := structType.(S7PayloadAlarmSC); ok {
		return casted
	}
	if casted, ok := structType.(*S7PayloadAlarmSC); ok {
		return *casted
	}
	return nil
}

func (m *_S7PayloadAlarmSC) GetTypeName() string {
	return "S7PayloadAlarmSC"
}

func (m *_S7PayloadAlarmSC) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.S7PayloadUserDataItemContract.(*_S7PayloadUserDataItem).getLengthInBits(ctx))

	// Simple field (alarmMessage)
	lengthInBits += m.AlarmMessage.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_S7PayloadAlarmSC) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_S7PayloadAlarmSC) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_S7PayloadUserDataItem, cpuFunctionGroup uint8, cpuFunctionType uint8, cpuSubfunction uint8) (__s7PayloadAlarmSC S7PayloadAlarmSC, err error) {
	m.S7PayloadUserDataItemContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("S7PayloadAlarmSC"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for S7PayloadAlarmSC")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	alarmMessage, err := ReadSimpleField[AlarmMessagePushType](ctx, "alarmMessage", ReadComplex[AlarmMessagePushType](AlarmMessagePushTypeParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'alarmMessage' field"))
	}
	m.AlarmMessage = alarmMessage

	if closeErr := readBuffer.CloseContext("S7PayloadAlarmSC"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for S7PayloadAlarmSC")
	}

	return m, nil
}

func (m *_S7PayloadAlarmSC) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_S7PayloadAlarmSC) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("S7PayloadAlarmSC"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for S7PayloadAlarmSC")
		}

		if err := WriteSimpleField[AlarmMessagePushType](ctx, "alarmMessage", m.GetAlarmMessage(), WriteComplex[AlarmMessagePushType](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'alarmMessage' field")
		}

		if popErr := writeBuffer.PopContext("S7PayloadAlarmSC"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for S7PayloadAlarmSC")
		}
		return nil
	}
	return m.S7PayloadUserDataItemContract.(*_S7PayloadUserDataItem).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_S7PayloadAlarmSC) IsS7PayloadAlarmSC() {}

func (m *_S7PayloadAlarmSC) DeepCopy() any {
	return m.deepCopy()
}

func (m *_S7PayloadAlarmSC) deepCopy() *_S7PayloadAlarmSC {
	if m == nil {
		return nil
	}
	_S7PayloadAlarmSCCopy := &_S7PayloadAlarmSC{
		m.S7PayloadUserDataItemContract.(*_S7PayloadUserDataItem).deepCopy(),
		utils.DeepCopy[AlarmMessagePushType](m.AlarmMessage),
	}
	_S7PayloadAlarmSCCopy.S7PayloadUserDataItemContract.(*_S7PayloadUserDataItem)._SubType = m
	return _S7PayloadAlarmSCCopy
}

func (m *_S7PayloadAlarmSC) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
