/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.logback;

import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import org.apache.qpid.server.logging.logback.AbstractBrokerLogger;
import org.apache.qpid.server.logging.logback.BrokerConsoleLogger;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;

public class BrokerConsoleLoggerImpl
extends AbstractBrokerLogger<BrokerConsoleLoggerImpl>
implements BrokerConsoleLogger<BrokerConsoleLoggerImpl> {
    @ManagedAttributeField
    private String _layout;
    @ManagedAttributeField
    private BrokerConsoleLogger.ConsoleStreamTarget _consoleStreamTarget;

    @ManagedObjectFactoryConstructor
    protected BrokerConsoleLoggerImpl(Map<String, Object> attributes, Broker<?> broker) {
        super(attributes, broker);
    }

    @Override
    public BrokerConsoleLogger.ConsoleStreamTarget getConsoleStreamTarget() {
        return this._consoleStreamTarget;
    }

    @Override
    public String getLayout() {
        return this._layout;
    }

    @Override
    protected Appender<ILoggingEvent> createAppenderInstance(Context context) {
        ConsoleAppender consoleAppender = new ConsoleAppender();
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setPattern(this.getLayout());
        encoder.setContext(context);
        encoder.start();
        if (this._consoleStreamTarget == BrokerConsoleLogger.ConsoleStreamTarget.STDERR) {
            consoleAppender.setTarget("System.err");
        }
        consoleAppender.setEncoder((Encoder)encoder);
        return consoleAppender;
    }

    public static Collection<String> getAllConsoleStreamTarget() {
        ArrayList<String> validValues = new ArrayList<String>();
        for (BrokerConsoleLogger.ConsoleStreamTarget level : EnumSet.allOf(BrokerConsoleLogger.ConsoleStreamTarget.class)) {
            validValues.add(level.name());
        }
        return validValues;
    }
}

