/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.protocol.header.controller.admin;

import org.apache.rocketmq.common.action.Action;
import org.apache.rocketmq.common.action.RocketMQAction;
import org.apache.rocketmq.common.resource.ResourceType;
import org.apache.rocketmq.common.resource.RocketMQResource;
import org.apache.rocketmq.remoting.CommandCustomHeader;
import org.apache.rocketmq.remoting.annotation.CFNotNull;
import org.apache.rocketmq.remoting.annotation.CFNullable;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;

@RocketMQAction(value=1011, resource=ResourceType.CLUSTER, action={Action.UPDATE})
public class CleanControllerBrokerDataRequestHeader
implements CommandCustomHeader {
    @CFNullable
    @RocketMQResource(value=ResourceType.CLUSTER)
    private String clusterName;
    @CFNotNull
    private String brokerName;
    @CFNullable
    private String brokerControllerIdsToClean;
    private boolean isCleanLivingBroker = false;
    private long invokeTime = System.currentTimeMillis();

    public CleanControllerBrokerDataRequestHeader() {
    }

    public CleanControllerBrokerDataRequestHeader(String clusterName, String brokerName, String brokerIdSetToClean, boolean isCleanLivingBroker) {
        this.clusterName = clusterName;
        this.brokerName = brokerName;
        this.brokerControllerIdsToClean = brokerIdSetToClean;
        this.isCleanLivingBroker = isCleanLivingBroker;
    }

    public CleanControllerBrokerDataRequestHeader(String clusterName, String brokerName, String brokerIdSetToClean) {
        this(clusterName, brokerName, brokerIdSetToClean, false);
    }

    @Override
    public void checkFields() throws RemotingCommandException {
    }

    public long getInvokeTime() {
        return this.invokeTime;
    }

    public void setInvokeTime(long invokeTime) {
        this.invokeTime = invokeTime;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
    }

    public String getBrokerControllerIdsToClean() {
        return this.brokerControllerIdsToClean;
    }

    public void setBrokerControllerIdsToClean(String brokerIdSetToClean) {
        this.brokerControllerIdsToClean = brokerIdSetToClean;
    }

    public boolean isCleanLivingBroker() {
        return this.isCleanLivingBroker;
    }

    public void setCleanLivingBroker(boolean cleanLivingBroker) {
        this.isCleanLivingBroker = cleanLivingBroker;
    }

    public String toString() {
        return "CleanControllerBrokerDataRequestHeader{clusterName='" + this.clusterName + '\'' + ", brokerName='" + this.brokerName + '\'' + ", brokerIdSetToClean='" + this.brokerControllerIdsToClean + '\'' + ", isCleanLivingBroker=" + this.isCleanLivingBroker + '}';
    }
}

