/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.storage.zip;

import com.alipay.sofa.jraft.rhea.storage.zip.ZipStrategy;
import com.alipay.sofa.jraft.rhea.util.Lists;
import com.alipay.sofa.jraft.rhea.util.StackTraceUtil;
import com.alipay.sofa.jraft.rhea.util.concurrent.CallerRunsPolicyWithReport;
import com.alipay.sofa.jraft.rhea.util.concurrent.NamedThreadFactory;
import com.alipay.sofa.jraft.util.ExecutorServiceHelper;
import com.alipay.sofa.jraft.util.Requires;
import com.alipay.sofa.jraft.util.ThreadPoolUtil;
import com.alipay.sofa.jraft.util.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.zip.CheckedInputStream;
import java.util.zip.CheckedOutputStream;
import java.util.zip.Checksum;
import org.apache.commons.compress.archivers.zip.ParallelScatterZipCreator;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.parallel.InputStreamSupplier;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.NullInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelZipStrategy
implements ZipStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(ParallelZipStrategy.class);
    private final int compressThreads;
    private final int deCompressThreads;

    public ParallelZipStrategy(int compressThreads, int deCompressThreads) {
        this.compressThreads = compressThreads;
        this.deCompressThreads = deCompressThreads;
    }

    @Override
    public void compress(String rootDir, String sourceDir, String outputZipFile, Checksum checksum) throws Throwable {
        File rootFile = new File(Paths.get(rootDir, sourceDir).toString());
        File zipFile = new File(outputZipFile);
        FileUtils.forceMkdir((File)zipFile.getParentFile());
        ExecutorService compressExecutor = ParallelZipStrategy.newFixedPool(this.compressThreads, "rheakv-raft-compress-executor");
        ZipArchiveScatterOutputStream scatterOutput = new ZipArchiveScatterOutputStream(compressExecutor);
        this.compressDirectoryToZipFile(rootFile, scatterOutput, sourceDir, 8);
        try (FileOutputStream fos = new FileOutputStream(zipFile);
             BufferedOutputStream bos = new BufferedOutputStream(fos);
             CheckedOutputStream cos = new CheckedOutputStream(bos, checksum);
             ZipArchiveOutputStream archiveOutputStream = new ZipArchiveOutputStream((OutputStream)cos);){
            scatterOutput.writeTo(archiveOutputStream);
            archiveOutputStream.flush();
            fos.getFD().sync();
        }
        Utils.fsync((File)zipFile);
        ExecutorServiceHelper.shutdownAndAwaitTermination((ExecutorService)compressExecutor);
    }

    @Override
    public void deCompress(String sourceZipFile, String outputDir, Checksum checksum) throws Throwable {
        ExecutorService deCompressExecutor = ParallelZipStrategy.newFixedPool(this.deCompressThreads, "rheakv-raft-decompress-executor");
        Future<Boolean> checksumFuture = deCompressExecutor.submit(() -> {
            this.computeZipFileChecksumValue(sourceZipFile, checksum);
            return true;
        });
        try (ZipFile zipFile = new ZipFile(sourceZipFile);){
            ArrayList<Future<Boolean>> futures = Lists.newArrayList();
            Enumeration e = zipFile.getEntries();
            while (e.hasMoreElements()) {
                ZipArchiveEntry zipArchiveEntry = (ZipArchiveEntry)e.nextElement();
                Future<Boolean> future = deCompressExecutor.submit(() -> {
                    this.unZipFile(zipFile, zipEntry, outputDir);
                    return true;
                });
                futures.add(future);
            }
            for (Future future : futures) {
                future.get();
            }
        }
        checksumFuture.get();
        ExecutorServiceHelper.shutdownAndAwaitTermination((ExecutorService)deCompressExecutor);
    }

    private void compressDirectoryToZipFile(File dir, ZipArchiveScatterOutputStream scatterOutput, String sourceDir, int method) {
        File[] files;
        if (dir == null) {
            return;
        }
        if (dir.isFile()) {
            this.addEntry(sourceDir, dir, scatterOutput, method);
            return;
        }
        for (File file : files = (File[])Requires.requireNonNull((Object)dir.listFiles(), (String)"files")) {
            String child = Paths.get(sourceDir, file.getName()).toString();
            if (file.isDirectory()) {
                this.compressDirectoryToZipFile(file, scatterOutput, child, method);
                continue;
            }
            this.addEntry(child, file, scatterOutput, method);
        }
    }

    private void addEntry(String filePath, File file, ZipArchiveScatterOutputStream scatterOutputStream, int method) {
        ZipArchiveEntry archiveEntry = new ZipArchiveEntry(filePath);
        archiveEntry.setMethod(method);
        scatterOutputStream.addEntry(archiveEntry, () -> {
            try {
                return file.isDirectory() ? new NullInputStream(0L) : new BufferedInputStream(new FileInputStream(file));
            }
            catch (FileNotFoundException e) {
                LOG.error("Can't find file, path={}, {}", (Object)file.getPath(), (Object)StackTraceUtil.stackTrace(e));
                return new NullInputStream(0L);
            }
        });
    }

    private void unZipFile(ZipFile zipFile, ZipArchiveEntry entry, String targetDir) throws Exception {
        File targetFile = new File(Paths.get(targetDir, entry.getName()).toString());
        FileUtils.forceMkdir((File)targetFile.getParentFile());
        try (InputStream is = zipFile.getInputStream(entry);
             BufferedInputStream fis = new BufferedInputStream(is);
             BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(targetFile));){
            IOUtils.copy((InputStream)fis, (OutputStream)bos);
        }
    }

    private void computeZipFileChecksumValue(String zipPath, Checksum checksum) throws Exception {
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(zipPath));
             CheckedInputStream cis = new CheckedInputStream(bis, checksum);
             ZipArchiveInputStream zis = new ZipArchiveInputStream((InputStream)cis);){
            while (zis.getNextZipEntry() != null) {
            }
        }
    }

    private static ExecutorService newFixedPool(int coreThreads, String poolName) {
        return ThreadPoolUtil.newBuilder().poolName(poolName).enableMetric(Boolean.valueOf(true)).coreThreads(Integer.valueOf(coreThreads)).maximumThreads(Integer.valueOf(coreThreads)).keepAliveSeconds(Long.valueOf(60L)).workQueue(new LinkedBlockingQueue()).threadFactory((ThreadFactory)new NamedThreadFactory(poolName, true)).rejectedHandler((RejectedExecutionHandler)new CallerRunsPolicyWithReport(poolName, poolName)).build();
    }

    private static class ZipArchiveScatterOutputStream {
        private final ParallelScatterZipCreator creator;

        public ZipArchiveScatterOutputStream(ExecutorService executorService) {
            this.creator = new ParallelScatterZipCreator(executorService);
        }

        public void addEntry(ZipArchiveEntry entry, InputStreamSupplier supplier) {
            this.creator.addArchiveEntry(entry, supplier);
        }

        public void writeTo(ZipArchiveOutputStream archiveOutput) throws Exception {
            this.creator.writeTo(archiveOutput);
        }
    }
}

