/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.mxml.IMXMLTagAttributeData;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.problems.CompilerProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.linter.LinterRule;
import org.apache.royale.linter.MXMLTagVisitor;
import org.apache.royale.linter.MXMLTokenQuery;
import org.apache.royale.linter.problems.ILinterProblem;

public class MXMLIDRule
extends LinterRule {
    public static final Pattern DEFAULT_NAME_PATTERN = Pattern.compile("^[a-z][a-zA-Z0-9]*$");
    public Pattern pattern;

    @Override
    public List<MXMLTagVisitor> getMXMLTagVisitors() {
        ArrayList<MXMLTagVisitor> result = new ArrayList<MXMLTagVisitor>();
        result.add((tag, tokenQuery, problems) -> this.checkTag(tag, tokenQuery, problems));
        return result;
    }

    private void checkTag(IMXMLTagData tag, MXMLTokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        Matcher matcher;
        IMXMLTagAttributeData idAttribute = tag.getTagAttributeData("id");
        if (idAttribute == null) {
            return;
        }
        Pattern thePattern = this.pattern;
        if (thePattern == null) {
            thePattern = DEFAULT_NAME_PATTERN;
        }
        if ((matcher = thePattern.matcher(idAttribute.getRawValue())).matches()) {
            return;
        }
        problems.add(new MXMLIDLinterProblem(idAttribute, thePattern));
    }

    public static class MXMLIDLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "MXML id '${idValue}' does not match the pattern '${pattern}'";
        public String pattern;
        public String idValue;

        public MXMLIDLinterProblem(IMXMLTagAttributeData attribute, Pattern pattern) {
            super((ISourceLocation)attribute);
            this.pattern = pattern.toString();
            this.idValue = attribute.getRawValue();
        }
    }
}

