/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.ShowByPathWarningsGuard;

public enum WarningLevel {
    QUIET,
    DEFAULT,
    VERBOSE;


    public void setOptionsForWarningLevel(CompilerOptions options) {
        switch (this) {
            case QUIET: {
                WarningLevel.silenceAllWarnings(options);
                break;
            }
            case DEFAULT: {
                WarningLevel.addDefaultWarnings(options);
                break;
            }
            case VERBOSE: {
                WarningLevel.addVerboseWarnings(options);
                break;
            }
            default: {
                throw new RuntimeException("Unknown warning level.");
            }
        }
    }

    private static void silenceAllWarnings(CompilerOptions options) {
        options.addWarningsGuard(new ShowByPathWarningsGuard("the_longest_path_that_cannot_be_expressed_as_a_string"));
        options.setWarningLevel(DiagnosticGroups.MISSING_PROVIDE, CheckLevel.OFF);
        options.setCheckMissingGetCssNameLevel(CheckLevel.OFF);
        options.setCheckTypes(false);
        options.setWarningLevel(DiagnosticGroups.CHECK_TYPES, CheckLevel.OFF);
        options.setWarningLevel(DiagnosticGroups.CHECK_USELESS_CODE, CheckLevel.OFF);
        options.setWarningLevel(DiagnosticGroups.MISSING_RETURN, CheckLevel.OFF);
        options.setWarningLevel(DiagnosticGroups.ACCESS_CONTROLS, CheckLevel.OFF);
        options.setWarningLevel(DiagnosticGroups.CONST, CheckLevel.OFF);
        options.setWarningLevel(DiagnosticGroups.CONSTANT_PROPERTY, CheckLevel.OFF);
        options.setCheckGlobalNamesLevel(CheckLevel.OFF);
        options.setCheckSuspiciousCode(false);
        options.setCheckGlobalThisLevel(CheckLevel.OFF);
        options.setWarningLevel(DiagnosticGroups.GLOBAL_THIS, CheckLevel.OFF);
        options.setWarningLevel(DiagnosticGroups.ES5_STRICT, CheckLevel.OFF);
        options.setWarningLevel(DiagnosticGroups.NON_STANDARD_JSDOC, CheckLevel.OFF);
    }

    private static void addDefaultWarnings(CompilerOptions options) {
        options.setCheckSuspiciousCode(true);
        options.setWarningLevel(DiagnosticGroups.NON_STANDARD_JSDOC, CheckLevel.OFF);
    }

    private static void addVerboseWarnings(CompilerOptions options) {
        WarningLevel.addDefaultWarnings(options);
        options.setCheckSuspiciousCode(true);
        options.setCheckGlobalThisLevel(CheckLevel.WARNING);
        options.setCheckSymbols(true);
        options.setCheckTypes(true);
        options.setCheckGlobalNamesLevel(CheckLevel.WARNING);
        options.setWarningLevel(DiagnosticGroups.MISSING_PROPERTIES, CheckLevel.WARNING);
        options.setWarningLevel(DiagnosticGroups.DEPRECATED, CheckLevel.WARNING);
        options.setWarningLevel(DiagnosticGroups.ES5_STRICT, CheckLevel.WARNING);
        options.setWarningLevel(DiagnosticGroups.VISIBILITY, CheckLevel.WARNING);
        options.setWarningLevel(DiagnosticGroups.CONST, CheckLevel.WARNING);
        options.setWarningLevel(DiagnosticGroups.CHECK_REGEXP, CheckLevel.WARNING);
        options.setWarningLevel(DiagnosticGroups.STRICT_MODULE_DEP_CHECK, CheckLevel.WARNING);
        options.setWarningLevel(DiagnosticGroups.MISSING_RETURN, CheckLevel.WARNING);
        options.setWarningLevel(DiagnosticGroups.NON_STANDARD_JSDOC, CheckLevel.WARNING);
        options.enforceAccessControlCodingConventions = true;
    }
}

