/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.problems.CompilerProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IInterfaceNode;
import org.apache.royale.linter.LinterRule;
import org.apache.royale.linter.NodeVisitor;
import org.apache.royale.linter.TokenQuery;
import org.apache.royale.linter.problems.ILinterProblem;

public class InterfaceNameRule
extends LinterRule {
    public static final Pattern DEFAULT_NAME_PATTERN = Pattern.compile("^I[A-Z][a-zA-Z0-9]*$");
    public Pattern pattern;

    @Override
    public Map<ASTNodeID, NodeVisitor> getNodeVisitors() {
        HashMap<ASTNodeID, NodeVisitor> result = new HashMap<ASTNodeID, NodeVisitor>();
        result.put(ASTNodeID.InterfaceID, (node, tokenQuery, problems) -> this.checkInterfaceNode((IInterfaceNode)node, tokenQuery, problems));
        return result;
    }

    private void checkInterfaceNode(IInterfaceNode interfaceNode, TokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        Matcher matcher;
        String interfaceName = interfaceNode.getName();
        Pattern thePattern = this.pattern;
        if (thePattern == null) {
            thePattern = DEFAULT_NAME_PATTERN;
        }
        if ((matcher = thePattern.matcher(interfaceName)).matches()) {
            return;
        }
        problems.add(new InterfaceNameLinterProblem(interfaceNode, thePattern));
    }

    public static class InterfaceNameLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Interface name does not match the pattern '${pattern}'";
        public String pattern;

        public InterfaceNameLinterProblem(IInterfaceNode node, Pattern pattern) {
            super((ISourceLocation)node.getNameExpressionNode());
            this.pattern = pattern.toString();
        }
    }
}

