/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.playwright.JSHandle;
import com.microsoft.playwright.Worker;
import com.microsoft.playwright.impl.ChannelOwner;
import com.microsoft.playwright.impl.ListenerCollection;
import com.microsoft.playwright.impl.PageImpl;
import com.microsoft.playwright.impl.Serialization;
import com.microsoft.playwright.impl.SerializedValue;
import com.microsoft.playwright.impl.WaitableEvent;
import com.microsoft.playwright.impl.WaitableRace;
import java.util.ArrayList;
import java.util.function.Consumer;

class WorkerImpl
extends ChannelOwner
implements Worker {
    private final ListenerCollection<EventType> listeners = new ListenerCollection();
    PageImpl page;

    WorkerImpl(ChannelOwner parent, String type, String guid, JsonObject initializer) {
        super(parent, type, guid, initializer);
    }

    @Override
    public void onClose(Consumer<Worker> handler) {
        this.listeners.add(EventType.CLOSE, handler);
    }

    @Override
    public void offClose(Consumer<Worker> handler) {
        this.listeners.remove(EventType.CLOSE, handler);
    }

    private <T> T waitForEventWithTimeout(EventType eventType, Runnable code, Double timeout) {
        ArrayList waitables = new ArrayList();
        waitables.add(new WaitableEvent(this.listeners, eventType));
        waitables.add(this.page.createWaitForCloseHelper());
        waitables.add(this.page.createWaitableTimeout(timeout));
        return this.runUntil(code, new WaitableRace(waitables));
    }

    @Override
    public Worker waitForClose(Worker.WaitForCloseOptions options, Runnable code) {
        return this.withWaitLogging("Worker.waitForClose", () -> this.waitForCloseImpl(options, code));
    }

    private Worker waitForCloseImpl(Worker.WaitForCloseOptions options, Runnable code) {
        if (options == null) {
            options = new Worker.WaitForCloseOptions();
        }
        return (Worker)this.waitForEventWithTimeout(EventType.CLOSE, code, options.timeout);
    }

    @Override
    public Object evaluate(String pageFunction, Object arg) {
        return this.withLogging("Worker.evaluate", () -> {
            JsonObject params = new JsonObject();
            params.addProperty("expression", pageFunction);
            params.add("arg", Serialization.gson().toJsonTree((Object)Serialization.serializeArgument(arg)));
            JsonElement json = this.sendMessage("evaluateExpression", params);
            SerializedValue value = (SerializedValue)Serialization.gson().fromJson(json.getAsJsonObject().get("value"), SerializedValue.class);
            return Serialization.deserialize(value);
        });
    }

    @Override
    public JSHandle evaluateHandle(String pageFunction, Object arg) {
        return this.withLogging("Worker.evaluateHandle", () -> {
            JsonObject params = new JsonObject();
            params.addProperty("expression", pageFunction);
            params.add("arg", Serialization.gson().toJsonTree((Object)Serialization.serializeArgument(arg)));
            JsonElement json = this.sendMessage("evaluateExpressionHandle", params);
            return (JSHandle)this.connection.getExistingObject(json.getAsJsonObject().getAsJsonObject("handle").get("guid").getAsString());
        });
    }

    @Override
    public String url() {
        return this.initializer.get("url").getAsString();
    }

    @Override
    protected void handleEvent(String event, JsonObject params) {
        if ("close".equals(event)) {
            if (this.page != null) {
                this.page.workers.remove(this);
            }
            this.listeners.notify(EventType.CLOSE, this);
        }
    }

    static enum EventType {
        CLOSE;

    }
}

