/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.provider.springmvc.reference;

import java.net.URI;
import java.util.Map;
import org.springframework.web.util.DefaultUriBuilderFactory;

public class CseUriTemplateHandler
extends DefaultUriBuilderFactory {
    public static final String APP_SERVICE_SEPARATOR_INTERNAL = "~";

    public URI expand(String uriTemplate, Map<String, ?> uriVars) {
        return super.expand(CseUriTemplateHandler.parseUrl(uriTemplate), uriVars);
    }

    public URI expand(String uriTemplate, Object ... uriVars) {
        return super.expand(CseUriTemplateHandler.parseUrl(uriTemplate), uriVars);
    }

    private static String parseUrl(String uriTemplate) {
        int indexSchema = -1;
        if (uriTemplate.startsWith("cse://")) {
            indexSchema = "cse://".length();
        }
        if (uriTemplate.startsWith("servicecomb://")) {
            indexSchema = "servicecomb://".length();
        }
        if (indexSchema != -1) {
            int indexPath = uriTemplate.indexOf("/", indexSchema);
            String host = uriTemplate.substring(indexSchema, indexPath);
            host = host.replace(":", APP_SERVICE_SEPARATOR_INTERNAL);
            return uriTemplate.substring(0, indexSchema) + host + uriTemplate.substring(indexPath);
        }
        return uriTemplate;
    }
}

