/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.authentication;

import org.apache.servicecomb.core.BootListener;
import org.apache.servicecomb.foundation.common.utils.KeyPairEntry;
import org.apache.servicecomb.foundation.common.utils.KeyPairUtils;
import org.apache.servicecomb.foundation.token.Keypair4Auth;
import org.apache.servicecomb.registry.RegistrationManager;
import org.springframework.beans.factory.annotation.Autowired;

public class AuthenticationBootListener
implements BootListener {
    private RegistrationManager registrationManager;

    @Autowired
    public void setRegistrationManager(RegistrationManager registrationManager) {
        this.registrationManager = registrationManager;
    }

    public void onBootEvent(BootListener.BootEvent event) {
        if (!BootListener.EventType.BEFORE_REGISTRY.equals((Object)event.getEventType())) {
            return;
        }
        KeyPairEntry rsaKeyPairEntry = KeyPairUtils.generateALGKeyPair();
        Keypair4Auth.INSTANCE.setPrivateKey(rsaKeyPairEntry.getPrivateKey());
        Keypair4Auth.INSTANCE.setPublicKey(rsaKeyPairEntry.getPublicKey());
        Keypair4Auth.INSTANCE.setPublicKeyEncoded(rsaKeyPairEntry.getPublicKeyEncoded());
        this.registrationManager.addProperty("publickey", rsaKeyPairEntry.getPublicKeyEncoded());
    }
}

