/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.temporal;

import java.io.Serializable;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoPeriod;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.List;
import java.util.Optional;
import org.apache.sis.pending.geoapi.temporal.IndeterminateValue;
import org.apache.sis.pending.geoapi.temporal.Instant;
import org.apache.sis.pending.jdk.JDK18;
import org.apache.sis.util.internal.shared.UnmodifiableArrayList;
import org.apache.sis.util.resources.Errors;

public final class GeneralDuration
implements TemporalAmount,
Serializable {
    private static final long serialVersionUID = -521478824158640275L;
    public final Period period;
    public final Duration time;

    private GeneralDuration(Period period, Duration time) {
        this.period = period;
        this.time = time;
    }

    public static TemporalAmount of(Period period, Duration time) {
        if (period.isZero()) {
            return time;
        }
        if (time.isZero()) {
            return period;
        }
        return new GeneralDuration(period, time);
    }

    public static TemporalAmount parse(CharSequence text) {
        char previousLetter = '\u0000';
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            if (c >= 'a' && c <= 'z') {
                c = (char)(c - 32);
            }
            if (c < 'A' || c > 'Z') continue;
            if (c == 'T') {
                if (previousLetter == 'P') {
                    return Duration.parse(text);
                }
                return GeneralDuration.of(Period.parse(text.subSequence(0, i)), Duration.parse(new StringBuilder(length - i + 1).append('P').append(text, i, length)));
            }
            previousLetter = c;
        }
        return Period.parse(text);
    }

    private static Temporal getDeterminatePosition(Instant t) {
        if (t != null) {
            Optional<IndeterminateValue> p = t.getIndeterminatePosition();
            if (p.isEmpty()) {
                return t.getPosition();
            }
            if (p.get() == IndeterminateValue.NOW) {
                return null;
            }
        }
        throw new DateTimeException(Errors.format((short)38));
    }

    static TemporalAmount distance(Instant self, Instant other, boolean negate, boolean absolute) {
        Temporal t1 = GeneralDuration.getDeterminatePosition(self);
        Temporal t2 = GeneralDuration.getDeterminatePosition(other);
        boolean hasDate = GeneralDuration.isSupportedByBoth(ChronoField.EPOCH_DAY, t1, t2);
        if (t1 != null && t1.isSupported(ChronoField.OFFSET_SECONDS)) {
            if (t2 == null) {
                t2 = ZonedDateTime.now();
            }
            Duration p = Duration.between(t1, t2);
            return absolute || p.isNegative() == negate ? p.abs() : null;
        }
        if (t2 != null && (!hasDate || t2.isSupported(ChronoField.OFFSET_SECONDS))) {
            if (t1 == null) {
                t1 = ZonedDateTime.now();
            }
            Duration p = Duration.between(t2, t1);
            return absolute || p.isNegative() != negate ? p.abs() : null;
        }
        boolean hasTime = GeneralDuration.isSupportedByBoth(ChronoField.SECOND_OF_DAY, t1, t2);
        if (t1 == null) {
            t1 = LocalDateTime.now();
        }
        if (t2 == null) {
            t2 = LocalDateTime.now();
        }
        ChronoLocalDate d1 = null;
        ChronoLocalDate d2 = null;
        if (hasDate) {
            d1 = ChronoLocalDate.from(t1);
            d2 = ChronoLocalDate.from(t2);
            if (!absolute && (negate ? d1.isBefore(d2) : d1.isAfter(d2))) {
                return null;
            }
        }
        Duration time = Duration.ZERO;
        if (hasTime) {
            boolean isPositive;
            time = Duration.between(LocalTime.from(t1), LocalTime.from(t2));
            if (hasDate && ((isPositive = d1.isBefore(d2)) || d1.isAfter(d2)) && (isPositive ? time.isNegative() : JDK18.isPositive((Duration)time))) {
                long n = time.toDays();
                if (isPositive) {
                    d2 = d2.plus(--n, ChronoUnit.DAYS);
                } else {
                    d1 = d1.minus(++n, ChronoUnit.DAYS);
                }
                time = time.minusDays(n);
            }
        }
        if (hasDate) {
            ChronoPeriod period = d1.until(d2);
            if (period.isZero()) {
                if (time.isZero()) {
                    return period;
                }
            } else {
                if (period.isNegative()) {
                    if (!(negate | absolute)) {
                        return null;
                    }
                    period = period.negated();
                } else if (negate & !absolute) {
                    return null;
                }
                return time.isZero() ? period : new GeneralDuration(Period.from(period), time.abs());
            }
        }
        return absolute || time.isNegative() == negate ? time.abs() : null;
    }

    private static boolean isSupportedByBoth(ChronoField field, Temporal t1, Temporal t2) {
        boolean isSupported = (t1 != null ? t1 : t2).isSupported(field);
        if (t1 != null && t2 != null && isSupported != t2.isSupported(field)) {
            throw new DateTimeException(Errors.format((short)11, (isSupported ? t2 : t1).getClass(), (isSupported ? t1 : t2).getClass()));
        }
        return isSupported;
    }

    @Override
    public List<TemporalUnit> getUnits() {
        List<TemporalUnit> prefix = this.period.getUnits();
        List<TemporalUnit> suffix = this.time.getUnits();
        int i = prefix.size();
        Object[] units = prefix.toArray(new TemporalUnit[i + suffix.size()]);
        for (TemporalUnit unit : suffix) {
            units[i++] = unit;
        }
        return UnmodifiableArrayList.wrap((Object[])units);
    }

    @Override
    public long get(TemporalUnit unit) {
        return ((TemporalAmount)(unit.isDateBased() ? this.period : this.time)).get(unit);
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        return temporal.plus(this.period).plus(this.time);
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        return temporal.minus(this.period).minus(this.time);
    }

    public boolean equals(Object object) {
        if (object instanceof GeneralDuration) {
            GeneralDuration other = (GeneralDuration)object;
            return this.period.equals(other.period) && this.time.equals(other.time);
        }
        return false;
    }

    public int hashCode() {
        return this.period.hashCode() * 31 + this.time.hashCode();
    }

    public String toString() {
        return this.period.toString() + this.time.toString().substring(1);
    }
}

