/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.artifacts.impl;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.ide.artifacts.EmbeddedBundle;
import org.apache.sling.ide.artifacts.EmbeddedBundleLocator;
import org.osgi.service.component.annotations.Component;

@Component(service={EmbeddedBundleLocator.class})
public class EmbeddedBundleLocatorImpl
implements EmbeddedBundleLocator {
    private final Map<String, EmbeddedBundle> bundles = new HashMap<String, EmbeddedBundle>();

    public EmbeddedBundleLocatorImpl() throws IOException {
        this.bundles.put("org.apache.sling.tooling.support.install", this.getArtifactFromResource("org.apache.sling.tooling.support.install"));
        this.bundles.put("org.apache.sling.tooling.support.source", this.getArtifactFromResource("org.apache.sling.tooling.support.source"));
    }

    private EmbeddedBundle getArtifactFromResource(String artifactId) throws IOException {
        URL jarUrl = this.loadResource(artifactId + ".jar");
        return new EmbeddedBundle(jarUrl);
    }

    private URL loadResource(String resourceLocation) {
        URL resourceUrl = this.getClass().getClassLoader().getResource(resourceLocation);
        if (resourceUrl == null) {
            throw new RuntimeException("Unable to locate bundle resource " + resourceLocation);
        }
        return resourceUrl;
    }

    @Override
    public EmbeddedBundle getBundle(String bundleSymbolicName) throws IOException {
        EmbeddedBundle bundle = this.bundles.get(bundleSymbolicName);
        if (bundle == null) {
            throw new IllegalArgumentException("The bundle with bsn " + bundleSymbolicName + " is not provided by this locator");
        }
        return bundle;
    }
}

