/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.repoinit.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.api.SlingRepositoryInitializer;
import org.apache.sling.jcr.repoinit.JcrRepoInitOpsProcessor;
import org.apache.sling.jcr.repoinit.impl.RepoInitException;
import org.apache.sling.jcr.repoinit.impl.RepoinitTextProvider;
import org.apache.sling.repoinit.parser.RepoInitParser;
import org.apache.sling.repoinit.parser.RepoInitParsingException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Designate(ocd=Config.class)
@Component(service={SlingRepositoryInitializer.class}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.vendor=The Apache Software Foundation", "service.ranking:Integer=100"})
public class RepositoryInitializer
implements SlingRepositoryInitializer {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    private RepoInitParser parser;
    @Reference
    private JcrRepoInitOpsProcessor processor;
    private Config config;

    @Activate
    public void activate(Config config) {
        this.config = config;
        this.log.debug("Activated: {}", (Object)this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ", references=" + Arrays.toString(this.config.references());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRepository(SlingRepository repo) throws RepositoryException {
        if (this.config.references() != null && this.config.references().length > 0) {
            Session s = repo.loginAdministrative(null);
            try {
                Instant start = Instant.now();
                RepoinitTextProvider p = new RepoinitTextProvider();
                for (String reference : this.config.references()) {
                    try {
                        List ops;
                        String repoinitText = p.getRepoinitText(reference);
                        try (StringReader sr = new StringReader(repoinitText);){
                            ops = this.parser.parse((Reader)sr);
                        }
                        this.log.info("Executing {} repoinit operations from {}", (Object)ops.size(), (Object)reference);
                        this.processor.apply(s, ops);
                        if (!s.hasPendingChanges()) continue;
                        s.save();
                    }
                    catch (IOException | RuntimeException | RepositoryException | RepoInitParsingException e) {
                        throw new RepoInitException("Error executing repoinit from " + reference, (Exception)e);
                    }
                }
                Duration duration = Duration.between(start, Instant.now());
                this.log.info("Total time for successful repoinit execution: {} miliseconds", (Object)duration.toMillis());
            }
            finally {
                s.logout();
            }
        }
    }

    @ObjectClassDefinition(name="Apache Sling Repository Initializer", description="Initializes the JCR content repository using repoinit statements")
    public static @interface Config {
        @AttributeDefinition(name="Repoinit references", description="References to the source text that provides repoinit statements. format is either model@repoinit:<provisioning model URL> or raw:<raw URL>")
        public String[] references() default {};
    }
}

