/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import java.security.Principal;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.principal.ItemBasedPrincipal;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.QueryEngine;
import org.apache.jackrabbit.oak.api.Result;
import org.apache.jackrabbit.oak.api.ResultRow;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.collections.IteratorUtils;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.security.principal.EveryoneFilter;
import org.apache.jackrabbit.oak.security.user.AbstractGroupPrincipal;
import org.apache.jackrabbit.oak.security.user.AdminPrincipalImpl;
import org.apache.jackrabbit.oak.security.user.CacheConfiguration;
import org.apache.jackrabbit.oak.security.user.CachedPrincipalMembershipReader;
import org.apache.jackrabbit.oak.security.user.MembershipProvider;
import org.apache.jackrabbit.oak.security.user.SystemUserPrincipalImpl;
import org.apache.jackrabbit.oak.security.user.TreeBasedPrincipal;
import org.apache.jackrabbit.oak.security.user.UserProvider;
import org.apache.jackrabbit.oak.security.user.query.QueryUtil;
import org.apache.jackrabbit.oak.spi.security.principal.EveryonePrincipal;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalImpl;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalProvider;
import org.apache.jackrabbit.oak.spi.security.principal.SystemPrincipal;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.apache.jackrabbit.oak.spi.security.user.cache.CacheLoader;
import org.apache.jackrabbit.oak.spi.security.user.cache.CachePrincipalFactory;
import org.apache.jackrabbit.oak.spi.security.user.util.UserUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UserPrincipalProvider
implements PrincipalProvider {
    static final String REP_GROUP_PRINCIPAL_NAMES = "rep:groupPrincipalNames";
    private static final Logger log = LoggerFactory.getLogger(UserPrincipalProvider.class);
    private final Root root;
    private final UserConfiguration config;
    private final NamePathMapper namePathMapper;
    private final UserProvider userProvider;
    private final CacheLoader principalMembershipReader;

    UserPrincipalProvider(@NotNull Root root, @NotNull UserConfiguration userConfiguration, @NotNull NamePathMapper namePathMapper) {
        boolean cacheEnabled;
        this.root = root;
        this.config = userConfiguration;
        this.namePathMapper = namePathMapper;
        this.userProvider = new UserProvider(root, this.config.getParameters());
        MembershipProvider membershipProvider = new MembershipProvider(root, this.config.getParameters());
        CacheConfiguration cacheConfiguration = CacheConfiguration.fromUserConfiguration(this.config, REP_GROUP_PRINCIPAL_NAMES);
        boolean bl = cacheEnabled = cacheConfiguration.isCacheEnabled() && root.getContentSession().getAuthInfo().getPrincipals().contains(SystemPrincipal.INSTANCE);
        if (cacheEnabled) {
            CachedPrincipalMembershipReader cachedPrincipalMembershipReader = new CachedPrincipalMembershipReader(cacheConfiguration, root, this.createPrincipalFactory());
            this.principalMembershipReader = tree -> cachedPrincipalMembershipReader.readMembership(tree, this.readMembershipFromProvider(membershipProvider));
        } else {
            this.principalMembershipReader = this.readMembershipFromProvider(membershipProvider);
        }
    }

    @Override
    public Principal getPrincipal(@NotNull String principalName) {
        Tree authorizableTree = this.userProvider.getAuthorizableByPrincipal(new PrincipalImpl(principalName));
        Principal principal = this.createPrincipal(authorizableTree);
        if (principal == null) {
            return "everyone".equals(principalName) ? EveryonePrincipal.getInstance() : null;
        }
        return principal;
    }

    @Override
    @Nullable
    public ItemBasedPrincipal getItemBasedPrincipal(@NotNull String principalOakPath) {
        Tree authorizableTree = this.userProvider.getAuthorizableByPath(principalOakPath);
        Principal principal = this.createPrincipal(authorizableTree);
        if (principal instanceof ItemBasedPrincipal) {
            return (ItemBasedPrincipal)principal;
        }
        return null;
    }

    @Override
    @NotNull
    public Set<Principal> getMembershipPrincipals(@NotNull Principal principal) {
        Tree tree = this.getAuthorizableTree(principal);
        if (tree == null) {
            return Collections.emptySet();
        }
        return this.getGroupMembership(tree);
    }

    @Override
    @NotNull
    public Set<? extends Principal> getPrincipals(@NotNull String userID) {
        Principal userPrincipal;
        HashSet<Principal> principals = new HashSet<Principal>();
        Tree tree = this.userProvider.getAuthorizable(userID);
        if (UserUtil.isType(tree, AuthorizableType.USER) && (userPrincipal = this.createUserPrincipal(userID, tree)) != null) {
            principals.add(userPrincipal);
            principals.addAll(this.getGroupMembership(tree));
        }
        return principals;
    }

    @Override
    @NotNull
    public Iterator<? extends Principal> findPrincipals(@Nullable String nameHint, int searchType) {
        return this.findPrincipals(nameHint, false, searchType, 0L, -1L);
    }

    @Override
    @NotNull
    public Iterator<? extends Principal> findPrincipals(@Nullable String nameHint, boolean fullText, int searchType, long offset, long limit) {
        if (offset < 0L) {
            offset = 0L;
        }
        if (limit < 0L) {
            limit = Long.MAX_VALUE;
        }
        try {
            String lookupClause = "";
            if (nameHint != null && !nameHint.isEmpty()) {
                lookupClause = fullText ? String.format("[jcr:contains(.,'%s')]", UserPrincipalProvider.buildSearchPatternFT(nameHint)) : String.format("[jcr:like(@rep:principalName,'%s')]", UserPrincipalProvider.buildSearchPatternContains(nameHint));
            }
            AuthorizableType type = AuthorizableType.getType(searchType);
            StringBuilder statement = new StringBuilder().append(QueryUtil.getSearchRoot(type, this.config.getParameters())).append("//element(*,").append(QueryUtil.getNodeTypeName(type)).append(')').append(lookupClause).append(" order by @rep:principalName");
            Result result = this.root.getQueryEngine().executeQuery(statement.toString(), "xpath", limit, offset, QueryEngine.NO_BINDINGS, this.namePathMapper.getSessionLocalMappings());
            Iterator<Principal> principals = IteratorUtils.filter(IteratorUtils.transform(result.getRows().iterator(), new ResultRowToPrincipal()::apply), Objects::nonNull);
            return EveryoneFilter.filter(principals, nameHint, searchType, offset, limit);
        }
        catch (ParseException e) {
            log.debug(e.getMessage());
            return Collections.emptyIterator();
        }
    }

    @Override
    @NotNull
    public Iterator<? extends Principal> findPrincipals(int searchType) {
        return this.findPrincipals(null, searchType);
    }

    @NotNull
    private CachePrincipalFactory createPrincipalFactory() {
        return principalName -> new CachedGroupPrincipal(principalName, this.namePathMapper, this.root, this.config);
    }

    @Nullable
    private Tree getAuthorizableTree(@NotNull Principal principal) {
        return this.userProvider.getAuthorizableByPrincipal(principal);
    }

    @Nullable
    private Principal createPrincipal(@Nullable Tree authorizableTree) {
        if (authorizableTree != null) {
            AuthorizableType type = UserUtil.getType(authorizableTree);
            if (AuthorizableType.GROUP == type) {
                return this.createGroupPrincipal(authorizableTree);
            }
            if (AuthorizableType.USER == type) {
                return this.createUserPrincipal(UserUtil.getAuthorizableId(authorizableTree, AuthorizableType.USER), authorizableTree);
            }
        }
        return null;
    }

    @Nullable
    private Principal createUserPrincipal(@NotNull String id, @NotNull Tree userTree) {
        String principalName = UserPrincipalProvider.getPrincipalName(userTree);
        if (principalName == null) {
            return null;
        }
        if (UserUtil.isSystemUser(userTree)) {
            return new SystemUserPrincipalImpl(principalName, userTree, this.namePathMapper);
        }
        if (UserUtil.isAdmin(this.config.getParameters(), id)) {
            return new AdminPrincipalImpl(principalName, userTree, this.namePathMapper);
        }
        return new TreeBasedPrincipal(principalName, userTree, this.namePathMapper);
    }

    @Nullable
    private Principal createGroupPrincipal(@NotNull Tree groupTree) {
        String principalName = UserPrincipalProvider.getPrincipalName(groupTree);
        if (principalName == null) {
            return null;
        }
        return new GroupPrincipalImpl(principalName, groupTree.getPath(), this.namePathMapper, this.root, this.config);
    }

    @Nullable
    private static String getPrincipalName(@NotNull Tree tree) {
        PropertyState principalName = tree.getProperty("rep:principalName");
        if (principalName != null) {
            return principalName.getValue(Type.STRING);
        }
        String msg = "Authorizable without principal name " + UserUtil.getAuthorizableId(tree);
        log.warn(msg);
        return null;
    }

    @NotNull
    private Set<Principal> getGroupMembership(@NotNull Tree authorizableTree) {
        HashSet<Principal> groupPrincipals = new HashSet<Principal>();
        groupPrincipals.addAll(this.principalMembershipReader.load(authorizableTree));
        groupPrincipals.add(EveryonePrincipal.getInstance());
        return groupPrincipals;
    }

    private static String buildSearchPatternContains(@NotNull String nameHint) {
        StringBuilder sb = new StringBuilder();
        sb.append('%');
        sb.append(nameHint.replace("%", "\\%").replace("_", "\\_"));
        sb.append('%');
        return sb.toString();
    }

    private static String buildSearchPatternFT(@NotNull String nameHint) {
        if (nameHint.contains("*")) {
            return QueryUtil.escapeForQuery(nameHint);
        }
        return QueryUtil.escapeForQuery(nameHint) + "*";
    }

    private CacheLoader readMembershipFromProvider(MembershipProvider membershipProvider) {
        return authorizableTree -> {
            HashSet<Principal> groupPrincipals = new HashSet<Principal>();
            Iterator<Tree> groupTrees = membershipProvider.getMembership(authorizableTree, true);
            while (groupTrees.hasNext()) {
                Principal gr;
                Tree groupTree = groupTrees.next();
                if (!UserUtil.isType(groupTree, AuthorizableType.GROUP) || (gr = this.createGroupPrincipal(groupTree)) == null) continue;
                groupPrincipals.add(gr);
            }
            return groupPrincipals;
        };
    }

    private static final class CachedGroupPrincipal
    extends BaseGroupPrincipal {
        private Group group;

        CachedGroupPrincipal(@NotNull String principalName, @NotNull NamePathMapper namePathMapper, @NotNull Root root, @NotNull UserConfiguration config) {
            super(principalName, "", namePathMapper, root, config);
        }

        @Override
        @NotNull
        String getOakPath() throws RepositoryException {
            String oakPath = this.getNamePathMapper().getOakPath(this.getPath());
            if (oakPath == null) {
                throw new RepositoryException("Failed to retrieve path of group principal " + this.getName());
            }
            return oakPath;
        }

        @Override
        @NotNull
        public String getPath() throws RepositoryException {
            Group gr = this.getGroup();
            if (gr == null) {
                throw new RepositoryException("Failed to retrieve path of group principal " + this.getName());
            }
            return gr.getPath();
        }

        @Override
        @Nullable
        Group getGroup() throws RepositoryException {
            Authorizable authorizable;
            if (this.group == null && (authorizable = this.getUserManager().getAuthorizable(new PrincipalImpl(this.getName()))) != null && authorizable.isGroup()) {
                this.group = (Group)authorizable;
            }
            return this.group;
        }
    }

    private static final class GroupPrincipalImpl
    extends BaseGroupPrincipal {
        private Group group;

        GroupPrincipalImpl(@NotNull String principalName, @NotNull String groupPath, @NotNull NamePathMapper namePathMapper, @NotNull Root root, @NotNull UserConfiguration config) {
            super(principalName, groupPath, namePathMapper, root, config);
        }

        @Override
        @Nullable
        Group getGroup() throws RepositoryException {
            Authorizable authorizable;
            if (this.group == null && (authorizable = this.getUserManager().getAuthorizable(this)) != null && authorizable.isGroup()) {
                this.group = (Group)authorizable;
            }
            return this.group;
        }
    }

    private static abstract class BaseGroupPrincipal
    extends AbstractGroupPrincipal {
        private final Root root;
        private final UserConfiguration config;
        private UserManager userManager;

        BaseGroupPrincipal(@NotNull String principalName, @NotNull String groupPath, @NotNull NamePathMapper namePathMapper, @NotNull Root root, @NotNull UserConfiguration config) {
            super(principalName, groupPath, namePathMapper);
            this.root = root;
            this.config = config;
        }

        @Override
        @NotNull
        UserManager getUserManager() {
            if (this.userManager == null) {
                this.userManager = this.config.getUserManager(this.root, this.getNamePathMapper());
            }
            return this.userManager;
        }

        @Override
        boolean isEveryone() {
            return "everyone".equals(this.getName());
        }

        @Override
        boolean isMember(@NotNull Authorizable authorizable) throws RepositoryException {
            Group g = this.getGroup();
            return g != null && g.isMember(authorizable);
        }

        @Override
        @NotNull
        Iterator<Authorizable> getMembers() throws RepositoryException {
            Group g = this.getGroup();
            return g == null ? Collections.emptyIterator() : g.getMembers();
        }

        @Nullable
        abstract Group getGroup() throws RepositoryException;
    }

    private final class ResultRowToPrincipal
    implements Function<ResultRow, Principal> {
        private ResultRowToPrincipal() {
        }

        @Override
        public Principal apply(ResultRow resultRow) {
            return UserPrincipalProvider.this.createPrincipal(resultRow.getTree(null));
        }
    }
}

