/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication;

import java.io.IOException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.jcr.Credentials;
import javax.jcr.NoSuchWorkspaceException;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.api.AuthInfo;
import org.apache.jackrabbit.oak.api.ContentRepository;
import org.apache.jackrabbit.oak.api.ContentSession;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.commons.jdkcompat.Java23Subject;
import org.apache.jackrabbit.oak.commons.time.Stopwatch;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.LoginModuleMonitor;
import org.apache.jackrabbit.oak.spi.security.authentication.PreAuthenticatedLogin;
import org.apache.jackrabbit.oak.spi.security.authentication.SystemSubject;
import org.apache.jackrabbit.oak.spi.security.authentication.callback.CredentialsCallback;
import org.apache.jackrabbit.oak.spi.security.authentication.callback.PrincipalProviderCallback;
import org.apache.jackrabbit.oak.spi.security.authentication.callback.RepositoryCallback;
import org.apache.jackrabbit.oak.spi.security.authentication.callback.UserManagerCallback;
import org.apache.jackrabbit.oak.spi.security.authentication.callback.WhiteboardCallback;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalConfiguration;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalProvider;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProviderType
public abstract class AbstractLoginModule
implements LoginModule {
    private static final Logger log = LoggerFactory.getLogger(AbstractLoginModule.class);
    public static final String SHARED_KEY_CREDENTIALS = "org.apache.jackrabbit.credentials";
    public static final String SHARED_KEY_LOGIN_NAME = "javax.security.auth.login.name";
    public static final String SHARED_KEY_ATTRIBUTES = "javax.security.auth.login.attributes";
    public static final String SHARED_KEY_PRE_AUTH_LOGIN = PreAuthenticatedLogin.class.getName();
    protected Subject subject;
    protected CallbackHandler callbackHandler;
    protected Map sharedState;
    protected ConfigurationParameters options;
    private SecurityProvider securityProvider;
    private LoginModuleMonitor loginModuleMonitor;
    private Whiteboard whiteboard;
    private ContentSession systemSession;
    private Root root;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options == null ? ConfigurationParameters.EMPTY : ConfigurationParameters.of(options);
    }

    @Override
    public boolean logout() throws LoginException {
        boolean success = false;
        LinkedHashSet<Credentials> builder = new LinkedHashSet<Credentials>(this.subject.getPublicCredentials(Credentials.class));
        builder.addAll(this.subject.getPublicCredentials(AuthInfo.class));
        Set<Credentials> creds = Collections.unmodifiableSet(builder);
        if (!this.subject.getPrincipals().isEmpty() && !creds.isEmpty()) {
            if (!this.subject.isReadOnly()) {
                this.subject.getPrincipals().clear();
                this.subject.getPublicCredentials().removeAll(creds);
            } else {
                AbstractLoginModule.destroyCredentials(creds);
            }
            success = true;
        }
        return success;
    }

    @Override
    public boolean abort() throws LoginException {
        this.clearState();
        return true;
    }

    protected void clearState() {
        this.securityProvider = null;
        this.closeSystemSession();
    }

    protected void closeSystemSession() {
        if (this.systemSession != null) {
            try {
                this.systemSession.close();
            }
            catch (IOException e) {
                this.onError();
                log.error(e.getMessage(), (Throwable)e);
            }
            this.systemSession = null;
            this.root = null;
        }
    }

    protected boolean logout(@Nullable Set<Object> credentials, @Nullable Set<? extends Principal> principals) throws LoginException {
        if (credentials != null || principals != null) {
            if (!this.subject.isReadOnly()) {
                if (credentials != null) {
                    this.subject.getPublicCredentials().removeAll(credentials);
                }
                if (principals != null) {
                    this.subject.getPrincipals().removeAll(principals);
                }
            } else if (credentials != null) {
                AbstractLoginModule.destroyCredentials(credentials);
            }
            return true;
        }
        return false;
    }

    private static void destroyCredentials(@NotNull Iterable<Object> credentials) throws LoginException {
        for (Object cred : credentials) {
            if (cred instanceof Destroyable) {
                try {
                    ((Destroyable)cred).destroy();
                    continue;
                }
                catch (DestroyFailedException e) {
                    throw new LoginException(e.getMessage());
                }
            }
            log.debug("Unable to destroy credentials ({}) of read-only subject.", (Object)credentials.getClass().getName());
        }
    }

    @NotNull
    protected abstract Set<Class> getSupportedCredentials();

    @Nullable
    protected Credentials getCredentials() {
        Credentials creds;
        Set<Class> supported = this.getSupportedCredentials();
        if (this.callbackHandler != null) {
            log.debug("Login: retrieving Credentials using callback.");
            try {
                CredentialsCallback callback = new CredentialsCallback();
                this.callbackHandler.handle(new Callback[]{callback});
                Credentials creds2 = callback.getCredentials();
                if (creds2 != null && supported.contains(creds2.getClass())) {
                    log.debug("Login: Credentials '{}' obtained from callback", (Object)creds2);
                    return creds2;
                }
                log.debug("Login: No supported credentials obtained from callback; trying shared state.");
            }
            catch (IOException | UnsupportedCallbackException e) {
                this.onError();
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        if ((creds = this.getSharedCredentials()) != null && supported.contains(creds.getClass())) {
            log.debug("Login: Credentials obtained from shared state.");
            return creds;
        }
        log.debug("Login: No supported credentials found in shared state; looking for credentials in subject.");
        for (Class clz : this.getSupportedCredentials()) {
            Set cds = this.subject.getPublicCredentials(clz);
            if (cds.isEmpty()) continue;
            log.debug("Login: Credentials found in subject.");
            return (Credentials)cds.iterator().next();
        }
        log.debug("No credentials found.");
        return null;
    }

    @Nullable
    protected Credentials getSharedCredentials() {
        Credentials shared = null;
        if (this.sharedState.containsKey(SHARED_KEY_CREDENTIALS)) {
            Object sc = this.sharedState.get(SHARED_KEY_CREDENTIALS);
            if (sc instanceof Credentials) {
                shared = (Credentials)sc;
            } else {
                log.debug("Login: Invalid value for share state entry {}. Credentials expected.", (Object)SHARED_KEY_CREDENTIALS);
            }
        }
        return shared;
    }

    @Nullable
    protected String getSharedLoginName() {
        if (this.sharedState.containsKey(SHARED_KEY_LOGIN_NAME)) {
            return this.sharedState.get(SHARED_KEY_LOGIN_NAME).toString();
        }
        return null;
    }

    @Nullable
    protected PreAuthenticatedLogin getSharedPreAuthLogin() {
        Object login = this.sharedState.get(SHARED_KEY_PRE_AUTH_LOGIN);
        if (login instanceof PreAuthenticatedLogin) {
            return (PreAuthenticatedLogin)login;
        }
        return null;
    }

    @Nullable
    protected SecurityProvider getSecurityProvider() {
        if (this.securityProvider == null && this.callbackHandler != null) {
            RepositoryCallback rcb = new RepositoryCallback();
            try {
                this.callbackHandler.handle(new Callback[]{rcb});
                this.securityProvider = rcb.getSecurityProvider();
            }
            catch (IOException | UnsupportedCallbackException e) {
                this.onError();
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.securityProvider;
    }

    @Nullable
    protected Whiteboard getWhiteboard() {
        if (this.whiteboard == null && this.callbackHandler != null) {
            WhiteboardCallback cb = new WhiteboardCallback();
            try {
                this.callbackHandler.handle(new Callback[]{cb});
                this.whiteboard = cb.getWhiteboard();
            }
            catch (IOException | UnsupportedCallbackException e) {
                this.onError();
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.whiteboard;
    }

    @Nullable
    protected Root getRoot() {
        if (this.root == null && this.callbackHandler != null) {
            try {
                final RepositoryCallback rcb = new RepositoryCallback();
                this.callbackHandler.handle(new Callback[]{rcb});
                final ContentRepository repository = rcb.getContentRepository();
                if (repository != null) {
                    this.systemSession = Java23Subject.doAs(SystemSubject.INSTANCE, new PrivilegedExceptionAction<ContentSession>(){

                        @Override
                        public ContentSession run() throws LoginException, NoSuchWorkspaceException {
                            return repository.login(null, rcb.getWorkspaceName());
                        }
                    });
                    this.root = this.systemSession.getLatestRoot();
                } else {
                    log.error("Unable to retrieve the Root via RepositoryCallback; ContentRepository not available.");
                }
            }
            catch (IOException | PrivilegedActionException | UnsupportedCallbackException e) {
                this.onError();
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.root;
    }

    @Nullable
    protected UserManager getUserManager() {
        UserManager userManager = null;
        SecurityProvider sp = this.getSecurityProvider();
        Root r = this.getRoot();
        if (r != null && sp != null) {
            UserConfiguration uc = sp.getConfiguration(UserConfiguration.class);
            userManager = uc.getUserManager(r, NamePathMapper.DEFAULT);
        }
        if (userManager == null && this.callbackHandler != null) {
            try {
                UserManagerCallback userCallBack = new UserManagerCallback();
                this.callbackHandler.handle(new Callback[]{userCallBack});
                userManager = userCallBack.getUserManager();
            }
            catch (IOException | UnsupportedCallbackException e) {
                this.onError();
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return userManager;
    }

    @Nullable
    protected PrincipalProvider getPrincipalProvider() {
        PrincipalProvider principalProvider = null;
        SecurityProvider sp = this.getSecurityProvider();
        Root r = this.getRoot();
        if (r != null && sp != null) {
            PrincipalConfiguration pc = sp.getConfiguration(PrincipalConfiguration.class);
            principalProvider = pc.getPrincipalProvider(r, NamePathMapper.DEFAULT);
        }
        if (principalProvider == null && this.callbackHandler != null) {
            try {
                PrincipalProviderCallback principalCallBack = new PrincipalProviderCallback();
                this.callbackHandler.handle(new Callback[]{principalCallBack});
                principalProvider = principalCallBack.getPrincipalProvider();
            }
            catch (IOException | UnsupportedCallbackException e) {
                this.onError();
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return principalProvider;
    }

    @NotNull
    protected Set<? extends Principal> getPrincipals(@NotNull String userId) {
        PrincipalProvider principalProvider = this.getPrincipalProvider();
        if (principalProvider == null) {
            log.debug("Cannot retrieve principals. No principal provider configured.");
            return Collections.emptySet();
        }
        Stopwatch watch = Stopwatch.createStarted();
        Set<? extends Principal> principals = principalProvider.getPrincipals(userId);
        this.getLoginModuleMonitor().principalsCollected(watch.elapsed(TimeUnit.NANOSECONDS), principals.size());
        return principals;
    }

    @NotNull
    protected Set<? extends Principal> getPrincipals(@NotNull Principal userPrincipal) {
        PrincipalProvider principalProvider = this.getPrincipalProvider();
        if (principalProvider == null) {
            log.debug("Cannot retrieve principals. No principal provider configured.");
            return Collections.emptySet();
        }
        Stopwatch watch = Stopwatch.createStarted();
        HashSet<Principal> principals = new HashSet<Principal>();
        principals.add(userPrincipal);
        principals.addAll(principalProvider.getMembershipPrincipals(userPrincipal));
        this.getLoginModuleMonitor().principalsCollected(watch.elapsed(TimeUnit.NANOSECONDS), principals.size());
        return principals;
    }

    protected static void setAuthInfo(@NotNull AuthInfo authInfo, @NotNull Subject subject) {
        Set<AuthInfo> ais = subject.getPublicCredentials(AuthInfo.class);
        if (!ais.isEmpty()) {
            subject.getPublicCredentials().removeAll(ais);
        }
        subject.getPublicCredentials().add(authInfo);
    }

    @NotNull
    protected LoginModuleMonitor getLoginModuleMonitor() {
        if (this.loginModuleMonitor == null && this.callbackHandler != null) {
            RepositoryCallback rcb = new RepositoryCallback();
            try {
                this.callbackHandler.handle(new Callback[]{rcb});
                this.loginModuleMonitor = rcb.getLoginModuleMonitor();
            }
            catch (IOException | UnsupportedCallbackException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        if (this.loginModuleMonitor == null) {
            this.loginModuleMonitor = LoginModuleMonitor.NOOP;
        }
        return this.loginModuleMonitor;
    }

    protected void onError() {
        this.getLoginModuleMonitor().loginError();
    }
}

