/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.awt.GraphicsEnvironment;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.sf.jasperreports.engine.JRRuntimeException;

public final class JRGraphEnvInitializer {
    public static final String EXCEPTION_MESSAGE_KEY_INITIALIZATION_ERROR = "util.graphic.environment.initialization.error";
    private static Set<String> AVAILABLE_FONT_FACE_NAMES;

    public static synchronized void initializeGraphEnv() {
        if (AVAILABLE_FONT_FACE_NAMES == null) {
            AVAILABLE_FONT_FACE_NAMES = new HashSet<String>();
            try {
                AVAILABLE_FONT_FACE_NAMES.addAll(Arrays.asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()));
            }
            catch (Exception e) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_INITIALIZATION_ERROR, null, e);
            }
        }
    }

    public static boolean isAwtFontAvailable(String font) {
        JRGraphEnvInitializer.initializeGraphEnv();
        return AVAILABLE_FONT_FACE_NAMES.contains(font);
    }

    private JRGraphEnvInitializer() {
    }
}

