/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.text.MessageFormat;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.IOUtil;
import org.identityconnectors.common.ReflectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.Version;
import org.identityconnectors.common.script.Script;
import org.identityconnectors.common.security.GuardedByteArray;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.api.operations.APIOperation;
import org.identityconnectors.framework.api.operations.AuthenticationApiOp;
import org.identityconnectors.framework.api.operations.CreateApiOp;
import org.identityconnectors.framework.api.operations.DeleteApiOp;
import org.identityconnectors.framework.api.operations.DiscoverConfigurationApiOp;
import org.identityconnectors.framework.api.operations.GetApiOp;
import org.identityconnectors.framework.api.operations.ResolveUsernameApiOp;
import org.identityconnectors.framework.api.operations.SchemaApiOp;
import org.identityconnectors.framework.api.operations.ScriptOnConnectorApiOp;
import org.identityconnectors.framework.api.operations.ScriptOnResourceApiOp;
import org.identityconnectors.framework.api.operations.SearchApiOp;
import org.identityconnectors.framework.api.operations.SyncApiOp;
import org.identityconnectors.framework.api.operations.TestApiOp;
import org.identityconnectors.framework.api.operations.UpdateApiOp;
import org.identityconnectors.framework.api.operations.UpdateDeltaApiOp;
import org.identityconnectors.framework.api.operations.ValidateApiOp;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.QualifiedUid;
import org.identityconnectors.framework.common.objects.SortKey;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.spi.Connector;
import org.identityconnectors.framework.spi.operations.AuthenticateOp;
import org.identityconnectors.framework.spi.operations.CreateOp;
import org.identityconnectors.framework.spi.operations.DeleteOp;
import org.identityconnectors.framework.spi.operations.DiscoverConfigurationOp;
import org.identityconnectors.framework.spi.operations.ResolveUsernameOp;
import org.identityconnectors.framework.spi.operations.SPIOperation;
import org.identityconnectors.framework.spi.operations.SchemaOp;
import org.identityconnectors.framework.spi.operations.ScriptOnConnectorOp;
import org.identityconnectors.framework.spi.operations.ScriptOnResourceOp;
import org.identityconnectors.framework.spi.operations.SearchOp;
import org.identityconnectors.framework.spi.operations.SyncOp;
import org.identityconnectors.framework.spi.operations.TestOp;
import org.identityconnectors.framework.spi.operations.UpdateAttributeValuesOp;
import org.identityconnectors.framework.spi.operations.UpdateDeltaOp;
import org.identityconnectors.framework.spi.operations.UpdateOp;

public final class FrameworkUtil {
    private static final String PROP_FRAMEWORK_VERSION = "framework.version";
    private static Version frameworkVersion;
    private static final Map<Class<? extends SPIOperation>, Class<? extends APIOperation>> SPI_TO_API;
    private static final Set<Class<? extends Object>> CONFIG_SUPPORTED_TYPES;
    private static final Set<Class<?>> ATTR_SUPPORTED_TYPES;

    private FrameworkUtil() {
        throw new AssertionError();
    }

    public static Set<Class<? extends APIOperation>> spi2apis(Class<? extends SPIOperation> spi) {
        HashSet<Class<? extends APIOperation>> set = new HashSet<Class<? extends APIOperation>>();
        set.add(SPI_TO_API.get(spi));
        if (spi == SearchOp.class) {
            set.add(GetApiOp.class);
        }
        return set;
    }

    public static Set<Class<? extends SPIOperation>> allSPIOperations() {
        return CollectionUtil.newReadOnlySet(SPI_TO_API.keySet());
    }

    public static Set<Class<? extends APIOperation>> allAPIOperations() {
        HashSet<Class<APIOperation>> set = new HashSet<Class<APIOperation>>();
        set.addAll(SPI_TO_API.values());
        set.add(GetApiOp.class);
        set.add(ValidateApiOp.class);
        return CollectionUtil.newReadOnlySet(set);
    }

    public static Set<Class<? extends APIOperation>> getDefaultSupportedOperations(Class<? extends Connector> connector) {
        HashSet<Class<? extends APIOperation>> ret = new HashSet<Class<? extends APIOperation>>();
        Set<Class<?>> itrfs = ReflectionUtil.getAllInterfaces(connector);
        for (Class<? extends SPIOperation> spi : FrameworkUtil.allSPIOperations()) {
            if (!itrfs.contains(spi)) continue;
            ret.addAll(FrameworkUtil.spi2apis(spi));
        }
        ret.addAll(FrameworkUtil.getUnconditionallySupportedOperations());
        return ret;
    }

    public static Set<Class<? extends APIOperation>> getUnconditionallySupportedOperations() {
        HashSet<Class<? extends APIOperation>> ret = new HashSet<Class<? extends APIOperation>>();
        ret.add(ValidateApiOp.class);
        ret.add(ScriptOnConnectorApiOp.class);
        return ret;
    }

    public static Set<Class<? extends Object>> getAllSupportedConfigTypes() {
        return Collections.unmodifiableSet(CONFIG_SUPPORTED_TYPES);
    }

    public static boolean isSupportedConfigurationType(Class<?> clazz) {
        if (clazz.isArray()) {
            return FrameworkUtil.isSupportedConfigurationType(clazz.getComponentType());
        }
        return CONFIG_SUPPORTED_TYPES.contains(clazz);
    }

    public static Set<Class<? extends Object>> getAllSupportedAttributeTypes() {
        return Collections.unmodifiableSet(ATTR_SUPPORTED_TYPES);
    }

    public static boolean isSupportedAttributeType(Class<?> clazz) {
        return ATTR_SUPPORTED_TYPES.contains(clazz) || Map.class.isAssignableFrom(clazz);
    }

    public static void checkAttributeType(Class<?> clazz) {
        if (!FrameworkUtil.isSupportedAttributeType(clazz)) {
            throw new IllegalArgumentException(MessageFormat.format("Attribute type ''{0}'' is not supported.", clazz));
        }
    }

    public static void checkAttributeValue(Object value) {
        if (value != null) {
            FrameworkUtil.checkAttributeValue((String)null, value);
        }
    }

    public static void checkAttributeValue(String name, Object value) {
        if (value instanceof Map) {
            FrameworkUtil.checkAttributeValue(new StringBuilder(name == null ? "?" : name), value);
        } else if (value != null) {
            if (name == null) {
                FrameworkUtil.checkAttributeType(value.getClass());
            } else if (!FrameworkUtil.isSupportedAttributeType(value.getClass())) {
                throw new IllegalArgumentException(MessageFormat.format("Attribute ''{0}'' type ''{1}'' is not supported.", name, value.getClass()));
            }
        }
    }

    private static void checkAttributeValue(StringBuilder name, Object value) {
        if (value instanceof Map) {
            for (Map.Entry entry : ((Map)value).entrySet()) {
                Object key = entry.getKey();
                Object entryValue = entry.getValue();
                if (key instanceof String) {
                    StringBuilder nameBuilder = new StringBuilder(name).append('/').append(key);
                    if (entryValue instanceof Collection) {
                        nameBuilder.append("[*]");
                        for (Object item : (Collection)entryValue) {
                            FrameworkUtil.checkAttributeValue(nameBuilder, item);
                        }
                        continue;
                    }
                    FrameworkUtil.checkAttributeValue(nameBuilder, entryValue);
                    continue;
                }
                throw new IllegalArgumentException(MessageFormat.format("Map Attribute ''{0}'' must have String key, type ''{1}'' is not supported.", name, null != key ? key.getClass() : "null"));
            }
        } else if (value != null && !FrameworkUtil.isSupportedAttributeType(value.getClass())) {
            throw new IllegalArgumentException(MessageFormat.format("Attribute ''{0}'' type ''{1}'' is not supported.", name, value.getClass()));
        }
    }

    public static void checkOperationOptionType(Class<?> clazz) {
        if (clazz.isArray()) {
            FrameworkUtil.checkOperationOptionType(clazz.getComponentType());
            return;
        }
        if (FrameworkUtil.isSupportedConfigurationType(clazz)) {
            return;
        }
        if (ObjectClass.class.isAssignableFrom(clazz)) {
            return;
        }
        if (Uid.class.isAssignableFrom(clazz)) {
            return;
        }
        if (QualifiedUid.class.isAssignableFrom(clazz)) {
            return;
        }
        if (SortKey.class.isAssignableFrom(clazz)) {
            return;
        }
        throw new IllegalArgumentException("OperationOption type '" + clazz.getName() + "' is not supported.");
    }

    public static void checkOperationOptionValue(Object value) {
        if (value != null) {
            FrameworkUtil.checkOperationOptionType(value.getClass());
        }
    }

    public static Version getFrameworkVersion() {
        Class<FrameworkUtil> clazz = FrameworkUtil.class;
        synchronized (FrameworkUtil.class) {
            try {
                if (frameworkVersion == null) {
                    frameworkVersion = FrameworkUtil.getFrameworkVersion(FrameworkUtil.class.getClassLoader());
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return frameworkVersion;
            }
            catch (IOException e) {
                throw new ConnectorException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Version getFrameworkVersion(ClassLoader loader) throws IOException {
        InputStream stream = loader.getResourceAsStream("connectors-framework.properties");
        try {
            Properties props = new Properties();
            props.load(stream);
            String version = props.getProperty(PROP_FRAMEWORK_VERSION);
            if (version == null) {
                throw new IllegalStateException("connectors-framework.properties does not contain a framework.version property");
            }
            if (StringUtil.isBlank(version)) {
                throw new IllegalStateException("connectors-framework.properties specifies a blank version");
            }
            Version version2 = Version.parse(version);
            return version2;
        }
        finally {
            IOUtil.quietClose(stream);
        }
    }

    static synchronized void setFrameworkVersion(Version version) {
        frameworkVersion = version;
    }

    static {
        SPI_TO_API = new HashMap<Class<? extends SPIOperation>, Class<? extends APIOperation>>();
        SPI_TO_API.put(AuthenticateOp.class, AuthenticationApiOp.class);
        SPI_TO_API.put(ResolveUsernameOp.class, ResolveUsernameApiOp.class);
        SPI_TO_API.put(CreateOp.class, CreateApiOp.class);
        SPI_TO_API.put(DeleteOp.class, DeleteApiOp.class);
        SPI_TO_API.put(SearchOp.class, SearchApiOp.class);
        SPI_TO_API.put(UpdateOp.class, UpdateApiOp.class);
        SPI_TO_API.put(UpdateDeltaOp.class, UpdateDeltaApiOp.class);
        SPI_TO_API.put(UpdateAttributeValuesOp.class, UpdateApiOp.class);
        SPI_TO_API.put(SchemaOp.class, SchemaApiOp.class);
        SPI_TO_API.put(TestOp.class, TestApiOp.class);
        SPI_TO_API.put(ScriptOnConnectorOp.class, ScriptOnConnectorApiOp.class);
        SPI_TO_API.put(ScriptOnResourceOp.class, ScriptOnResourceApiOp.class);
        SPI_TO_API.put(SyncOp.class, SyncApiOp.class);
        SPI_TO_API.put(DiscoverConfigurationOp.class, DiscoverConfigurationApiOp.class);
        CONFIG_SUPPORTED_TYPES = new HashSet<Class<? extends Object>>();
        CONFIG_SUPPORTED_TYPES.add(String.class);
        CONFIG_SUPPORTED_TYPES.add(Long.TYPE);
        CONFIG_SUPPORTED_TYPES.add(Long.class);
        CONFIG_SUPPORTED_TYPES.add(Character.TYPE);
        CONFIG_SUPPORTED_TYPES.add(Character.class);
        CONFIG_SUPPORTED_TYPES.add(Double.TYPE);
        CONFIG_SUPPORTED_TYPES.add(Double.class);
        CONFIG_SUPPORTED_TYPES.add(Float.TYPE);
        CONFIG_SUPPORTED_TYPES.add(Float.class);
        CONFIG_SUPPORTED_TYPES.add(Integer.TYPE);
        CONFIG_SUPPORTED_TYPES.add(Integer.class);
        CONFIG_SUPPORTED_TYPES.add(Boolean.TYPE);
        CONFIG_SUPPORTED_TYPES.add(Boolean.class);
        CONFIG_SUPPORTED_TYPES.add(URI.class);
        CONFIG_SUPPORTED_TYPES.add(File.class);
        CONFIG_SUPPORTED_TYPES.add(GuardedByteArray.class);
        CONFIG_SUPPORTED_TYPES.add(GuardedString.class);
        CONFIG_SUPPORTED_TYPES.add(Script.class);
        ATTR_SUPPORTED_TYPES = new HashSet();
        ATTR_SUPPORTED_TYPES.add(String.class);
        ATTR_SUPPORTED_TYPES.add(Long.TYPE);
        ATTR_SUPPORTED_TYPES.add(Long.class);
        ATTR_SUPPORTED_TYPES.add(Character.TYPE);
        ATTR_SUPPORTED_TYPES.add(Character.class);
        ATTR_SUPPORTED_TYPES.add(Double.TYPE);
        ATTR_SUPPORTED_TYPES.add(Double.class);
        ATTR_SUPPORTED_TYPES.add(Float.TYPE);
        ATTR_SUPPORTED_TYPES.add(Float.class);
        ATTR_SUPPORTED_TYPES.add(Integer.TYPE);
        ATTR_SUPPORTED_TYPES.add(Integer.class);
        ATTR_SUPPORTED_TYPES.add(Boolean.TYPE);
        ATTR_SUPPORTED_TYPES.add(Boolean.class);
        ATTR_SUPPORTED_TYPES.add(Byte.TYPE);
        ATTR_SUPPORTED_TYPES.add(Byte.class);
        ATTR_SUPPORTED_TYPES.add(byte[].class);
        ATTR_SUPPORTED_TYPES.add(BigDecimal.class);
        ATTR_SUPPORTED_TYPES.add(BigInteger.class);
        ATTR_SUPPORTED_TYPES.add(GuardedByteArray.class);
        ATTR_SUPPORTED_TYPES.add(GuardedString.class);
        ATTR_SUPPORTED_TYPES.add(Map.class);
        ATTR_SUPPORTED_TYPES.add(ZonedDateTime.class);
    }
}

