/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.conf;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.openjpa.conf.CacheMarshaller;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.lib.conf.Configurable;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.InternalException;

public class CacheMarshallerImpl
implements CacheMarshaller,
Configurable {
    private static final Localizer _loc = Localizer.forPackage(CacheMarshallerImpl.class);
    private String _id;
    private CacheMarshaller.ValidationPolicy _validationPolicy;
    private OpenJPAConfiguration _conf;
    private Log _log;
    private File _outputFile;
    private URL _inputURL;
    private String _inputResourceLocation;
    private boolean _consumeErrors = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object load() {
        Object o;
        block19: {
            if (this._inputURL == null) {
                this._log.trace((Object)_loc.get("cache-marshaller-no-inputs", (Object)this.getId()));
                return null;
            }
            o = null;
            ObjectInputStream in = null;
            try {
                in = new ObjectInputStream(new BufferedInputStream(this._inputURL.openStream()));
                o = in.readObject();
                o = this._validationPolicy.getValidData(o);
                if (o != null && o.getClass().isArray()) {
                    Object[] array;
                    for (Object value : array = (Object[])o) {
                        this.configure(value);
                    }
                } else {
                    this.configure(o);
                }
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)_loc.get("cache-marshaller-loaded", (Object)(o == null ? null : o.getClass().getName()), (Object)this._inputURL));
                }
            }
            catch (Exception e) {
                if (this._consumeErrors) {
                    if (this._log.isWarnEnabled()) {
                        this._log.warn((Object)_loc.get("cache-marshaller-load-exception-ignore", (Object)this._inputURL), (Throwable)e);
                    }
                    break block19;
                }
                throw new InternalException(_loc.get("cache-marshaller-load-exception-fatal", (Object)this._inputURL), (Throwable)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return o;
    }

    private void configure(Object o) {
        if (o instanceof Configurable) {
            ((Configurable)o).setConfiguration((Configuration)this._conf);
            ((Configurable)o).startConfiguration();
            ((Configurable)o).endConfiguration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(Object o) {
        block16: {
            if (this._outputFile == null) {
                this._log.trace((Object)_loc.get("cache-marshaller-no-output-file", (Object)this.getId()));
                return;
            }
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(this._outputFile);
                ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(out));
                Object toStore = this._validationPolicy.getCacheableData(o);
                oos.writeObject(toStore);
                oos.flush();
                out.flush();
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)_loc.get("cache-marshaller-stored", (Object)o.getClass().getName(), (Object)this._outputFile));
                }
            }
            catch (Exception e) {
                if (this._consumeErrors) {
                    if (this._log.isWarnEnabled()) {
                        this._log.warn((Object)_loc.get("cache-marshaller-store-exception", (Object)o.getClass().getName(), (Object)this._outputFile), (Throwable)e);
                    }
                    break block16;
                }
                throw new InternalException(_loc.get("cache-marshaller-store-exception", (Object)o.getClass().getName(), (Object)this._outputFile), (Throwable)e);
            }
            finally {
                if (out != null) {
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public void setOutputFile(File file) {
        this._outputFile = file;
    }

    public File getOutputFile() {
        return this._outputFile;
    }

    public void setInputURL(URL url) {
        this._inputURL = url;
    }

    public void setInputResource(String resource) {
        this._inputResourceLocation = resource;
    }

    public void setConsumeSerializationErrors(boolean consume) {
        this._consumeErrors = consume;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public void setId(String id) {
        this._id = id;
    }

    @Override
    public void setValidationPolicy(String policy) throws InstantiationException, IllegalAccessException {
        String name = Configurations.getClassName((String)policy);
        String props = Configurations.getProperties((String)policy);
        this._validationPolicy = (CacheMarshaller.ValidationPolicy)Configurations.newInstance((String)name, (Configuration)this._conf, (String)props, null);
    }

    public CacheMarshaller.ValidationPolicy getValidationPolicy() {
        return this._validationPolicy;
    }

    public void setConfiguration(Configuration conf) {
        this._conf = (OpenJPAConfiguration)conf;
        this._log = conf.getConfigurationLog();
    }

    public void startConfiguration() {
    }

    public void endConfiguration() {
        if (this._inputResourceLocation != null && this._inputURL != null) {
            throw new IllegalStateException(_loc.get("cache-marshaller-input-url-and-resource-specified").getMessage());
        }
        if (this._inputResourceLocation != null) {
            this.setInputUrlFromResourceLocation();
        }
        if (this._validationPolicy == null) {
            throw new IllegalStateException(_loc.get("cache-marshaller-null-validation-policy", (Object)this.getClass().getName()).getMessage());
        }
        if (this._id == null) {
            throw new IllegalStateException(_loc.get("cache-marshaller-null-id", (Object)this.getClass().getName()).getMessage());
        }
    }

    private void setInputUrlFromResourceLocation() {
        try {
            ClassLoader cl = this._conf.getClassResolverInstance().getClassLoader(this.getClass(), null);
            ArrayList<URL> list = new ArrayList<URL>();
            Enumeration<URL> e = cl.getResources(this._inputResourceLocation);
            while (e.hasMoreElements()) {
                list.add(e.nextElement());
            }
            if (list.size() > 1) {
                if (this._consumeErrors) {
                    if (this._log.isWarnEnabled()) {
                        this._log.warn((Object)_loc.get("cache-marshaller-multiple-resources-warn", (Object)this.getId(), (Object)this._inputResourceLocation, list).getMessage());
                    }
                } else {
                    throw new IllegalStateException(_loc.get("cache-marshaller-multiple-resources", (Object)this.getId(), (Object)this._inputResourceLocation, list).getMessage());
                }
            }
            if (!list.isEmpty()) {
                this._inputURL = (URL)list.get(0);
            }
        }
        catch (IOException ioe) {
            IllegalStateException ise = new IllegalStateException(_loc.get("cache-marshaller-bad-url", (Object)this.getId(), (Object)this._inputResourceLocation).getMessage(), ioe);
            throw ise;
        }
    }
}

