/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.agenda;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.bpmn.model.CallActivity;
import org.flowable.bpmn.model.CompensateEventDefinition;
import org.flowable.bpmn.model.EndEvent;
import org.flowable.bpmn.model.EventSubProcess;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.HasExecutionListeners;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.bpmn.model.Transaction;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.util.CollectionUtil;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.agenda.AbstractOperation;
import org.flowable.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.flowable.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import org.flowable.engine.impl.bpmn.helper.ScopeUtil;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.delegate.SubProcessActivityBehavior;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.job.service.JobService;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndExecutionOperation
extends AbstractOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(EndExecutionOperation.class);
    protected boolean forceSynchronous;

    public EndExecutionOperation(CommandContext commandContext, ExecutionEntity execution) {
        super(commandContext, execution);
    }

    public EndExecutionOperation(CommandContext commandContext, ExecutionEntity execution, boolean forceSynchronous) {
        this(commandContext, execution);
        this.forceSynchronous = forceSynchronous;
    }

    @Override
    public void run() {
        if (this.execution.isProcessInstanceType()) {
            this.handleProcessInstanceExecution(this.execution);
        } else {
            this.handleRegularExecution();
        }
    }

    protected void handleProcessInstanceExecution(ExecutionEntity processInstanceExecution) {
        int activeExecutions;
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(this.commandContext);
        String processInstanceId = processInstanceExecution.getId();
        LOGGER.debug("No parent execution found. Verifying if process instance {} can be stopped.", (Object)processInstanceId);
        ExecutionEntity superExecution = processInstanceExecution.getSuperExecution();
        if (!this.forceSynchronous && this.isAsyncCompleteCallActivity(superExecution)) {
            this.scheduleAsyncCompleteCallActivity(superExecution, processInstanceExecution);
            return;
        }
        SubProcessActivityBehavior subProcessActivityBehavior = null;
        if (superExecution != null) {
            FlowNode superExecutionElement = (FlowNode)superExecution.getCurrentFlowElement();
            subProcessActivityBehavior = (SubProcessActivityBehavior)superExecutionElement.getBehavior();
            try {
                subProcessActivityBehavior.completing(superExecution, processInstanceExecution);
            }
            catch (RuntimeException e) {
                LOGGER.error("Error while completing sub process of execution {}", (Object)processInstanceExecution, (Object)e);
                throw e;
            }
            catch (Exception e) {
                LOGGER.error("Error while completing sub process of execution {}", (Object)processInstanceExecution, (Object)e);
                throw new FlowableException("Error while completing sub process of execution " + processInstanceExecution, (Throwable)e);
            }
        }
        if ((activeExecutions = this.getNumberOfActiveChildExecutionsForProcessInstance(executionEntityManager, processInstanceId)) == 0) {
            LOGGER.debug("No active executions found. Ending process instance {}", (Object)processInstanceId);
            executionEntityManager.deleteProcessInstanceExecutionEntity(processInstanceId, this.execution.getCurrentFlowElement() != null ? this.execution.getCurrentFlowElement().getId() : null, null, false, false, true);
        } else {
            LOGGER.debug("Active executions found. Process instance {} will not be ended.", (Object)processInstanceId);
        }
        Process process = ProcessDefinitionUtil.getProcess(processInstanceExecution.getProcessDefinitionId());
        if (CollectionUtil.isNotEmpty((Collection)process.getExecutionListeners())) {
            this.executeExecutionListeners((HasExecutionListeners)process, processInstanceExecution, "end");
        }
        if (superExecution != null) {
            superExecution.setSubProcessInstance(null);
            try {
                subProcessActivityBehavior.completed(superExecution);
            }
            catch (RuntimeException e) {
                LOGGER.error("Error while completing sub process of execution {}", (Object)processInstanceExecution, (Object)e);
                throw e;
            }
            catch (Exception e) {
                LOGGER.error("Error while completing sub process of execution {}", (Object)processInstanceExecution, (Object)e);
                throw new FlowableException("Error while completing sub process of execution " + processInstanceExecution, (Throwable)e);
            }
        }
    }

    protected boolean isAsyncCompleteCallActivity(ExecutionEntity superExecution) {
        FlowNode superExecutionFlowNode;
        if (superExecution != null && (superExecutionFlowNode = (FlowNode)superExecution.getCurrentFlowElement()) instanceof CallActivity) {
            CallActivity callActivity = (CallActivity)superExecutionFlowNode;
            return callActivity.isCompleteAsync();
        }
        return false;
    }

    protected void scheduleAsyncCompleteCallActivity(ExecutionEntity superExecutionEntity, ExecutionEntity childProcessInstanceExecutionEntity) {
        JobService jobService = CommandContextUtil.getJobService(this.commandContext);
        JobEntity job = jobService.createJob();
        job.setExecutionId(superExecutionEntity.getId());
        job.setJobHandlerConfiguration(childProcessInstanceExecutionEntity.getId());
        String processInstanceId = superExecutionEntity.getProcessInstanceId() != null ? superExecutionEntity.getProcessInstanceId() : superExecutionEntity.getId();
        job.setProcessInstanceId(processInstanceId);
        job.setProcessDefinitionId(childProcessInstanceExecutionEntity.getProcessDefinitionId());
        job.setElementId(superExecutionEntity.getCurrentFlowElement().getId());
        job.setElementName(superExecutionEntity.getCurrentFlowElement().getName());
        job.setTenantId(childProcessInstanceExecutionEntity.getTenantId());
        job.setJobHandlerType("async-complete-call-actiivty");
        jobService.createAsyncJob(job, true);
        jobService.scheduleAsyncJob(job);
    }

    protected void handleRegularExecution() {
        List<ExecutionEntity> eventScopeExecutions;
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(this.commandContext);
        ExecutionEntityManager executionEntityManager = processEngineConfiguration.getExecutionEntityManager();
        ExecutionEntity parentExecution = (ExecutionEntity)executionEntityManager.findById(this.execution.getParentId());
        if (this.execution.isScope()) {
            executionEntityManager.deleteChildExecutions(this.execution, null, false);
        }
        LOGGER.debug("Ending execution {}", (Object)this.execution.getId());
        executionEntityManager.deleteExecutionAndRelatedData(this.execution, null, false);
        LOGGER.debug("Parent execution found. Continuing process using execution {}", (Object)parentExecution.getId());
        if (this.isEndEventOrImpliedEndEventInMultiInstanceSubprocess(this.execution)) {
            this.handleMultiInstanceSubProcess(processEngineConfiguration, executionEntityManager, parentExecution, this.execution);
            return;
        }
        SubProcess subProcess = this.execution.getCurrentFlowElement().getSubProcess();
        if (subProcess instanceof EventSubProcess) {
            EventSubProcess eventSubProcess = (EventSubProcess)subProcess;
            boolean hasNonInterruptingStartEvent = false;
            for (FlowElement eventSubElement : eventSubProcess.getFlowElements()) {
                StartEvent startEvent;
                if (!(eventSubElement instanceof StartEvent) || (startEvent = (StartEvent)eventSubElement).isInterrupting()) continue;
                hasNonInterruptingStartEvent = true;
                break;
            }
            if (hasNonInterruptingStartEvent) {
                executionEntityManager.deleteChildExecutions(parentExecution, null, false);
                executionEntityManager.deleteExecutionAndRelatedData(parentExecution, null, false);
                CommandContextUtil.getEventDispatcher(this.commandContext).dispatchEvent((FlowableEvent)FlowableEventBuilder.createActivityEvent(FlowableEngineEventType.ACTIVITY_COMPLETED, subProcess.getId(), subProcess.getName(), parentExecution.getId(), parentExecution.getProcessInstanceId(), parentExecution.getProcessDefinitionId(), (FlowElement)subProcess), processEngineConfiguration.getEngineCfgKey());
                ExecutionEntity subProcessParentExecution = parentExecution.getParent();
                if (this.getNumberOfActiveChildExecutionsForExecution(executionEntityManager, subProcessParentExecution.getId()) == 0) {
                    SubProcess parentSubProcess;
                    if (subProcessParentExecution.getCurrentFlowElement() instanceof SubProcess && (parentSubProcess = (SubProcess)subProcessParentExecution.getCurrentFlowElement()).getOutgoingFlows().size() > 0) {
                        ExecutionEntity executionEntity = this.handleSubProcessEnd(executionEntityManager, subProcessParentExecution, parentSubProcess);
                        this.agenda.planTakeOutgoingSequenceFlowsOperation(executionEntity, true);
                        return;
                    }
                    this.agenda.planEndExecutionOperation(subProcessParentExecution);
                }
                return;
            }
        }
        if (!(eventScopeExecutions = this.getEventScopeExecutions(executionEntityManager, parentExecution)).isEmpty()) {
            List<? extends ExecutionEntity> childExecutions = parentExecution.getExecutions();
            boolean activeSiblings = false;
            for (ExecutionEntity executionEntity : childExecutions) {
                if (this.isInEventSubProcess(executionEntity) || !executionEntity.isActive() || executionEntity.isEnded()) continue;
                activeSiblings = true;
            }
            if (!activeSiblings) {
                for (ExecutionEntity executionEntity : eventScopeExecutions) {
                    executionEntityManager.deleteExecutionAndRelatedData(executionEntity, null, false);
                }
            }
        }
        if (this.getNumberOfActiveChildExecutionsForExecution(executionEntityManager, parentExecution.getId()) == 0) {
            ExecutionEntity executionToContinue = null;
            if (subProcess != null) {
                if (subProcess.isForCompensation()) {
                    this.agenda.planEndExecutionOperation(parentExecution);
                } else {
                    executionToContinue = this.handleSubProcessEnd(executionEntityManager, parentExecution, subProcess);
                }
            } else {
                executionToContinue = this.handleRegularExecutionEnd(executionEntityManager, parentExecution);
            }
            if (executionToContinue != null) {
                if (executionToContinue.isProcessInstanceType()) {
                    this.handleProcessInstanceExecution(executionToContinue);
                } else {
                    this.agenda.planTakeOutgoingSequenceFlowsOperation(executionToContinue, true);
                }
            }
        }
    }

    protected ExecutionEntity handleSubProcessEnd(ExecutionEntityManager executionEntityManager, ExecutionEntity parentExecution, SubProcess subProcess) {
        ExecutionEntity executionToContinue = null;
        executionToContinue = executionEntityManager.createChildExecution(parentExecution.getParent());
        executionToContinue.setCurrentFlowElement((FlowElement)subProcess);
        executionToContinue.setActive(false);
        boolean hasCompensation = false;
        if (subProcess instanceof Transaction) {
            hasCompensation = true;
        } else {
            block0: for (FlowElement subElement : subProcess.getFlowElements()) {
                Activity subActivity;
                if (!(subElement instanceof Activity) || !CollectionUtil.isNotEmpty((Collection)(subActivity = (Activity)subElement).getBoundaryEvents())) continue;
                for (BoundaryEvent boundaryEvent : subActivity.getBoundaryEvents()) {
                    if (!CollectionUtil.isNotEmpty((Collection)boundaryEvent.getEventDefinitions()) || !(boundaryEvent.getEventDefinitions().get(0) instanceof CompensateEventDefinition)) continue;
                    hasCompensation = true;
                    continue block0;
                }
            }
        }
        if (hasCompensation) {
            ScopeUtil.createCopyOfSubProcessExecutionForCompensation(parentExecution);
        }
        executionEntityManager.deleteChildExecutions(parentExecution, null, false);
        executionEntityManager.deleteExecutionAndRelatedData(parentExecution, null, false);
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(this.commandContext);
        CommandContextUtil.getEventDispatcher(this.commandContext).dispatchEvent((FlowableEvent)FlowableEventBuilder.createActivityEvent(FlowableEngineEventType.ACTIVITY_COMPLETED, subProcess.getId(), subProcess.getName(), parentExecution.getId(), parentExecution.getProcessInstanceId(), parentExecution.getProcessDefinitionId(), (FlowElement)subProcess), processEngineConfiguration.getEngineCfgKey());
        return executionToContinue;
    }

    protected ExecutionEntity handleRegularExecutionEnd(ExecutionEntityManager executionEntityManager, ExecutionEntity parentExecution) {
        ExecutionEntity executionToContinue = null;
        if (!parentExecution.isProcessInstanceType() && !(parentExecution.getCurrentFlowElement() instanceof SubProcess)) {
            parentExecution.setCurrentFlowElement(this.execution.getCurrentFlowElement());
        }
        if (this.execution.getCurrentFlowElement() instanceof SubProcess) {
            SubProcess currentSubProcess = (SubProcess)this.execution.getCurrentFlowElement();
            if (currentSubProcess.getOutgoingFlows().size() > 0) {
                executionToContinue = executionEntityManager.createChildExecution(parentExecution);
                executionToContinue.setCurrentFlowElement(this.execution.getCurrentFlowElement());
            } else if (!parentExecution.getId().equals(parentExecution.getProcessInstanceId())) {
                executionToContinue = executionEntityManager.createChildExecution(parentExecution.getParent());
                executionToContinue.setCurrentFlowElement(parentExecution.getCurrentFlowElement());
                executionEntityManager.deleteChildExecutions(parentExecution, null, false);
                executionEntityManager.deleteExecutionAndRelatedData(parentExecution, null, false);
            } else {
                executionToContinue = parentExecution;
            }
        } else {
            executionToContinue = parentExecution;
        }
        return executionToContinue;
    }

    protected void handleMultiInstanceSubProcess(ProcessEngineConfigurationImpl processEngineConfiguration, ExecutionEntityManager executionEntityManager, ExecutionEntity parentExecution, ExecutionEntity currentExecution) {
        ParallelMultiInstanceBehavior parallelMultiInstanceBehavior;
        Object subProcessBehavior = currentExecution.getCurrentFlowElement().getSubProcess().getBehavior();
        if (subProcessBehavior instanceof ParallelMultiInstanceBehavior && (parallelMultiInstanceBehavior = (ParallelMultiInstanceBehavior)subProcessBehavior).isAsyncWithoutWaitStates(CommandContextUtil.getProcessEngineConfiguration())) {
            parallelMultiInstanceBehavior.leave(currentExecution);
            return;
        }
        List<ExecutionEntity> activeChildExecutions = this.getActiveChildExecutionsForExecution(executionEntityManager, parentExecution.getId());
        boolean containsOtherChildExecutions = false;
        for (ExecutionEntity activeExecution : activeChildExecutions) {
            if (activeExecution.getId().equals(this.execution.getId())) continue;
            containsOtherChildExecutions = true;
        }
        if (!containsOtherChildExecutions) {
            ScopeUtil.createCopyOfSubProcessExecutionForCompensation(parentExecution);
            SubProcess subProcess = this.execution.getCurrentFlowElement().getSubProcess();
            MultiInstanceActivityBehavior multiInstanceBehavior = (MultiInstanceActivityBehavior)subProcess.getBehavior();
            if (!(multiInstanceBehavior instanceof ParallelMultiInstanceBehavior) || !processEngineConfiguration.isParallelMultiInstanceAsyncLeave()) {
                this.agenda.planDestroyScopeOperation(parentExecution);
            }
            parentExecution.setCurrentFlowElement((FlowElement)subProcess);
            multiInstanceBehavior.leave(parentExecution);
        }
    }

    protected boolean isEndEventOrImpliedEndEventInMultiInstanceSubprocess(ExecutionEntity executionEntity) {
        FlowElement currentFlowElement = executionEntity.getCurrentFlowElement();
        if (currentFlowElement instanceof EndEvent || this.isFlowNodeWithoutOutgoingSequenceFlow(currentFlowElement)) {
            SubProcess subProcess = this.execution.getCurrentFlowElement().getSubProcess();
            return !executionEntity.getParent().isProcessInstanceType() && subProcess != null && subProcess.getLoopCharacteristics() != null && subProcess.getBehavior() instanceof MultiInstanceActivityBehavior;
        }
        return false;
    }

    protected boolean isFlowNodeWithoutOutgoingSequenceFlow(FlowElement flowElement) {
        if (flowElement instanceof FlowNode) {
            FlowNode flowNode = (FlowNode)flowElement;
            return flowNode.getOutgoingFlows() == null || flowNode.getOutgoingFlows().isEmpty();
        }
        return false;
    }

    protected int getNumberOfActiveChildExecutionsForProcessInstance(ExecutionEntityManager executionEntityManager, String processInstanceId) {
        List<ExecutionEntity> executions = executionEntityManager.findChildExecutionsByProcessInstanceId(processInstanceId);
        int activeExecutions = 0;
        for (ExecutionEntity execution : executions) {
            if (!execution.isActive() || processInstanceId.equals(execution.getId())) continue;
            ++activeExecutions;
        }
        return activeExecutions;
    }

    protected int getNumberOfActiveChildExecutionsForExecution(ExecutionEntityManager executionEntityManager, String executionId) {
        List<ExecutionEntity> executions = executionEntityManager.findChildExecutionsByParentExecutionId(executionId);
        int activeExecutions = 0;
        for (ExecutionEntity activeExecution : executions) {
            if (activeExecution.getCurrentFlowElement() instanceof BoundaryEvent) continue;
            ++activeExecutions;
        }
        return activeExecutions;
    }

    protected List<ExecutionEntity> getActiveChildExecutionsForExecution(ExecutionEntityManager executionEntityManager, String executionId) {
        ArrayList<ExecutionEntity> activeChildExecutions = new ArrayList<ExecutionEntity>();
        List<ExecutionEntity> executions = executionEntityManager.findChildExecutionsByParentExecutionId(executionId);
        for (ExecutionEntity activeExecution : executions) {
            if (activeExecution.getCurrentFlowElement() instanceof BoundaryEvent) continue;
            activeChildExecutions.add(activeExecution);
        }
        return activeChildExecutions;
    }

    protected List<ExecutionEntity> getEventScopeExecutions(ExecutionEntityManager executionEntityManager, ExecutionEntity parentExecution) {
        ArrayList<ExecutionEntity> eventScopeExecutions = new ArrayList<ExecutionEntity>(1);
        List<ExecutionEntity> executions = executionEntityManager.findChildExecutionsByParentExecutionId(parentExecution.getId());
        for (ExecutionEntity childExecution : executions) {
            if (!childExecution.isEventScope()) continue;
            eventScopeExecutions.add(childExecution);
        }
        return eventScopeExecutions;
    }

    protected boolean allChildExecutionsEnded(ExecutionEntity parentExecutionEntity, ExecutionEntity executionEntityToIgnore) {
        for (ExecutionEntity executionEntity : parentExecutionEntity.getExecutions()) {
            if (executionEntityToIgnore != null && executionEntityToIgnore.getId().equals(executionEntity.getId())) continue;
            if (!executionEntity.isEnded()) {
                return false;
            }
            if (executionEntity.getExecutions() == null || executionEntity.getExecutions().size() <= 0 || this.allChildExecutionsEnded(executionEntity, executionEntityToIgnore)) continue;
            return false;
        }
        return true;
    }

    protected boolean isInEventSubProcess(ExecutionEntity executionEntity) {
        for (ExecutionEntity currentExecutionEntity = executionEntity; currentExecutionEntity != null; currentExecutionEntity = currentExecutionEntity.getParent()) {
            if (!(currentExecutionEntity.getCurrentFlowElement() instanceof EventSubProcess)) continue;
            return true;
        }
        return false;
    }
}

