/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web;

import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.cas.web.support.CasLocaleChangeInterceptor;
import org.springframework.beans.factory.ObjectProvider;

public class OidcLocaleChangeInterceptor
extends CasLocaleChangeInterceptor {
    public OidcLocaleChangeInterceptor(ObjectProvider<CasConfigurationProperties> casProperties, ObjectProvider<ArgumentExtractor> argumentExtractor, ObjectProvider<ServicesManager> servicesManager) {
        super(casProperties, argumentExtractor, servicesManager);
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        this.resolveUiLocale(request, response);
        return true;
    }

    private void resolveUiLocale(HttpServletRequest request, HttpServletResponse response) {
        List newLocale;
        WebApplicationService service = ((ArgumentExtractor)this.argumentExtractor.getObject()).extractService(request);
        if (service != null && (newLocale = (List)service.getAttributes().get("ui_locales")) != null && !newLocale.isEmpty()) {
            OidcLocaleChangeInterceptor.configureLocale((HttpServletRequest)request, (HttpServletResponse)response, (Locale)Locale.forLanguageTag(newLocale.get(0).toString()));
        }
    }
}

