/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pac4j.discovery;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.pac4j.discovery.DelegatedAuthenticationDynamicDiscoveryProvider;
import org.apereo.cas.pac4j.discovery.DelegatedAuthenticationDynamicDiscoveryProviderLocator;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.RegexUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.cas.web.flow.DelegatedClientIdentityProviderConfigurationProducer;
import org.pac4j.core.client.Clients;
import org.pac4j.core.client.IndirectClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class DefaultDelegatedAuthenticationDynamicDiscoveryProviderLocator
implements DelegatedAuthenticationDynamicDiscoveryProviderLocator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDelegatedAuthenticationDynamicDiscoveryProviderLocator.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();
    private final DelegatedClientIdentityProviderConfigurationProducer providerProducer;
    private final Clients clients;
    private final CasConfigurationProperties casProperties;

    public Optional<IndirectClient> locate(DelegatedAuthenticationDynamicDiscoveryProviderLocator.DynamicDiscoveryProviderRequest request) {
        try {
            Resource resource = this.casProperties.getAuthn().getPac4j().getCore().getDiscoverySelection().getJson().getLocation();
            Map mappings = (Map)MAPPER.readValue(resource.getInputStream(), (TypeReference)new TypeReference<Map<String, DelegatedAuthenticationDynamicDiscoveryProvider>>(){});
            return mappings.entrySet().stream().sorted(Comparator.comparingInt(o -> ((DelegatedAuthenticationDynamicDiscoveryProvider)o.getValue()).getOrder())).filter(entry -> RegexUtils.find((String)((String)entry.getKey()), (String)request.getUserId())).map(Map.Entry::getValue).map(provider -> this.clients.findClient(provider.getClientName())).flatMap(Optional::stream).map(IndirectClient.class::cast).findFirst();
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return Optional.empty();
        }
    }

    @Generated
    public DefaultDelegatedAuthenticationDynamicDiscoveryProviderLocator(DelegatedClientIdentityProviderConfigurationProducer providerProducer, Clients clients, CasConfigurationProperties casProperties) {
        this.providerProducer = providerProducer;
        this.clients = clients;
        this.casProperties = casProperties;
    }

    @Generated
    public DelegatedClientIdentityProviderConfigurationProducer getProviderProducer() {
        return this.providerProducer;
    }

    @Generated
    public Clients getClients() {
        return this.clients;
    }

    @Generated
    public CasConfigurationProperties getCasProperties() {
        return this.casProperties;
    }
}

