/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.thymeleaf.util.Validate;

public final class ExpressionUtils {
    private static final Set<String> BLACKLISTED_CLASS_NAME_PREFIXES = new HashSet<String>(Arrays.asList("java.lang.Runtime", "java.lang.Thread", "java.lang.Class", "java.lang.ClassLoader", "java.lang.Runnable", "java.lang.reflect.Executable", "java.util.concurrent.Future", "java.util.concurrent.FutureTask", "java.util.concurrent.RunnableFuture", "java.util.concurrent.ListenableFuture", "java.util.concurrent.Executor", "java.sql.DriverManager"));

    public static boolean isTypeAllowed(String typeName) {
        String package0;
        Validate.notNull(typeName, "Type name cannot be null");
        int i0 = typeName.indexOf(46);
        if (i0 >= 0 && "java".equals(package0 = typeName.substring(0, i0))) {
            for (String prefix : BLACKLISTED_CLASS_NAME_PREFIXES) {
                if (!typeName.startsWith(prefix)) continue;
                return false;
            }
        }
        return true;
    }

    public static List<String> getBlacklist() {
        ArrayList<String> blacklist = new ArrayList<String>();
        blacklist.addAll(BLACKLISTED_CLASS_NAME_PREFIXES);
        return blacklist;
    }

    private ExpressionUtils() {
    }
}

