/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.internal.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Optional;

public class CertificateParser {
    public static final String ID_FIDO_GEN_CE_AAGUID = "1.3.6.1.4.1.45724.1.1.4";
    private static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();
    private static final List<String> FIXSIG = Arrays.asList("CN=Yubico U2F EE Serial 776137165", "CN=Yubico U2F EE Serial 1086591525", "CN=Yubico U2F EE Serial 1973679733", "CN=Yubico U2F EE Serial 13503277888", "CN=Yubico U2F EE Serial 13831167861", "CN=Yubico U2F EE Serial 14803321578");
    private static final int UNUSED_BITS_BYTE_INDEX_FROM_END = 257;

    public static X509Certificate parsePem(String pemEncodedCert) throws CertificateException {
        return CertificateParser.parseDer(pemEncodedCert.replaceAll("-----BEGIN CERTIFICATE-----", "").replaceAll("-----END CERTIFICATE-----", "").replaceAll("\n", ""));
    }

    public static X509Certificate parseDer(String base64DerEncodedCert) throws CertificateException {
        return CertificateParser.parseDer(BASE64_DECODER.decode(base64DerEncodedCert));
    }

    public static X509Certificate parseDer(byte[] derEncodedCert) throws CertificateException {
        return CertificateParser.parseDer(new ByteArrayInputStream(derEncodedCert));
    }

    public static X509Certificate parseDer(InputStream is) throws CertificateException {
        X509Certificate cert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(is);
        if (FIXSIG.contains(cert.getSubjectDN().getName())) {
            byte[] encoded = cert.getEncoded();
            if (encoded.length < 257) {
                throw new IllegalArgumentException(String.format("Expected DER encoded cert to be at least %d bytes, was %d: %s", 257, encoded.length, cert));
            }
            encoded[encoded.length - 257] = 0;
            cert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(encoded));
        }
        return cert;
    }

    public static byte[] computeSubjectKeyIdentifier(Certificate cert) throws NoSuchAlgorithmException {
        byte[] spki = cert.getPublicKey().getEncoded();
        byte algLength = spki[3];
        int spkBitsStart = 6 + algLength + 1;
        return MessageDigest.getInstance("SHA-1").digest(Arrays.copyOfRange(spki, spkBitsStart, spki.length));
    }

    private static byte[] parseAaguid(byte[] bytes) {
        ByteBuffer buffer;
        if (bytes != null && bytes.length == 20 && (buffer = ByteBuffer.wrap(bytes)).get() == 4 && buffer.get() == 18 && buffer.get() == 4 && buffer.get() == 16) {
            byte[] aaguidBytes = new byte[16];
            buffer.get(aaguidBytes);
            return aaguidBytes;
        }
        throw new IllegalArgumentException("X.509 extension 1.3.6.1.4.1.45724.1.1.4 (id-fido-gen-ce-aaguid) is not valid.");
    }

    public static Optional<byte[]> parseFidoAaguidExtension(X509Certificate cert) {
        Optional<byte[]> result = Optional.ofNullable(cert.getExtensionValue(ID_FIDO_GEN_CE_AAGUID)).map(CertificateParser::parseAaguid);
        result.ifPresent(aaguid -> {
            if (cert.getCriticalExtensionOIDs().contains(ID_FIDO_GEN_CE_AAGUID)) {
                throw new IllegalArgumentException(String.format("X.509 extension %s (id-fido-gen-ce-aaguid) must not be marked critical.", ID_FIDO_GEN_CE_AAGUID));
            }
        });
        return result;
    }
}

