/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.okta.authn.sdk.client.AuthenticationClient;
import com.okta.authn.sdk.client.AuthenticationClientBuilder;
import com.okta.authn.sdk.client.AuthenticationClients;
import com.okta.commons.http.config.Proxy;
import com.okta.sdk.authc.credentials.ClientCredentials;
import com.okta.sdk.authc.credentials.TokenClientCredentials;
import com.okta.sdk.client.AuthorizationMode;
import com.okta.sdk.client.Client;
import com.okta.sdk.client.ClientBuilder;
import com.okta.sdk.client.Clients;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.model.support.okta.OktaAuthenticationProperties;
import org.apereo.cas.configuration.model.support.okta.OktaPrincipalAttributesProperties;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;

public class OktaConfigurationFactory {
    public static Client buildClient(OktaPrincipalAttributesProperties properties) {
        ClientBuilder clientBuilder = Clients.builder().setOrgUrl(properties.getOrganizationUrl()).setConnectionTimeout(properties.getConnectionTimeout());
        FunctionUtils.doIfNotNull((Object)properties.getApiToken(), token -> clientBuilder.setClientCredentials((ClientCredentials)new TokenClientCredentials(token)));
        FunctionUtils.doIfNotNull((Object)properties.getPrivateKey().getLocation(), path -> {
            String resource = IOUtils.toString((InputStream)path.getInputStream(), (Charset)StandardCharsets.UTF_8);
            clientBuilder.setAuthorizationMode(AuthorizationMode.PRIVATE_KEY).setPrivateKey(resource).setClientId(properties.getClientId()).setScopes((Set)CollectionUtils.wrapHashSet((Collection)properties.getScopes()));
        });
        if (StringUtils.isNotBlank((CharSequence)properties.getProxyHost()) && properties.getProxyPort() > 0) {
            if (StringUtils.isNotBlank((CharSequence)properties.getProxyUsername()) && StringUtils.isNotBlank((CharSequence)properties.getProxyPassword())) {
                clientBuilder.setProxy(new Proxy(properties.getProxyHost(), properties.getProxyPort(), properties.getProxyUsername(), properties.getProxyPassword()));
            } else {
                clientBuilder.setProxy(new Proxy(properties.getProxyHost(), properties.getProxyPort()));
            }
        }
        return clientBuilder.build();
    }

    public static AuthenticationClient buildAuthenticationClient(OktaAuthenticationProperties properties) {
        AuthenticationClientBuilder clientBuilder = AuthenticationClients.builder().setOrgUrl(properties.getOrganizationUrl()).setConnectionTimeout(properties.getConnectionTimeout());
        if (StringUtils.isNotBlank((CharSequence)properties.getProxyHost()) && properties.getProxyPort() > 0) {
            if (StringUtils.isNotBlank((CharSequence)properties.getProxyUsername()) && StringUtils.isNotBlank((CharSequence)properties.getProxyPassword())) {
                clientBuilder.setProxy(new Proxy(properties.getProxyHost(), properties.getProxyPort(), properties.getProxyUsername(), properties.getProxyPassword()));
            } else {
                clientBuilder.setProxy(new Proxy(properties.getProxyHost(), properties.getProxyPort()));
            }
        }
        return clientBuilder.build();
    }
}

